/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css;

import com.google.common.collect.Lists;
import cz.vutbr.web.css.MediaExpression;
import cz.vutbr.web.css.MediaQuery;
import cz.vutbr.web.css.MediaQueryList;
import cz.vutbr.web.css.MediaSpec;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.csskit.antlr.CSSParserFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Medium {
    private final Type type;
    private final Integer width;
    private final Integer height;
    private final Map<String, String> customFeatures;
    private static final Set<String> knownFeatures = new HashSet<String>(Arrays.asList("any-hover", "any-pointer", "aspect-ratio", "color", "color-gamut", "color-index", "device-aspect-ratio", "device-height", "device-width", "grid", "height", "hover", "monochrome", "orientation", "overflow-block", "overflow-inline", "pointer", "resolution", "scan", "update", "width"));
    private MediaSpec mediaSpec;

    private Medium(Type type, Integer width, Integer height, Map<String, String> customFeatures) {
        switch (type) {
            case EMBOSSED: {
                this.type = type;
                this.width = width;
                this.height = height;
                break;
            }
            case BRAILLE: 
            case SPEECH: 
            case SCREEN: 
            case PRINT: {
                if (width != null) {
                    throw new IllegalArgumentException("Unexpected 'width' argument for medium '" + (Object)((Object)type) + "'");
                }
                if (height != null) {
                    throw new IllegalArgumentException("Unexpected 'height' argument for medium '" + (Object)((Object)type) + "'");
                }
                this.type = type;
                this.height = null;
                this.width = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected medium: " + (Object)((Object)type));
            }
        }
        this.customFeatures = customFeatures != null ? Collections.unmodifiableMap(customFeatures) : Collections.emptyMap();
    }

    public Type getType() {
        return this.type;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Map<String, String> getCustomFeatures() {
        return this.customFeatures;
    }

    public boolean matches(String mediaQuery) {
        if (mediaQuery != null) {
            return this.asMediaSpec().matches((List)CSSParserFactory.getInstance().parseMediaQuery(mediaQuery.trim()));
        }
        return this.asMediaSpec().matchesEmpty();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.type.toString());
        if (this.width != null) {
            s.append(" AND (width: ").append(this.width).append(")");
        }
        if (this.height != null) {
            s.append(" AND (height: ").append(this.height).append(")");
        }
        for (String f : this.customFeatures.keySet()) {
            s.append(" AND (").append(f).append(": ").append(this.customFeatures.get(f)).append(")");
        }
        return s.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Medium)) {
            return false;
        }
        Medium that = (Medium)o;
        return this.type == that.type && this.width == that.width && this.height == that.height;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        return result;
    }

    public static Medium parse(String medium) throws IllegalArgumentException {
        MediaQueryList query = CSSParserFactory.getInstance().parseMediaQuery(medium);
        if (query.size() != 1) {
            throw new IllegalArgumentException("Unexpected medium: " + medium);
        }
        return Medium.fromMediaQuery((MediaQuery)query.get(0));
    }

    public static List<Medium> parseMultiple(String media) throws IllegalArgumentException {
        return Lists.transform((List)CSSParserFactory.getInstance().parseMediaQuery(media), Medium::fromMediaQuery);
    }

    private static Medium fromMediaQuery(MediaQuery query) throws IllegalArgumentException {
        Type type = null;
        try {
            type = Type.valueOf(query.getType().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unexpected medium type: " + query.getType());
        }
        if (query.isNegative()) {
            throw new IllegalArgumentException("Unexpected medium: contains NOT: " + query);
        }
        Integer width = null;
        Integer height = null;
        HashMap<String, String> customFeatures = null;
        for (MediaExpression e : query) {
            Term v;
            String feature = e.getFeature();
            if ("width".equals(feature) || "height".equals(feature)) {
                if (e.size() != 1) {
                    throw new IllegalArgumentException("Unexpected value for medium feature: " + e);
                }
                v = (Term)e.get(0);
                if (!(v instanceof TermInteger)) {
                    throw new IllegalArgumentException("Unexpected value for medium feature: " + e);
                }
                Integer i = ((TermInteger)v).getIntValue();
                if ("width".equals(feature)) {
                    width = i;
                    continue;
                }
                height = i;
                continue;
            }
            if (knownFeatures.contains(feature)) {
                throw new IllegalArgumentException("Unsupported medium feature: " + feature);
            }
            if (e.size() != 1) {
                throw new IllegalArgumentException("Unexpected value for medium feature: " + e);
            }
            v = (Term)e.get(0);
            if (!(v instanceof TermIdent) && !(v instanceof TermInteger)) {
                throw new IllegalArgumentException("Unexpected value for medium feature: " + e);
            }
            if (customFeatures == null) {
                customFeatures = new HashMap<String, String>();
            }
            customFeatures.put(feature, v.toString());
        }
        return new Medium(type, width, height, customFeatures);
    }

    public MediaSpec asMediaSpec() {
        if (this.mediaSpec == null) {
            switch (this.type) {
                case EMBOSSED: {
                    this.mediaSpec = new MediaSpec(this.type.toString()){

                        protected Float getExpressionLengthPx(MediaExpression e) {
                            return Float.valueOf(this.getExpressionInteger(e).intValue());
                        }

                        public boolean matches(MediaExpression e) {
                            String f = e.getFeature();
                            if (knownFeatures.contains(f) || knownFeatures.contains(f.replaceAll("^(min|max)-", ""))) {
                                return super.matches(e);
                            }
                            if (e.size() != 1) {
                                return false;
                            }
                            Term v = (Term)e.get(0);
                            if (!(v instanceof TermIdent) && !(v instanceof TermInteger)) {
                                return false;
                            }
                            if (!Medium.this.customFeatures.isEmpty()) {
                                for (String ff : Medium.this.customFeatures.keySet()) {
                                    if (!ff.equals(f)) continue;
                                    return ((String)Medium.this.customFeatures.get(ff)).equals(v.toString());
                                }
                            }
                            return false;
                        }
                    };
                    if (this.width != null) {
                        this.mediaSpec.setWidth((float)this.width.intValue());
                    }
                    if (this.height == null) break;
                    this.mediaSpec.setWidth((float)this.height.intValue());
                    break;
                }
                default: {
                    this.mediaSpec = new MediaSpec(this.type.toString()){

                        public boolean matches(MediaExpression e) {
                            String f = e.getFeature();
                            if (knownFeatures.contains(f) || knownFeatures.contains(f.replaceAll("^(min|max)-", ""))) {
                                return super.matches(e);
                            }
                            if (e.size() != 1) {
                                return false;
                            }
                            Term v = (Term)e.get(0);
                            if (!(v instanceof TermIdent) && !(v instanceof TermInteger)) {
                                return false;
                            }
                            if (!Medium.this.customFeatures.isEmpty()) {
                                for (String ff : Medium.this.customFeatures.keySet()) {
                                    if (!ff.equals(f)) continue;
                                    return ((String)Medium.this.customFeatures.get(ff)).equals(v.toString());
                                }
                            }
                            return false;
                        }
                    };
                }
            }
        }
        return this.mediaSpec;
    }

    public static enum Type {
        EMBOSSED,
        BRAILLE,
        SPEECH,
        SCREEN,
        PRINT;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

