/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css;

import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermNumber;
import cz.vutbr.web.css.TermPair;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.css.TermString;
import cz.vutbr.web.css.TermURI;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.function.Function;
import org.daisy.common.file.URLs;

public final class CssSerializer {
    private CssSerializer() {
    }

    public static String toString(Term<?> term) {
        return CssSerializer.toString(term, t -> CssSerializer.toString(t));
    }

    public static String toString(Term<?> term, Function<Term<?>, String> toStringFunction) {
        if (term instanceof TermInteger) {
            TermInteger integer = (TermInteger)term;
            return "" + integer.getIntValue();
        }
        if (term instanceof TermNumber) {
            TermNumber number = (TermNumber)term;
            Double value = ((Float)number.getValue()).doubleValue();
            if (value == Math.floor(value)) {
                return "" + value.intValue();
            }
            return "" + value;
        }
        if (term instanceof TermPercent) {
            TermPercent percent = (TermPercent)term;
            Double value = ((Float)percent.getValue()).doubleValue();
            if (value == Math.floor(value)) {
                return "" + value.intValue() + "%";
            }
            return "" + value + "%";
        }
        if (term instanceof TermList || term instanceof Declaration) {
            String s = CssSerializer.serializeTermList((List)term, toStringFunction);
            if (term instanceof TermFunction) {
                TermFunction function = (TermFunction)term;
                s = function.getFunctionName() + "(" + s + ")";
            }
            return s;
        }
        if (term instanceof TermPair) {
            TermPair pair = (TermPair)term;
            Object val = pair.getValue();
            return "" + pair.getKey() + " " + (val instanceof Term ? CssSerializer.toString((Term)val, toStringFunction) : val.toString());
        }
        if (term instanceof TermURI) {
            TermURI termURI = (TermURI)term;
            URI uri = URLs.asURI((String)((String)termURI.getValue()));
            if (termURI.getBase() != null) {
                uri = URLs.resolve((URI)URLs.asURI((URL)termURI.getBase()), (URI)uri);
            }
            return "url(\"" + uri + "\")";
        }
        if (term instanceof TermString) {
            TermString string = (TermString)term;
            return "'" + ((String)string.getValue()).replaceAll("\n", "\\\\A ").replaceAll("'", "\\\\27 ") + "'";
        }
        return term.toString().replaceAll("^[,/ ]+", "");
    }

    public static String serializeTermList(List<Term<?>> termList) {
        return CssSerializer.serializeTermList(termList, t -> CssSerializer.toString(t));
    }

    public static String serializeTermList(List<Term<?>> termList, Function<Term<?>, String> toStringFunction) {
        String s = "";
        for (Term<?> t : termList) {
            if (!s.isEmpty()) {
                Term.Operator o = t.getOperator();
                if (o != null) {
                    switch (o) {
                        case COMMA: {
                            s = s + ",";
                        }
                    }
                }
                s = s + " ";
            }
            s = s + toStringFunction.apply(t);
        }
        return s;
    }
}

