/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.css;

import com.google.common.collect.Iterables;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.daisy.braille.css.InlineStyle;
import org.daisy.braille.css.RuleCounterStyle;
import org.daisy.pipeline.css.CssSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unbescape.css.CssEscape;

public class CounterStyle {
    private static final Logger logger = LoggerFactory.getLogger(CounterStyle.class);
    private static final Map<String, CounterStyle> predefinedCounterStyles = CounterStyle.parseCounterStyleRules(Iterables.filter((Iterable)new InlineStyle("@counter-style decimal {\n   system: numeric;\n   symbols: '0' '1' '2' '3' '4' '5' '6' '7' '8' '9';\n   negative: '-';\n}\n@counter-style lower-alpha {\n   system: alphabetic;\n   symbols: 'a' 'b' 'c' 'd' 'e' 'f' 'g' 'h' 'i' 'j'\n            'k' 'l' 'm' 'n' 'o' 'p' 'q' 'r' 's' 't'\n            'u' 'v' 'w' 'x' 'y' 'z';\n}\n@counter-style upper-alpha {\n   system: alphabetic;\n   symbols: 'A' 'B' 'C' 'D' 'E' 'F' 'G' 'H' 'I' 'J'\n            'K' 'L' 'M' 'N' 'O' 'P' 'Q' 'R' 'S' 'T'\n            'U' 'V' 'W' 'X' 'Y' 'Z';\n}\n@counter-style lower-roman {\n   system: additive;\n   range: 1 3999;\n   additive-symbols: 1000 'm', 900 'cm', 500 'd', 400 'cd',\n                     100 'c', 90 'xc', 50 'l', 40 'xl',\n                     10 'x', 9 'ix', 5 'v', 4 'iv', 1 'i';\n}\n@counter-style upper-roman {\n   system: additive;\n   range: 1 3999;\n   additive-symbols: 1000 'M', 900 'CM', 500 'D', 400 'CD',\n                     100 'C', 90 'XC', 50 'L', 40 'XL',\n                     10 'X', 9 'IX', 5 'V', 4 'IV', 1 'I';\n}\n@counter-style disc {\n   system: cyclic;\n   symbols: '\\2022';\n   suffix: ' ';\n}"), RuleCounterStyle.class));
    public static final CounterStyle DECIMAL = predefinedCounterStyles.get("decimal");
    public static final CounterStyle LOWER_ALPHA = predefinedCounterStyles.get("lower-alpha");
    public static final CounterStyle UPPER_ALPHA = predefinedCounterStyles.get("upper-alpha");
    public static final CounterStyle LOWER_ROMAN = predefinedCounterStyles.get("lower-roman");
    public static final CounterStyle UPPER_ROMAN = predefinedCounterStyles.get("upper-roman");
    public static final CounterStyle DISC = predefinedCounterStyles.get("disc");
    private final System system;
    private final List<String> symbols;
    private final List<AdditiveTuple> additiveSymbols;
    private final String negative;
    private final Supplier<CounterStyle> fallback;
    private final String prefix;
    private final String suffix;
    private static final Map<String, CounterStyle> fromSymbolsCache = new HashMap<String, CounterStyle>();

    private CounterStyle(TermFunction term) throws IllegalArgumentException {
        Object symbols;
        System system;
        if (term.size() > 0 && term.get(0) instanceof TermIdent) {
            system = CounterStyle.readSystem((TermIdent)term.get(0));
            if (system == System.ADDITIVE) {
                throw new IllegalArgumentException("system 'additive' not supported in symbols() function");
            }
            symbols = term.subList(1, term.size());
        } else {
            system = System.SYMBOLIC;
            symbols = term;
        }
        this.symbols = CounterStyle.readSymbols(symbols);
        this.additiveSymbols = null;
        this.system = system;
        this.negative = "-";
        this.fallback = () -> DECIMAL;
        this.prefix = "";
        this.suffix = " ";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CounterStyle(RuleCounterStyle rule, Map<String, CounterStyle> fallbacks) throws IllegalArgumentException {
        List<AdditiveTuple> additiveSymbols;
        List<String> symbols;
        Declaration systemDecl = null;
        Declaration symbolsDecl = null;
        Declaration additiveSymbolsDecl = null;
        Declaration negativeDecl = null;
        Declaration fallbackDecl = null;
        Declaration prefixDecl = null;
        Declaration suffixDecl = null;
        for (Declaration d : rule) {
            String prop = d.getProperty();
            if ("system".equals(prop)) {
                if (systemDecl != null) continue;
                systemDecl = d;
                continue;
            }
            if ("symbols".equals(prop)) {
                if (symbolsDecl != null) continue;
                symbolsDecl = d;
                continue;
            }
            if ("additive-symbols".equals(prop)) {
                if (additiveSymbolsDecl != null) continue;
                additiveSymbolsDecl = d;
                continue;
            }
            if ("negative".equals(prop)) {
                if (negativeDecl != null) continue;
                negativeDecl = d;
                continue;
            }
            if ("fallback".equals(prop)) {
                if (fallbackDecl != null) continue;
                fallbackDecl = d;
                continue;
            }
            if ("prefix".equals(prop)) {
                if (prefixDecl != null) continue;
                prefixDecl = d;
                continue;
            }
            if (!"suffix".equals(prop) || suffixDecl != null) continue;
            suffixDecl = d;
        }
        System system = null;
        if (systemDecl != null) {
            try {
                system = CounterStyle.readSystem(systemDecl);
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage());
            }
        }
        if (system == null) {
            system = System.SYMBOLIC;
        }
        if (system != System.ADDITIVE) {
            if (symbolsDecl == null) throw new IllegalArgumentException("Missing symbols descriptor");
            symbols = CounterStyle.readSymbols(symbolsDecl);
        } else {
            symbols = null;
        }
        if (system == System.ADDITIVE) {
            if (additiveSymbolsDecl == null) throw new IllegalArgumentException("Missing symbols descriptor");
            additiveSymbols = CounterStyle.readAdditiveSymbols(additiveSymbolsDecl);
        } else {
            additiveSymbols = null;
        }
        String negative = null;
        if (negativeDecl != null) {
            try {
                negative = (String)CounterStyle.readSingleString("negative", negativeDecl).getValue();
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage());
            }
        }
        if (negative == null) {
            negative = "-";
        }
        String ident = null;
        if (fallbackDecl != null) {
            try {
                ident = (String)CounterStyle.readSingleIdent("fallback", fallbackDecl).getValue();
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage());
            }
        }
        if (ident == null) {
            ident = "decimal";
        }
        String fallback = ident;
        String prefix = null;
        if (prefixDecl != null) {
            try {
                prefix = (String)CounterStyle.readSingleString("prefix", prefixDecl).getValue();
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage());
            }
        }
        if (prefix == null) {
            prefix = "";
        }
        String suffix = null;
        if (suffixDecl != null) {
            try {
                suffix = (String)CounterStyle.readSingleString("suffix", suffixDecl).getValue();
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage());
            }
        }
        if (suffix == null) {
            suffix = ". ";
        }
        this.system = system;
        this.symbols = symbols;
        this.additiveSymbols = additiveSymbols;
        this.negative = negative;
        this.fallback = CounterStyle.memoize(() -> {
            if (fallbacks != null && fallbacks.containsKey(fallback)) {
                return (CounterStyle)fallbacks.get(fallback);
            }
            if (predefinedCounterStyles.containsKey(fallback)) {
                return predefinedCounterStyles.get(fallback);
            }
            return DECIMAL;
        });
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public static CounterStyle fromSymbolsFunction(Term<?> term) throws IllegalArgumentException {
        TermFunction function;
        if (term instanceof TermFunction && (function = (TermFunction)term).getFunctionName().equals("symbols")) {
            String k = function.toString();
            CounterStyle s = fromSymbolsCache.get(k);
            if (s == null) {
                s = new CounterStyle(function);
                fromSymbolsCache.put(k, s);
            }
            return s;
        }
        throw new IllegalArgumentException("argument must be a symbols() function");
    }

    public static Map<String, CounterStyle> parseCounterStyleRules(Iterable<RuleCounterStyle> style) {
        HashMap<String, CounterStyle> namedStyles = new HashMap<String, CounterStyle>();
        for (RuleCounterStyle rule : style) {
            try {
                namedStyles.put(rule.getName(), new CounterStyle(rule, namedStyles));
            }
            catch (IllegalArgumentException e) {
                logger.warn(e.getMessage());
            }
        }
        return namedStyles;
    }

    public String format(int counterValue) {
        switch (this.system) {
            case ALPHABETIC: {
                Optional<String> formatted = CounterStyle.counterRepresentationAlphabetic(counterValue, this.symbols);
                if (!formatted.isPresent()) break;
                return formatted.get();
            }
            case NUMERIC: {
                return CounterStyle.counterRepresentationNumeric(counterValue, this.symbols, this.negative);
            }
            case CYCLIC: {
                return CounterStyle.counterRepresentationCyclic(counterValue, this.symbols);
            }
            case FIXED: {
                Optional<String> formatted = CounterStyle.counterRepresentationFixed(counterValue, this.symbols);
                if (!formatted.isPresent()) break;
                return formatted.get();
            }
            case SYMBOLIC: {
                Optional<String> formatted = CounterStyle.counterRepresentationSymbolic(counterValue, this.symbols);
                if (!formatted.isPresent()) break;
                return formatted.get();
            }
            case ADDITIVE: {
                Optional<String> formatted = CounterStyle.counterRepresentationAdditive(counterValue, this.additiveSymbols);
                if (!formatted.isPresent()) break;
                return formatted.get();
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (this.fallback.get() == null || this.fallback.get() == this) {
            throw new IllegalStateException();
        }
        return this.fallback.get().format(counterValue);
    }

    public String format(int counterValue, boolean withPrefixAndSuffix) {
        if (withPrefixAndSuffix) {
            return this.prefix + this.format(counterValue) + this.suffix;
        }
        return this.format(counterValue);
    }

    private static System readSystem(List<Term<?>> terms) throws IllegalArgumentException {
        return CounterStyle.readSystem(CounterStyle.readSingleIdent("system", terms));
    }

    private static System readSystem(TermIdent ident) throws IllegalArgumentException {
        String system = (String)ident.getValue();
        try {
            return System.valueOf(system.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid system: " + system);
        }
    }

    private static List<String> readSymbols(List<Term<?>> terms) throws IllegalArgumentException {
        ArrayList<String> symbols = new ArrayList<String>();
        for (Term<?> t : terms) {
            if (t instanceof TermString) {
                symbols.add((String)((TermString)t).getValue());
                continue;
            }
            if (t instanceof TermIdent) {
                symbols.add(CssEscape.unescapeCss((String)((String)((TermIdent)t).getValue())));
                continue;
            }
            throw new IllegalArgumentException("Invalid symbol: " + t);
        }
        if (symbols.isEmpty()) {
            throw new IllegalArgumentException("Empty symbols list");
        }
        return symbols;
    }

    private static List<AdditiveTuple> readAdditiveSymbols(List<Term<?>> terms) throws IllegalArgumentException {
        ArrayList<AdditiveTuple> symbols = new ArrayList<AdditiveTuple>();
        Iterator<Term<?>> tt = terms.iterator();
        int prevWeight = -1;
        while (tt.hasNext()) {
            Term<?> t = tt.next();
            if (t instanceof TermInteger) {
                int weight = ((TermInteger)t).getIntValue();
                if (prevWeight >= 0 && weight > prevWeight) {
                    throw new IllegalArgumentException("Invalid additive tuple: expected integer weight greater than " + prevWeight + " but got " + t);
                }
                prevWeight = weight;
                if (tt.hasNext()) {
                    t = tt.next();
                    if (t instanceof TermString) {
                        String symbol = (String)((TermString)t).getValue();
                        symbols.add(new AdditiveTuple(weight, symbol));
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid additive tuple: expected symbol but got " + t);
                }
                throw new IllegalArgumentException("Invalid additive tuple: expected symbol");
            }
            throw new IllegalArgumentException("Invalid additive tuple: expected integer weight but got " + t);
        }
        if (symbols.isEmpty()) {
            throw new IllegalArgumentException("Empty additive-symbols list");
        }
        return symbols;
    }

    private static TermIdent readSingleIdent(String property, List<Term<?>> terms) throws IllegalArgumentException {
        if (terms.size() != 1 || !(terms.get(0) instanceof TermIdent)) {
            throw new IllegalArgumentException("Invalid " + property + ": " + CssSerializer.serializeTermList(terms));
        }
        return (TermIdent)terms.get(0);
    }

    private static TermString readSingleString(String property, List<Term<?>> terms) throws IllegalArgumentException {
        if (terms.size() != 1 || !(terms.get(0) instanceof TermString)) {
            throw new IllegalArgumentException("Invalid " + property + ": " + CssSerializer.serializeTermList(terms));
        }
        return (TermString)terms.get(0);
    }

    private static int mod(int a, int n) {
        int result = a % n;
        if (result < 0) {
            result += n;
        }
        return result;
    }

    private static <T> Supplier<T> memoize(final Supplier<T> supplier) {
        return new Memoize<T>(){

            @Override
            protected T _get() {
                return supplier.get();
            }

            public String toString() {
                return "memoize( " + supplier + " )";
            }
        };
    }

    static Optional<String> counterRepresentationAlphabetic(int counterValue, List<String> symbols) {
        if (counterValue < 1) {
            return Optional.empty();
        }
        if (counterValue > symbols.size()) {
            return Optional.of(CounterStyle.counterRepresentationAlphabetic((counterValue - 1) / symbols.size(), symbols).get() + symbols.get(CounterStyle.mod(counterValue - 1, symbols.size())));
        }
        return Optional.of(symbols.get(counterValue - 1));
    }

    static String counterRepresentationCyclic(int counterValue, List<String> symbols) {
        return symbols.get(CounterStyle.mod(counterValue - 1, symbols.size()));
    }

    static Optional<String> counterRepresentationFixed(int counterValue, List<String> symbols) {
        if (counterValue < 1 || counterValue > symbols.size()) {
            return Optional.empty();
        }
        return Optional.of(symbols.get(counterValue - 1));
    }

    static String counterRepresentationNumeric(int counterValue, List<String> symbols, String negative) {
        if (counterValue < 0) {
            return negative + CounterStyle.counterRepresentationNumeric(-counterValue, symbols, negative);
        }
        if (counterValue >= symbols.size()) {
            return CounterStyle.counterRepresentationNumeric(counterValue / symbols.size(), symbols, negative) + symbols.get(CounterStyle.mod(counterValue, symbols.size()));
        }
        return symbols.get(counterValue);
    }

    static Optional<String> counterRepresentationSymbolic(int counterValue, List<String> symbols) {
        String symbol;
        if (counterValue < 1) {
            return Optional.empty();
        }
        String s = symbol = symbols.get(CounterStyle.mod(counterValue - 1, symbols.size()));
        for (int i = 0; i < (counterValue - 1) / symbols.size(); ++i) {
            s = s + symbol;
        }
        return Optional.of(s);
    }

    static Optional<String> counterRepresentationAdditive(int counterValue, List<AdditiveTuple> symbols) {
        if (counterValue < 0) {
            return Optional.empty();
        }
        int rest = counterValue;
        String s = "";
        for (AdditiveTuple tuple : symbols) {
            if (tuple.weight == 0) {
                if (rest != 0 || !s.isEmpty()) continue;
                s = s + tuple.symbol;
                continue;
            }
            for (int i = 0; i < rest / tuple.weight; ++i) {
                s = s + tuple.symbol;
            }
            if ((rest = CounterStyle.mod(rest, tuple.weight)) != 0 || s.isEmpty()) continue;
            break;
        }
        if (rest != 0 || s.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(s);
    }

    private static abstract class Memoize<T>
    implements Supplier<T> {
        private boolean computed = false;
        private T value = null;

        private Memoize() {
        }

        protected abstract T _get();

        @Override
        public final T get() {
            if (!this.computed) {
                this.value = this._get();
                this.computed = true;
            }
            return this.value;
        }
    }

    private static class AdditiveTuple {
        final int weight;
        final String symbol;

        AdditiveTuple(int weight, String symbol) {
            this.weight = weight;
            this.symbol = symbol;
        }
    }

    private static enum System {
        ALPHABETIC,
        NUMERIC,
        CYCLIC,
        FIXED,
        SYMBOLIC,
        ADDITIVE;

    }
}

