/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.URIUtils;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.StandardModuleURIResolver;
import net.sf.saxon.lib.StandardUnparsedTextResolver;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import org.xmlresolver.CatalogSource;
import org.xmlresolver.Resolver;

public class XProcURIResolver
implements URIResolver,
EntityResolver,
ModuleURIResolver,
UnparsedTextURIResolver {
    private Logger logger = LoggerFactory.getLogger(XProcURIResolver.class);
    private URIResolver uriResolver = null;
    private EntityResolver entityResolver = null;
    private ModuleURIResolver moduleURIResolver = null;
    private UnparsedTextURIResolver unparsedTextResolver = null;
    private XProcRuntime runtime = null;
    private Hashtable<String, XdmNode> cache = new Hashtable();
    private Resolver catalogResolver = null;
    private static boolean useCache = true;

    public XProcURIResolver(XProcRuntime runtime) {
        this.runtime = runtime;
    }

    public void setUnderlyingURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
        if (this.catalogResolver == null && resolver instanceof Resolver) {
            this.catalogResolver = (Resolver)resolver;
        }
    }

    public URIResolver getUnderlyingURIResolver() {
        return this.uriResolver;
    }

    public void setUnderlyingEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public EntityResolver getUnderlyingEntityResolver() {
        return this.entityResolver;
    }

    public void setUnderlyingUnparsedTextURIResolver(UnparsedTextURIResolver resolver) {
        this.unparsedTextResolver = resolver;
    }

    public UnparsedTextURIResolver getUnderlyingUnparsedTextURIResolver() {
        return this.unparsedTextResolver;
    }

    public void setUnderlyingModuleURIResolver(ModuleURIResolver resolver) {
        this.moduleURIResolver = resolver;
    }

    public ModuleURIResolver getUnderlyingModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public void addCatalogs(List<String> catalogs) {
        if (this.catalogResolver != null) {
            for (String catalog : catalogs) {
                this.logger.debug("Adding catalog to resolver: " + catalog);
                try {
                    URL cat = new URL(catalog);
                    InputSource source = new InputSource(cat.openStream());
                    source.setSystemId(catalog);
                    CatalogSource.InputSourceCatalogSource catsource = new CatalogSource.InputSourceCatalogSource(source);
                    this.catalogResolver.getCatalog().addSource((CatalogSource)catsource);
                }
                catch (MalformedURLException e) {
                    this.logger.info("Malformed catalog URI in jar file: " + catalog);
                }
                catch (IOException e) {
                    this.logger.info("I/O error reading catalog URI in jar file: " + catalog);
                }
            }
        } else {
            this.logger.info("Not adding catalogs to resolver, no catalog resolver is known");
        }
    }

    public void cache(XdmNode doc, URI baseURI) {
        XdmNode root = S9apiUtils.getDocumentElement(doc);
        URI docURI = baseURI.resolve(root.getBaseURI());
        if (useCache) {
            this.cache.put(docURI.toASCIIString(), doc);
        }
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        this.logger.trace("URIResolver(" + href + "," + base + ")");
        String uri = null;
        if (base == null) {
            try {
                URL url = new URL(href);
                uri = url.toURI().toASCIIString();
            }
            catch (MalformedURLException mue) {
                this.logger.trace("MalformedURLException on " + href);
            }
            catch (URISyntaxException use) {
                this.logger.trace("URISyntaxException on " + href);
            }
        } else {
            try {
                URI baseURI = new URI(base);
                uri = baseURI.resolve(href).toASCIIString();
            }
            catch (URISyntaxException use) {
                this.logger.trace("URISyntaxException resolving base and href: " + base + " : " + href);
            }
        }
        this.logger.trace("Resolved: " + uri);
        if (this.cache.containsKey(uri)) {
            this.logger.trace("Returning cached document.");
            return this.cache.get(uri).asSource();
        }
        if (this.uriResolver != null) {
            SAXSource ssource;
            XMLReader reader;
            this.logger.trace("uriResolver.resolve(" + href + "," + base + ")");
            Source resolved = this.uriResolver.resolve(href, base);
            if (resolved != null && resolved instanceof SAXSource && (reader = (ssource = (SAXSource)resolved).getXMLReader()) == null) {
                try {
                    SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                    saxParserFactory.setNamespaceAware(true);
                    reader = saxParserFactory.newSAXParser().getXMLReader();
                    reader.setEntityResolver(this);
                    ssource.setXMLReader(reader);
                }
                catch (SAXException sAXException) {
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
            return resolved;
        }
        return null;
    }

    public XdmNode parse(String href, String base) {
        return this.parse(href, base, false);
    }

    public XdmNode parse(String href, String base, boolean dtdValidate) {
        Source source = null;
        href = URIUtils.encode(href);
        this.logger.trace("Attempting to parse: " + href + " (" + base + ")");
        try {
            source = this.resolve(href, base);
        }
        catch (TransformerException te) {
            throw XProcException.dynamicError(9, te);
        }
        if (source == null) {
            try {
                XMLReader reader;
                URI resURI = new URI(href);
                if (!resURI.isAbsolute()) {
                    URI baseURI = new URI(base);
                    String path = baseURI.toASCIIString();
                    int pos = path.indexOf("!");
                    if (pos > 0 && (path.startsWith("jar:file:") || path.startsWith("jar:http:") || path.startsWith("jar:https:"))) {
                        String fakeURIstr = "http://example.com";
                        String subpath = path.substring(pos + 1);
                        fakeURIstr = subpath.startsWith("/") ? fakeURIstr + subpath : fakeURIstr + "/" + subpath;
                        URI fakeURI = new URI(fakeURIstr);
                        resURI = fakeURI.resolve(href);
                        fakeURIstr = path.substring(0, pos + 1) + resURI.getPath();
                        resURI = new URI(fakeURIstr);
                    } else {
                        resURI = baseURI.resolve(href);
                    }
                }
                if ((reader = ((SAXSource)(source = new SAXSource(new InputSource(resURI.toASCIIString())))).getXMLReader()) == null) {
                    try {
                        reader = XMLReaderFactory.createXMLReader();
                        ((SAXSource)source).setXMLReader(reader);
                        reader.setEntityResolver(this);
                    }
                    catch (SAXException path) {}
                }
            }
            catch (URISyntaxException use) {
                throw new XProcException(use);
            }
        }
        DocumentBuilder builder = this.runtime.getProcessor().newDocumentBuilder();
        builder.setDTDValidation(dtdValidate);
        builder.setLineNumbering(true);
        builder.setTreeModel(TreeModel.getTreeModel((int)this.runtime.getProcessor().getUnderlyingConfiguration().getTreeModel()));
        try {
            return builder.build(source);
        }
        catch (SaxonApiException sae) {
            String msg = sae.getMessage();
            if (msg.contains("validation")) {
                throw XProcException.stepError(27, sae);
            }
            if (msg.contains("HTTP response code: 403 ")) {
                throw XProcException.dynamicError(21);
            }
            throw XProcException.dynamicError(11, sae);
        }
    }

    public XdmNode parse(InputSource isource) {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setEntityResolver(this);
            SAXSource source = new SAXSource(reader, isource);
            DocumentBuilder builder = this.runtime.getProcessor().newDocumentBuilder();
            builder.setLineNumbering(true);
            builder.setDTDValidation(false);
            builder.setTreeModel(TreeModel.getTreeModel((int)this.runtime.getProcessor().getUnderlyingConfiguration().getTreeModel()));
            return builder.build((Source)source);
        }
        catch (SaxonApiException sae) {
            String msg = sae.getMessage();
            if (msg.contains("validation")) {
                throw XProcException.stepError(27, sae);
            }
            if (msg.contains("HTTP response code: 403 ")) {
                throw XProcException.dynamicError(21);
            }
            throw XProcException.dynamicError(11, sae);
        }
        catch (SAXException e) {
            throw new XProcException(e);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.logger.trace("ResolveEntity(" + publicId + "," + systemId + ")");
        if (systemId == null) {
            return null;
        }
        try {
            URI baseURI = new URI(systemId);
            String uri = baseURI.toASCIIString();
            if (this.cache.containsKey(uri)) {
                this.logger.trace("Returning cached document.");
                return S9apiUtils.xdmToInputSource(this.runtime, this.cache.get(uri));
            }
        }
        catch (URISyntaxException use) {
            this.logger.trace("URISyntaxException resolving entityResolver systemId: " + systemId);
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
        if (this.entityResolver != null) {
            InputSource r = this.entityResolver.resolveEntity(publicId, systemId);
            return r;
        }
        return null;
    }

    public StreamSource[] resolve(String moduleURI, String baseURI, String[] locations) throws XPathException {
        if (this.moduleURIResolver != null) {
            return this.moduleURIResolver.resolve(moduleURI, baseURI, locations);
        }
        StandardModuleURIResolver resolver = new StandardModuleURIResolver();
        return resolver.resolve(moduleURI, baseURI, locations);
    }

    public Reader resolve(URI uri, String encoding, Configuration configuration) throws XPathException {
        if (this.unparsedTextResolver == null) {
            this.unparsedTextResolver = new StandardUnparsedTextResolver();
        }
        return this.unparsedTextResolver.resolve(uri, encoding, configuration);
    }
}

