/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPointerScheme {
    protected QName schemeName = null;
    protected String schemeData = null;
    protected Logger logger = null;
    private int readLimit = 0;
    private static final Pattern rangeRE = Pattern.compile("^.*?=(\\d*)?(,(\\d*)?)?$");
    private static final Pattern lengthRE = Pattern.compile("^length=(\\d+)(,[^;]*)?(.*)$");
    private static final Pattern leadingWhitespaceRE = Pattern.compile("^(\\s*)(\\S.*)$");
    private static final int INCLUDE_MATCH = 0;
    private static final int EXCLUDE_MATCH = 1;
    private static final int TRIM = 2;
    private long sp = -1L;
    private long ep = -1L;
    private boolean chars = false;
    private long cp = -1L;
    private long lp = -1L;

    private XPointerScheme() {
    }

    public QName getName() {
        return this.schemeName;
    }

    public String getData() {
        return this.schemeData;
    }

    protected XPointerScheme(QName name, String data, int readLimit) {
        this.readLimit = readLimit;
        this.schemeName = name;
        this.schemeData = data;
        this.logger = LoggerFactory.getLogger(XPointerScheme.class);
    }

    public String xpathEquivalent() {
        return null;
    }

    public String textEquivalent() {
        return null;
    }

    public Vector<XdmNode> selectNodes(XProcRuntime runtime, XdmNode doc, Hashtable<String, String> nsBindings) {
        String select = this.xpathEquivalent();
        if (select == null) {
            throw new XProcException("XPointer cannot be used to select nodes: " + this.schemeName + "(" + this.schemeData + ")");
        }
        Vector<XdmNode> selectedNodes = new Vector<XdmNode>();
        XPathSelector selector = null;
        XPathCompiler xcomp = runtime.getProcessor().newXPathCompiler();
        for (String prefix : nsBindings.keySet()) {
            xcomp.declareNamespace(prefix, nsBindings.get(prefix));
        }
        try {
            XPathExecutable xexec = xcomp.compile(select);
            selector = xexec.load();
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
        try {
            selector.setContextItem((XdmItem)doc);
            for (XdmItem item : selector) {
                XdmNode node = null;
                try {
                    node = (XdmNode)item;
                }
                catch (ClassCastException cce) {
                    throw new XProcException("XPointer matched non-node item?: " + this.schemeName + "(" + this.schemeData + ")");
                }
                selectedNodes.add(node);
            }
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
        return selectedNodes;
    }

    protected String selectText(BufferedReader rd, int contentLength) {
        String select = this.textEquivalent();
        if (select == null) {
            throw new XProcException("XPointer cannot be used to select text: " + this.schemeName + "(" + this.schemeData + ")");
        }
        String data = "";
        try {
            String line;
            rd.mark(this.readLimit);
            String[] parts = select.split("\\s*;\\s*");
            for (int pos = 1; pos < parts.length; ++pos) {
                int checklen;
                String check = parts[pos];
                Matcher matcher = lengthRE.matcher(check);
                if (contentLength < 0 || !matcher.matches() || (checklen = Integer.parseInt(matcher.group(1))) == contentLength) continue;
                throw new IllegalArgumentException("Integrity check failed: " + checklen + " != " + contentLength);
            }
            select = parts[0];
            select = select.trim();
            this.sp = -1L;
            this.ep = Long.MAX_VALUE;
            this.cp = 0L;
            this.lp = 0L;
            Matcher matcher = rangeRE.matcher(select);
            if (matcher.matches()) {
                String r = matcher.group(1);
                if (r != null && !"".equals(r)) {
                    this.sp = Integer.parseInt(r);
                }
                if ((r = matcher.group(3)) != null && !"".equals(r)) {
                    this.ep = Integer.parseInt(r);
                }
            }
            if (select.startsWith("char=")) {
                this.chars = true;
            } else if (select.startsWith("line=")) {
                this.chars = false;
            } else {
                throw new XProcException("Unparseable XPointer: " + this.schemeName + "(" + this.schemeData + ")");
            }
            while ((line = rd.readLine()) != null) {
                if (this.chars) {
                    data = data + this.selectChars(line);
                    continue;
                }
                data = data + this.selectLines(line);
            }
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
        finally {
            try {
                rd.reset();
            }
            catch (IOException iOException) {}
        }
        return data;
    }

    private String selectChars(String line) {
        String data = "";
        long endcp = this.cp + (long)line.length() + 1L;
        if (this.cp < this.sp && endcp > this.sp) {
            line = line.substring((int)(this.sp - this.cp));
            this.cp = this.sp;
        }
        if (this.cp >= this.sp && this.cp < this.ep) {
            long rest = this.ep - this.cp;
            if (rest > (long)line.length()) {
                data = line + "\n";
                this.cp = endcp;
            } else {
                data = data + line.substring(0, (int)rest);
                this.cp += rest;
            }
        }
        this.cp = endcp;
        return data;
    }

    private String selectLines(String line) {
        String data = "";
        if (this.lp >= this.sp && this.lp < this.ep) {
            data = line + "\n";
        }
        ++this.lp;
        return data;
    }

    public String selectSearchText(BufferedReader rd, int contentLength) {
        int pos;
        String select = this.textEquivalent();
        if (select == null) {
            throw new XProcException("XPointer cannot be used to select text: " + this.schemeName + "(" + this.schemeData + ")");
        }
        Matcher matcher = null;
        String origSelect = select;
        String startSearch = null;
        int startOpt = 0;
        int startCount = 1;
        String endSearch = null;
        int endOpt = 0;
        int endCount = 1;
        boolean found = false;
        boolean strip = false;
        int stripWS = Integer.MAX_VALUE;
        if ("".equals(select = select.substring(7).trim())) {
            this.malformedSearch("at least one of start/end required", origSelect);
        }
        String skip = "";
        char ch = select.charAt(0);
        if (ch == ',') {
            select = select.substring(1);
        } else {
            while (Character.isDigit(ch)) {
                skip = skip + ch;
                if ("".equals(select = select.substring(1))) {
                    this.malformedSearch("start must specify a search string", origSelect);
                }
                ch = select.charAt(0);
            }
            if (!"".equals(skip)) {
                startCount = Integer.parseInt(skip);
            }
            if ((pos = (select = select.substring(1)).indexOf(ch)) < 0) {
                this.malformedSearch("unterminated start string", origSelect);
            }
            startSearch = select.substring(0, pos);
            if ((select = select.substring(pos + 1).trim()).startsWith("trim")) {
                startOpt = 2;
                select = select.substring(4).trim();
            } else if (select.startsWith("from")) {
                startOpt = 0;
                select = select.substring(4).trim();
            } else if (select.startsWith("after")) {
                startOpt = 1;
                select = select.substring(5).trim();
            } else if (!"".equals(select) && !select.startsWith(",")) {
                this.malformedSearch("invalid start option", origSelect);
            }
        }
        if (select.startsWith(",")) {
            select = select.substring(1);
        }
        if (!"".equals(select)) {
            skip = "";
            ch = select.charAt(0);
            while (Character.isDigit(ch)) {
                skip = skip + ch;
                if ("".equals(select = select.substring(1))) {
                    this.malformedSearch("end must specify a search string", origSelect);
                }
                ch = select.charAt(0);
            }
            if (!"".equals(skip)) {
                endCount = Integer.parseInt(skip);
            }
            if ((pos = (select = select.substring(1)).indexOf(ch)) < 0) {
                this.malformedSearch("unterminated end string", origSelect);
            }
            endSearch = select.substring(0, pos);
            if ((select = select.substring(pos + 1).trim()).startsWith("trim")) {
                endOpt = 2;
                select = select.substring(4).trim();
            } else if (select.startsWith("to")) {
                endOpt = 0;
                select = select.substring(2).trim();
            } else if (select.startsWith("before")) {
                endOpt = 1;
                select = select.substring(6).trim();
            }
        }
        if (select.startsWith(";")) {
            select = select.substring(1).trim();
        }
        if (select.startsWith("strip")) {
            strip = true;
            if ((select = select.substring(5).trim()).startsWith(";")) {
                select = select.substring(1).trim();
            }
        }
        this.logger.trace("XPointer search scheme: search='" + startSearch + "';" + startOpt + ",'" + endSearch + "';" + endOpt);
        String data = "";
        try {
            String line;
            rd.mark(this.readLimit);
            matcher = lengthRE.matcher(select);
            if (matcher.matches()) {
                int checklen = Integer.parseInt(matcher.group(1));
                String charset = matcher.group(2);
                select = matcher.group(3);
                if (contentLength >= 0 && checklen != contentLength) {
                    throw new IllegalArgumentException("Integrity check failed: " + checklen + " != " + contentLength);
                }
                if (select.startsWith(";")) {
                    select = select.substring(1).trim();
                }
                if (select.startsWith("strip")) {
                    strip = true;
                    select = select.substring(5).trim();
                }
            }
            if (!"".equals(select)) {
                this.malformedSearch("unexpected characters at end", origSelect);
            }
            Vector<String> lines = new Vector<String>();
            boolean finished = false;
            boolean output = false;
            while (!finished && (line = rd.readLine()) != null) {
                if (output && endSearch != null && line.contains(endSearch)) {
                    if (endCount == 1) {
                        output = false;
                        finished = true;
                        if (endOpt == 0) {
                            lines.add(line);
                        }
                    }
                    --endCount;
                }
                if (output) {
                    lines.add(line);
                }
                if (startSearch != null && !line.contains(startSearch)) continue;
                found = true;
                if (startCount == 1) {
                    output = true;
                    if (startOpt == 0) {
                        lines.add(line);
                    }
                }
                --startCount;
            }
            if (!found) {
                throw new XProcException("No matching lines found");
            }
            if (lines.size() > 0) {
                if (strip && stripWS > 0) {
                    for (String l : lines) {
                        int wslen;
                        matcher = leadingWhitespaceRE.matcher(l);
                        if (!matcher.matches() || (wslen = matcher.group(1).length()) >= stripWS) continue;
                        stripWS = wslen;
                    }
                }
                while (lines.size() > 0 && startOpt == 2 && "".equals(((String)lines.firstElement()).trim())) {
                    lines.remove(0);
                }
                while (lines.size() > 0 && endOpt == 2 && "".equals(((String)lines.lastElement()).trim())) {
                    lines.remove(lines.size() - 1);
                }
            }
            for (String l : lines) {
                if (strip && stripWS > 0 && l.length() >= stripWS) {
                    l = l.substring(stripWS);
                }
                data = data + l + "\n";
            }
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
        finally {
            try {
                rd.reset();
            }
            catch (IOException iOException) {}
        }
        return data;
    }

    private void malformedSearch(String select, String msg) {
        throw new XProcException("Malformed search: " + msg + ": " + select);
    }
}

