/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XInput;
import com.xmlcalabash.runtime.XOutput;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XStep
implements XProcRunnable {
    protected Logger logger = null;
    protected XProcRuntime runtime = null;
    protected Step step = null;
    protected String name = null;
    private Hashtable<String, XInput> xinputs = new Hashtable();
    private Hashtable<String, XOutput> xoutputs = new Hashtable();
    protected Hashtable<String, Vector<ReadablePipe>> inputs = new Hashtable();
    protected Hashtable<String, Pipe> outputs = new Hashtable();
    private Hashtable<QName, RuntimeValue> options = new Hashtable();
    private Hashtable<String, Hashtable<QName, RuntimeValue>> parameters = new Hashtable();
    protected XCompoundStep parent = null;
    protected Hashtable<QName, RuntimeValue> inScopeOptions = new Hashtable();
    private static final SourceLocator[] EMPTY_LOCATION = new SourceLocator[0];
    protected SourceLocator[] parentLocation = EMPTY_LOCATION;
    private Boolean runLazily = null;

    public XStep(XProcRuntime runtime, Step step) {
        this.runtime = runtime;
        this.step = step;
        if (step != null) {
            this.name = step.getName();
        }
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public Step getStep() {
        return this.step;
    }

    public XdmNode getNode() {
        return this.step.getNode();
    }

    public QName getType() {
        return this.step.getNode().getNodeName();
    }

    public String getName() {
        return this.name;
    }

    public DeclareStep getDeclareStep() {
        return this.step.getDeclaration();
    }

    public XCompoundStep getParent() {
        return this.parent;
    }

    public void addInput(XInput input) {
        String port = input.getPort();
        if (this.xinputs.containsKey(port)) {
            throw new XProcException(input.getNode(), "Attempt to add output '" + port + "' port to the same step twice.");
        }
        this.xinputs.put(port, input);
    }

    public void addOutput(XOutput output) {
        String port = output.getPort();
        if (this.xoutputs.containsKey(port)) {
            throw new XProcException(output.getNode(), "Attempt to add output '" + port + "' port to the same step twice.");
        }
        this.xoutputs.put(port, output);
    }

    public XInput getInput(String port) {
        if (this.xinputs.containsKey(port)) {
            return this.xinputs.get(port);
        }
        throw new XProcException(this.step, "Attempt to get non-existant input '" + port + "' port from step.");
    }

    public XOutput getOutput(String port) {
        if (this.xoutputs.containsKey(port)) {
            return this.xoutputs.get(port);
        }
        if ("http://www.w3.org/ns/xproc".equals(this.step.getType().getNamespaceURI()) && this.step.getStep().getVersion() > 1.0) {
            return null;
        }
        throw new XProcException(this.step, "Attempt to get non-existant output '" + port + "' port from step.");
    }

    public void setParameter(QName name, RuntimeValue value) {
        Set<String> ports = this.getParameterPorts();
        int pportCount = 0;
        String pport = null;
        String ppport = null;
        Iterator<String> iterator = ports.iterator();
        while (iterator.hasNext()) {
            String port;
            pport = port = iterator.next();
            ++pportCount;
            Input pin = this.getStep().getInput(port);
            if (!pin.getPrimary()) continue;
            ppport = port;
        }
        if (pportCount == 0) {
            throw new XProcException(this.step, "Attempt to set parameter but there's no parameter port.");
        }
        if (ppport != null) {
            pport = ppport;
        } else if (pportCount > 1) {
            throw new XProcException(this.step, "Attempt to set parameter w/o specifying a port (and there's more than one)");
        }
        this.setParameter(pport, name, value);
    }

    public void setParameter(String port, QName name, RuntimeValue value) {
        Hashtable<Object, RuntimeValue> pparams;
        if (this.parameters.containsKey(port)) {
            pparams = this.parameters.get(port);
        } else {
            XInput xinput = this.getInput(port);
            Input input = this.getDeclareStep().getInput(port);
            if (!input.getParameterInput()) {
                throw new XProcException(this.step, "Attempt to write parameters to non-parameter input port: " + port);
            }
            pparams = new Hashtable();
            this.parameters.put(port, pparams);
        }
        if (pparams.containsKey(name)) {
            throw new XProcException(this.step, "Duplicate parameter: " + name);
        }
        if ("http://www.w3.org/ns/xproc".equals(name.getNamespaceURI())) {
            throw XProcException.dynamicError(31);
        }
        pparams.put(name, value);
    }

    public Set<QName> getOptions() {
        return this.options.keySet();
    }

    public RuntimeValue getOption(QName name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name);
        }
        return null;
    }

    public void setOption(QName name, RuntimeValue value) {
        this.options.put(name, value);
    }

    public void clearOptions() {
        this.options.clear();
    }

    public void clearParameters() {
        this.parameters.clear();
    }

    public Set<QName> getParameters() {
        return this.getParameters("*");
    }

    public RuntimeValue getParameter(QName name) {
        Set<String> ports = this.getParameterPorts();
        int pportCount = 0;
        String pport = null;
        Iterator<String> iterator = ports.iterator();
        while (iterator.hasNext()) {
            String port;
            pport = port = iterator.next();
            ++pportCount;
        }
        if (pportCount != 1) {
            return null;
        }
        return this.getParameter(pport, name);
    }

    public Set<String> getParameterPorts() {
        HashSet<String> ports = new HashSet<String>();
        for (Input input : this.step.inputs()) {
            if (!input.getParameterInput()) continue;
            ports.add(input.getPort());
        }
        return ports;
    }

    public Set<QName> getParameters(String port) {
        if (this.parameters.containsKey(port)) {
            return this.parameters.get(port).keySet();
        }
        return new HashSet<QName>();
    }

    public RuntimeValue getParameter(String port, QName name) {
        Hashtable<QName, RuntimeValue> pparams;
        if (this.parameters.containsKey(port) && (pparams = this.parameters.get(port)).containsKey(name)) {
            return pparams.get(name);
        }
        return null;
    }

    public String getExtensionAttribute(QName name) {
        if (this.step != null) {
            return this.step.getExtensionAttribute(name);
        }
        return null;
    }

    public String getInheritedExtensionAttribute(QName name) {
        if (this.getExtensionAttribute(name) != null) {
            return this.getExtensionAttribute(name);
        }
        if (this.parent != null) {
            return this.parent.getInheritedExtensionAttribute(name);
        }
        return null;
    }

    public boolean hasInScopeVariableBinding(QName name) {
        if (this.inScopeOptions.containsKey(name)) {
            return true;
        }
        return this.getParent() != null && this.getParent().hasInScopeVariableBinding(name);
    }

    public boolean hasInScopeVariableValue(QName name) {
        if (this.inScopeOptions.containsKey(name)) {
            RuntimeValue v = this.getOption(name);
            return v.initialized();
        }
        return this.getParent() != null && this.getParent().hasInScopeVariableBinding(name);
    }

    public Hashtable<QName, RuntimeValue> getInScopeOptions() {
        Hashtable<QName, RuntimeValue> globals = new Hashtable<QName, RuntimeValue>();
        if (this.inScopeOptions != null) {
            for (QName name : this.inScopeOptions.keySet()) {
                globals.put(name, this.inScopeOptions.get(name));
            }
        }
        return globals;
    }

    public abstract RuntimeValue optionAvailable(QName var1);

    public abstract void instantiate(Step var1);

    @Override
    public abstract void reset();

    @Override
    public void run() throws SaxonApiException {
        if (this.runLazily == null) {
            this.runLazily = this.isPure().orElse(false);
        }
        if (this.runLazily.booleanValue()) {
            XProcRunnable runIfNotRunYet = new XProcRunnable(){
                private boolean done = false;

                @Override
                public void run() throws SaxonApiException {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    XStep.this.doRun();
                    XStep.this.runLazily = false;
                }
            };
            for (String port : this.outputs.keySet()) {
                this.outputs.get(port).onRead(runIfNotRunYet);
            }
        } else {
            this.doRun();
        }
    }

    protected abstract void doRun() throws SaxonApiException;

    private Optional<Boolean> isPure() {
        if (this.step != null) {
            Optional<Boolean> declPure;
            Optional<Boolean> pure = this.step.isPure();
            DeclareStep decl = this.getDeclareStep();
            if (decl != null && (declPure = decl.isPure()).isPresent()) {
                if (!pure.isPresent()) {
                    return declPure;
                }
                if (pure.get().booleanValue() && !declPure.get().booleanValue()) {
                    XProcException warning = new XProcException(this, "Step was marked with cx:pure=\"true\" but the corresponding declaration is impure");
                    this.logger.warn(warning.toString());
                }
            }
            return pure;
        }
        return Optional.empty();
    }

    public void error(XProcException error) {
        this.runtime.error(this, error);
    }

    public void warning(XdmNode location, String message) {
        this.runtime.warning(this, location, message);
    }

    public void info(XdmNode location, String message) {
        this.runtime.info(this, location, message);
    }

    public SourceLocator[] getLocation() {
        if (this.step == null) {
            return this.parentLocation;
        }
        SourceLocator[] location = new SourceLocator[this.parentLocation.length + 1];
        location[0] = XProcException.getLocator(this.step);
        for (int i = 0; i < this.parentLocation.length; ++i) {
            location[i + 1] = this.parentLocation[i];
        }
        return location;
    }
}

