/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadOnlyPipe;
import com.xmlcalabash.io.ReadableDocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Input;
import java.util.Vector;
import net.sf.saxon.s9api.XdmNode;

public class XInput {
    private XProcRuntime runtime = null;
    private String port = null;
    private XdmNode node = null;
    private boolean sequenceOk = false;
    private boolean isParameters = false;
    private Vector<ReadablePipe> readers = null;
    private Pipe writer = null;
    private boolean writerReturned = false;
    private ReadableDocumentSequence documents = null;

    public XInput(XProcRuntime runtime, Input input) {
        this.runtime = runtime;
        this.node = input.getNode();
        this.port = input.getPort();
        this.sequenceOk = input.getSequence();
        this.isParameters = input.getParameterInput();
        this.readers = new Vector();
    }

    public String getPort() {
        return this.port;
    }

    public XdmNode getNode() {
        return this.node;
    }

    public ReadablePipe getReader() {
        if (this.documents == null) {
            this.writer = new Pipe(this.runtime);
            this.documents = this.writer.documents();
        }
        ReadOnlyPipe pipe = new ReadOnlyPipe(this.runtime, this.documents);
        pipe.canReadSequence(this.sequenceOk);
        this.readers.add(pipe);
        return pipe;
    }

    public Pipe getWriter() {
        if (this.writerReturned) {
            throw new XProcException(this.node, "Attempt to create two writers for the same input.");
        }
        if (this.writer == null) {
            this.writer = new Pipe(this.runtime);
            this.documents = this.writer.documents();
        }
        this.writerReturned = true;
        return this.writer;
    }

    public boolean getSequence() {
        return this.sequenceOk;
    }

    public boolean getParameters() {
        return this.isParameters;
    }
}

