/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Port;
import com.xmlcalabash.model.Step;
import java.util.Vector;

public class Environment {
    private Vector<Step> visibleSteps = new Vector();
    private Port defaultReadablePort = null;
    private Step pipeline = null;
    private Environment parent = null;

    public Environment(Step pipeline) {
        this.pipeline = pipeline;
        this.visibleSteps.add(pipeline);
    }

    public Environment(Environment env) {
        this.parent = env;
        this.pipeline = env.pipeline;
        this.defaultReadablePort = env.defaultReadablePort;
    }

    public Environment getParent() {
        return this.parent;
    }

    public void addStep(Step step) {
        this.visibleSteps.add(step);
    }

    public void setDefaultReadablePort(Port port) {
        this.defaultReadablePort = port;
    }

    public Port getDefaultReadablePort() {
        return this.defaultReadablePort;
    }

    public int countVisibleSteps(String stepName) {
        int count = 0;
        for (Step step : this.visibleSteps) {
            if (!step.getName().equals(stepName)) continue;
            ++count;
        }
        if (this.parent != null) {
            count += this.parent.countVisibleSteps(stepName);
        }
        return count;
    }

    public Step visibleStep(String stepName) {
        for (Step step : this.visibleSteps) {
            if (!step.getName().equals(stepName)) continue;
            return step;
        }
        if (this.parent != null) {
            return this.parent.visibleStep(stepName);
        }
        return null;
    }

    public Output readablePort(String stepName, String portName) {
        Step step = this.visibleStep(stepName);
        if (step != null) {
            return step.getOutput(portName);
        }
        return null;
    }
}

