/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.EmptyBinding;
import com.xmlcalabash.model.EndPoint;
import com.xmlcalabash.model.Environment;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.Port;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Variable;
import com.xmlcalabash.util.MessageFormatter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class CompoundStep
extends Step {
    private Environment inheritedEnv = null;
    private HashSet<QName> variablesSeen = new HashSet();
    private Vector<Variable> variables = new Vector();
    private boolean augmented = false;

    public CompoundStep(XProcRuntime xproc, XdmNode node, QName type, String name) {
        super(xproc, node, type, name);
    }

    @Override
    public boolean containsStep(String stepName) {
        for (Step step : this.subpipeline) {
            if (!stepName.equals(step.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addVariable(Variable variable) {
        if (this.variablesSeen.contains(variable.getName()) || this.getOption(variable.getName()) != null) {
            throw XProcException.staticError(4, "Duplicate variable/option name: " + variable.getName());
        }
        this.variablesSeen.add(variable.getName());
        this.variables.add(variable);
    }

    @Override
    public Collection<Variable> getVariables() {
        return this.variables;
    }

    @Override
    protected void setEnvironment(Environment newEnvironment) {
        Environment env = new Environment(newEnvironment);
        for (Step step : this.subpipeline) {
            env.addStep(step);
        }
        this.inheritedEnv = new Environment(env);
        this.patchEnvironment(env);
        super.setEnvironment(env);
        Step lastStep = null;
        for (Step step : this.subpipeline) {
            Environment senv = new Environment(env);
            if (lastStep != null) {
                senv.setDefaultReadablePort(lastStep.getDefaultOutput());
            }
            lastStep = step;
            step.setEnvironment(senv);
        }
    }

    @Override
    public void augment() {
        if (this.augmented) {
            return;
        }
        this.augmented = true;
        Vector<Step> stepcopy = new Vector<Step>();
        for (Step step : this.subpipeline) {
            stepcopy.add(step);
        }
        for (Step step : stepcopy) {
            step.augment();
        }
        super.augment();
        if (!XProcConstants.p_declare_step.equals((Object)this.getType()) && (this.outputs().size() == 0 || this.outputs().size() == 1 && "#current".equals(this.outputs().get(0).getPort()))) {
            Step last = (Step)this.subpipeline.get(this.subpipeline.size() - 1);
            Output primary = last.getPrimaryOutput();
            String portName = "!result";
            if (XProcConstants.p_viewport.equals((Object)this.node.getNodeName())) {
                portName = "result";
            }
            if (primary != null) {
                Output output = new Output(this.runtime, this.node);
                output.setPort(portName);
                output.setPrimary(true);
                output.setSequence(primary.getSequence() || XProcConstants.p_for_each.equals((Object)this.getType()));
                this.addOutput(output);
                Input input = new Input(this.runtime, this.node);
                input.setPort("|" + portName);
                input.setSequence(primary.getSequence());
                input.setPrimary(true);
                this.addInput(input);
            }
        }
    }

    @Override
    protected void augmentOptions() {
    }

    @Override
    protected void augmentIO() {
        for (Output output : this.outputs) {
            Input input;
            if ("#current".equals(output.getPort()) || (input = this.getInput("|" + output.getPort())) != null) continue;
            input = new Input(this.runtime, output.getNode());
            input.setPort("|" + output.getPort());
            input.setSequence(true);
            input.setPrimary(output.getPrimary());
            this.addInput(input);
        }
        for (Input input : this.inputs()) {
            if (input.getPort().startsWith("|") || input.getPort().startsWith("#")) continue;
            Output output = new Output(this.runtime, input.getNode());
            output.setPort(input.getPort() + "|");
            output.setSequence(true);
            output.setPrimary(input.getPrimary());
            this.addOutput(output);
        }
    }

    @Override
    public Output getOutput(String portName) {
        Output output = super.getOutput(portName);
        if (output != null) {
            return output;
        }
        for (Input input : this.inputs) {
            if (!portName.equals(input.getPort())) continue;
            return super.getOutput(portName + "|");
        }
        return null;
    }

    @Override
    public void checkVariables() {
        for (Variable variable : this.variables) {
            for (Binding binding : variable.getBinding()) {
                if (binding.getBindingType() != 1) continue;
                PipeNameBinding pipe = (PipeNameBinding)binding;
                String name = pipe.getStep();
                boolean ancestor = false;
                Step step = this;
                while (step != null && !ancestor) {
                    ancestor = name.equals(step.getName());
                    step = step.parent;
                }
                if (ancestor) continue;
                this.logger.trace(MessageFormatter.nodeMessage(this.node, this.getName() + " variable depends on " + pipe.getStep()));
                this.addDependency(pipe.getStep());
            }
        }
    }

    @Override
    protected boolean checkBinding(Input input) {
        boolean valid = true;
        if (input.getBinding().size() == 0) {
            Port port = this.inheritedEnv.getDefaultReadablePort();
            Vector<Binding> declBinding = null;
            if (XProcConstants.p_pipeline.equals((Object)this.getType())) {
                DeclareStep decl = this.declaration;
                for (Input dinput : decl.inputs()) {
                    if (!dinput.getPort().equals(input.getPort())) continue;
                    declBinding = dinput.getBinding();
                }
            }
            if (input.getPort().startsWith("|") && this.subpipeline.size() > 0) {
                Step substep = (Step)this.subpipeline.get(this.subpipeline.size() - 1);
                port = substep.getDefaultOutput();
            }
            EndPoint output = null;
            if (input.getPort().startsWith("|") && this.parent != null) {
                Iterator<Binding> oport = input.getPort().substring(1);
                output = this.getOutput((String)((Object)oport));
            }
            if (output != null && output.getBinding().size() > 0) {
                for (Binding binding : output.getBinding()) {
                    input.addBinding(binding);
                }
                output.clearBindings();
            } else if (port == null) {
                if (declBinding != null) {
                    for (Binding binding : declBinding) {
                        input.addBinding(binding);
                    }
                } else if (input.getParameterInput()) {
                    EmptyBinding empty = new EmptyBinding();
                    input.addBinding(empty);
                } else {
                    valid = false;
                    this.error(XProcException.staticError(32, "Input " + input.getPort() + " unbound on " + this.getType() + " step named " + this.getName() + " and no default binding available."));
                }
            } else {
                String stepName = port.getStep().getName();
                String portName = port.getPort();
                PipeNameBinding binding = new PipeNameBinding(this.runtime, this.node);
                binding.setStep(stepName);
                binding.setPort(portName);
                input.addBinding(binding);
            }
        }
        for (Binding binding : input.getBinding()) {
            PipeNameBinding pipe;
            Output output;
            if (binding.getBindingType() != 1 || (output = this.env.readablePort((pipe = (PipeNameBinding)binding).getStep(), pipe.getPort())) != null) continue;
            this.error(new XProcException(XProcException.err_E0001, "Unreadable port: " + pipe.getPort() + " on " + pipe.getStep()));
            valid = false;
        }
        return valid;
    }

    public void checkPrimaryIO() {
        this.checkPrimaryInput(false);
        this.checkPrimaryInput(true);
        this.checkPrimaryOutput();
        int count = 0;
        int pcount = 0;
        Output primary = null;
        Port defPrimary = null;
        for (Output output : this.outputs()) {
            if (output.getPort().startsWith("#")) continue;
            ++count;
            defPrimary = output;
            if (!output.getPrimary()) continue;
            ++pcount;
            primary = output;
        }
        if (pcount > 1) {
            throw XProcException.staticError(30);
        }
        if (count == 1 && (defPrimary.getPrimary() || !defPrimary.getPrimarySet())) {
            defPrimary.setPrimary(true);
        }
    }

    private void checkPrimaryInput(boolean checkParameterInput) {
        int count = 0;
        int pcount = 0;
        Port defPrimary = null;
        Input primary = null;
        for (Input input : this.inputs()) {
            if (input.getPort().startsWith("|")) continue;
            ++count;
            if (input.getParameterInput() != checkParameterInput) continue;
            if (input.getPrimary()) {
                ++pcount;
                if (primary == null) {
                    primary = input;
                }
            }
            if (defPrimary != null || input.getPrimarySet()) continue;
            defPrimary = input;
        }
        if (pcount > 1) {
            throw XProcException.staticError(30);
        }
        if (count == 1 && primary == null && defPrimary != null && (defPrimary.getPrimary() || !defPrimary.getPrimarySet())) {
            defPrimary.setPrimary(true);
        }
    }

    private void checkPrimaryOutput() {
        int count = 0;
        int pcount = 0;
        Port defPrimary = null;
        Output primary = null;
        for (Output output : this.outputs()) {
            if (output.getPort().endsWith("|")) continue;
            ++count;
            if (output.getPrimary()) {
                ++pcount;
                if (primary == null) {
                    primary = output;
                }
            }
            if (defPrimary != null || output.getPrimarySet()) continue;
            defPrimary = output;
        }
        if (pcount > 1) {
            throw XProcException.staticError(30);
        }
        if (count == 1 && primary == null && defPrimary != null && (defPrimary.getPrimary() || !defPrimary.getPrimarySet())) {
            defPrimary.setPrimary(true);
        }
    }

    @Override
    public boolean valid() {
        boolean valid = this.validParams();
        valid = valid && this.validOptions();
        boolean bl = valid = valid && this.validBindings();
        if (this.env.countVisibleSteps(this.getName()) > 1) {
            this.error(XProcException.staticError(2, "Duplicate step name: " + this.getName()));
            valid = false;
        }
        for (Step step : this.subpipeline) {
            boolean stepValid = step.valid();
            valid = valid && stepValid;
        }
        valid = valid && this.validOutputBinding();
        return valid;
    }

    protected boolean validOutputBinding() {
        Step substep;
        Output port;
        boolean ok = true;
        if (this.subpipeline.size() > 0 && (port = (substep = (Step)this.subpipeline.get(this.subpipeline.size() - 1)).getDefaultOutput()) != null) {
            ok = false;
            for (Input input : this.inputs) {
                if (!input.getPort().startsWith("|")) continue;
                for (Binding binding : input.getBinding()) {
                    if (binding.getBindingType() != 1) continue;
                    PipeNameBinding b = (PipeNameBinding)binding;
                    ok = ok || b.getStep().equals(substep.getName()) && port.getPort().equals(b.getPort());
                }
            }
            if (!ok) {
                for (int spos = 0; spos < this.subpipeline.size() - 1; ++spos) {
                    Step sibling = (Step)this.subpipeline.get(spos);
                    for (Input input : sibling.inputs()) {
                        for (Binding binding : input.getBinding()) {
                            if (binding.getBindingType() != 1) continue;
                            PipeNameBinding b = (PipeNameBinding)binding;
                            ok = ok || b.getStep().equals(substep.getName()) && port.getPort().equals(b.getPort());
                        }
                    }
                }
            }
            if (!ok) {
                this.error(XProcException.staticError(6, this.node, "Unbound primary output port on last step: " + this.getName()));
            }
        }
        return ok;
    }

    @Override
    protected boolean validBindings() {
        boolean valid = super.validBindings();
        for (Variable var : this.getVariables()) {
            if (this.checkOptionBinding(var, true)) continue;
            valid = false;
        }
        return valid;
    }

    @Override
    protected void checkForBindings(HashSet<Output> outputs) {
        super.checkForBindings(outputs);
        for (Variable var : this.getVariables()) {
            for (Binding binding : var.bindings) {
                PipeNameBinding b;
                Output output;
                if (binding.getBindingType() != 1 || !outputs.contains(output = this.env.readablePort((b = (PipeNameBinding)binding).getStep(), b.getPort()))) continue;
                outputs.remove(output);
            }
        }
        for (Step substep : this.subpipeline) {
            substep.checkForBindings(outputs);
        }
    }
}

