/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XProcCollectionFinder;
import com.xmlcalabash.util.XProcURIResolver;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import org.xml.sax.InputSource;

@XMLCalabash(name="p:xslt", type="{http://www.w3.org/ns/xproc}xslt")
public class XSLT
extends DefaultStep {
    private static final StructuredQName TERMINATION_ERROR = new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "XTMM9000");
    private static final QName _initial_mode = new QName("", "initial-mode");
    private static final QName _template_name = new QName("", "template-name");
    private static final QName _output_base_uri = new QName("", "output-base-uri");
    private static final QName _version = new QName("", "version");
    private static final QName _content_type = new QName("content-type");
    private static final QName cx_decode = new QName("cx", "http://xmlcalabash.com/ns/extensions", "decode");
    private static final QName cx_serialize = new QName("cx", "http://xmlcalabash.com/ns/extensions", "serialize");
    private ReadablePipe sourcePipe = null;
    private ReadablePipe stylesheetPipe = null;
    private WritablePipe resultPipe = null;
    private WritablePipe secondaryPipe = null;
    private Hashtable<QName, RuntimeValue> params = new Hashtable();
    private Hashtable<String, XdmDestination> secondaryResults = new Hashtable();

    public XSLT(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.sourcePipe = pipe;
        } else {
            this.stylesheetPipe = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        if ("result".equals(port)) {
            this.resultPipe = pipe;
        } else {
            this.secondaryPipe = pipe;
        }
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        this.params.put(name, value);
    }

    @Override
    public void reset() {
        this.sourcePipe.resetReader();
        this.stylesheetPipe.resetReader();
        this.resultPipe.resetWriter();
        this.secondaryPipe.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        XdmNode xformed;
        super.run();
        XdmNode stylesheet = this.stylesheetPipe.read();
        if (stylesheet == null) {
            throw XProcException.dynamicError(6, this.step, "No stylesheet provided.");
        }
        Vector<XdmNode> defaultCollection = new Vector<XdmNode>();
        while (this.sourcePipe.moreDocuments()) {
            defaultCollection.add(this.sourcePipe.read());
        }
        XdmNode document = null;
        if (defaultCollection.size() > 0) {
            document = (XdmNode)defaultCollection.firstElement();
        }
        String version = null;
        if (this.getOption(_version) == null) {
            XdmNode ssroot = S9apiUtils.getDocumentElement(stylesheet);
            if (ssroot != null && (version = ssroot.getAttributeValue(new QName("", "version"))) == null) {
                version = ssroot.getAttributeValue(new QName("http://www.w3.org/1999/XSL/Transform", "version"));
            }
            if (version == null) {
                version = "2.0";
            }
        } else {
            version = this.getOption(_version).getString();
        }
        if ("1.0".equals(version) && defaultCollection.size() > 1) {
            throw XProcException.stepError(39);
        }
        if ("1.0".equals(version) && this.runtime.getUseXslt10Processor()) {
            this.run10(stylesheet, document);
            return;
        }
        QName initialMode = null;
        QName templateName = null;
        URI outputBaseURI = null;
        RuntimeValue opt = this.getOption(_initial_mode);
        if (opt != null) {
            initialMode = opt.getQName();
        }
        if ((opt = this.getOption(_template_name)) != null) {
            templateName = opt.getQName();
        }
        if ((opt = this.getOption(_output_base_uri)) != null) {
            outputBaseURI = opt.getBaseURI().resolve(opt.getString());
        }
        Processor processor = this.runtime.getProcessor();
        Configuration config = processor.getUnderlyingConfiguration();
        this.runtime.getConfigurer().getSaxonConfigurer().configXSLT(config);
        OutputURIResolver uriResolver = config.getOutputURIResolver();
        CollectionFinder collectionFinder = config.getCollectionFinder();
        XProcURIResolver unparsedTextURIResolver = this.runtime.getResolver();
        config.setOutputURIResolver((OutputURIResolver)new OutputResolver());
        config.setDefaultCollection("http://xmlcalabash.com/saxon-default-collection");
        config.setCollectionFinder((CollectionFinder)new XProcCollectionFinder(this.runtime, defaultCollection, collectionFinder));
        XdmDestination result = null;
        ByteArrayOutputStream outputStream = null;
        try {
            XsltExecutable exec;
            XsltCompiler compiler = this.runtime.getProcessor().newXsltCompiler();
            compiler.setSchemaAware(processor.isSchemaAware());
            compiler.setErrorListener((ErrorListener)new ReportCompileErrors());
            try {
                exec = compiler.compile(stylesheet.asSource());
            }
            catch (SaxonApiException sae) {
                Throwable e = sae.getCause();
                if (e instanceof TransformerException) {
                    TransformerException location = (TransformerException)e;
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        throw new XProcException(location, e, XProcException.fromException(cause));
                    }
                    throw new XProcException(location, e);
                }
                throw XProcException.fromException(sae);
            }
            XsltTransformer transformer = exec.load();
            for (QName name : this.params.keySet()) {
                RuntimeValue v = this.params.get(name);
                if (this.runtime.getAllowGeneralExpressions()) {
                    transformer.setParameter(name, v.getValue());
                    continue;
                }
                transformer.setParameter(name, (XdmValue)v.getUntypedAtomic(this.runtime));
            }
            if (document != null) {
                transformer.setInitialContextNode(document);
            }
            CatchMessages catchMessages = new CatchMessages();
            transformer.setMessageListener((MessageListener)catchMessages);
            if (Boolean.parseBoolean(this.step.getExtensionAttribute(cx_serialize))) {
                Serializer serializer = this.makeSerializer();
                outputStream = new ByteArrayOutputStream();
                serializer.setOutputStream((OutputStream)outputStream);
                transformer.setDestination((Destination)serializer);
            } else {
                result = new XdmDestination();
                result.setTreeModel(TreeModel.getTreeModel((int)this.runtime.getProcessor().getUnderlyingConfiguration().getTreeModel()));
                transformer.setDestination((Destination)result);
            }
            if (initialMode != null) {
                transformer.setInitialMode(initialMode);
            }
            if (templateName != null) {
                transformer.setInitialTemplate(templateName);
            }
            if (outputBaseURI != null) {
                transformer.setBaseOutputURI(outputBaseURI.toASCIIString());
                if (result != null) {
                    try {
                        result.setBaseURI(outputBaseURI);
                    }
                    catch (IllegalArgumentException e) {
                        throw XProcException.fromException(e).rebase(null, new RuntimeException().getStackTrace());
                    }
                }
            }
            transformer.setSchemaValidationMode(ValidationMode.DEFAULT);
            transformer.getUnderlyingController().setUnparsedTextURIResolver((UnparsedTextURIResolver)unparsedTextURIResolver);
            try {
                transformer.transform();
            }
            catch (SaxonApiException sae) {
                if (sae.getCause() instanceof TransformerException) {
                    TransformerException e = (TransformerException)sae.getCause();
                    QName code = null;
                    if (e instanceof XPathException) {
                        StructuredQName qn = ((XPathException)((Object)e)).getErrorCodeQName();
                        if (qn != null && !TERMINATION_ERROR.equals((Object)qn)) {
                            code = new QName(qn);
                        }
                    } else {
                        code = sae.getErrorCode();
                    }
                    XdmNode message = null;
                    if (e instanceof TerminationException) {
                        message = catchMessages.getTerminatingMessage();
                    }
                    TransformerException location = e;
                    Throwable cause = e.getCause();
                    if (cause != null) {
                        XProcException errorCause = XProcException.fromException(cause).rebase(null, new RuntimeException().getStackTrace());
                        if (message != null) {
                            throw new XProcException(code, location, message, errorCause);
                        }
                        throw new XProcException(code, location, (Throwable)e, errorCause);
                    }
                    if (message != null) {
                        throw new XProcException(code, location, message);
                    }
                    throw new XProcException(code, location, (Throwable)e);
                }
                throw XProcException.fromException(sae);
            }
        }
        catch (XProcException e) {
            e = e.rebase(this.step);
            this.step.reportError(e);
            throw e;
        }
        finally {
            config.setOutputURIResolver(uriResolver);
            config.setCollectionFinder(collectionFinder);
        }
        XdmNode xdmNode = xformed = result != null ? result.getXdmNode() : null;
        if (xformed != null) {
            if (this.getOption(_output_base_uri) == null && document != null) {
                TreeWriter fixbase = new TreeWriter(this.runtime);
                fixbase.startDocument(document.getBaseURI());
                fixbase.addSubtree(xformed);
                fixbase.endDocument();
                xformed = fixbase.getResult();
            }
            try {
                S9apiUtils.assertDocument(xformed);
                this.resultPipe.write(xformed);
            }
            catch (XProcException e) {
                if (this.runtime.getAllowTextResults()) {
                    TreeWriter tree = new TreeWriter(this.runtime);
                    tree.startDocument(xformed.getBaseURI());
                    tree.addStartElement(XProcConstants.c_result);
                    tree.addAttribute(_content_type, "text/plain");
                    tree.addAttribute(cx_decode, "true");
                    tree.startContent();
                    Serializer serializer = this.makeSerializer();
                    serializer.setOutputProperty(Serializer.Property.METHOD, "text");
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    serializer.setOutputStream((OutputStream)baos);
                    try {
                        S9apiUtils.serialize(this.runtime, xformed, serializer);
                    }
                    catch (SaxonApiException e2) {
                        throw new XProcException(e2);
                    }
                    try {
                        tree.addText(baos.toString("UTF-8"));
                    }
                    catch (UnsupportedEncodingException ee) {
                        throw new RuntimeException(ee);
                    }
                    tree.addEndElement();
                    tree.endDocument();
                    this.resultPipe.write(tree.getResult());
                }
                throw new XProcException((XStep)this.step, (Throwable)new RuntimeException("p:xslt returned non-XML result", e.getCause()));
            }
        }
        if (outputStream != null) {
            TreeWriter tree = new TreeWriter(this.runtime);
            tree.startDocument(outputBaseURI != null ? outputBaseURI : (document != null ? document.getBaseURI() : null));
            tree.addStartElement(XProcConstants.c_result);
            tree.addAttribute(_content_type, "text/plain");
            tree.addAttribute(cx_decode, "true");
            tree.startContent();
            try {
                tree.addText(outputStream.toString("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            tree.addEndElement();
            tree.endDocument();
            this.resultPipe.write(tree.getResult());
        }
    }

    public void run10(XdmNode stylesheet, XdmNode document) {
        try {
            InputSource is = S9apiUtils.xdmToInputSource(this.runtime, stylesheet);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer(new SAXSource(is));
            transformer.setURIResolver(this.runtime.getResolver());
            for (QName name : this.params.keySet()) {
                RuntimeValue v = this.params.get(name);
                transformer.setParameter(name.getClarkName(), v.getString());
            }
            DOMResult result = new DOMResult();
            is = S9apiUtils.xdmToInputSource(this.runtime, document);
            transformer.transform(new SAXSource(is), result);
            DocumentBuilder xdmBuilder = this.runtime.getConfiguration().getProcessor().newDocumentBuilder();
            XdmNode xformed = xdmBuilder.build((Source)new DOMSource(result.getNode()));
            if (xformed != null) {
                this.resultPipe.write(xformed);
            }
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
        catch (TransformerConfigurationException tce) {
            throw new XProcException(tce);
        }
        catch (TransformerException te) {
            throw new XProcException(te);
        }
    }

    private class ReportCompileErrors
    implements ErrorListener {
        private ReportCompileErrors() {
        }

        @Override
        public void error(TransformerException exception) {
            XSLT.this.logger.error(exception.getMessage());
        }

        @Override
        public void fatalError(TransformerException exception) {
            XSLT.this.step.reportError(new XProcException(exception, (Throwable)exception));
        }

        @Override
        public void warning(TransformerException exception) {
            XSLT.this.logger.warn(exception.getMessage());
        }
    }

    private static class FixedSysidReceiver
    implements Receiver {
        private final String mySysid;
        private final Receiver myWrapped;

        public FixedSysidReceiver(Receiver wrapped, String sysid) {
            this.mySysid = sysid;
            this.myWrapped = wrapped;
            this.myWrapped.setSystemId(sysid);
        }

        public void open() throws XPathException {
            this.myWrapped.open();
        }

        public void setUnparsedEntity(String name, String sysid, String pubid) throws XPathException {
            this.myWrapped.setUnparsedEntity(name, sysid, pubid);
        }

        public String getSystemId() {
            return this.mySysid;
        }

        public void setSystemId(String sysid) {
            this.myWrapped.setSystemId(sysid);
        }

        public void setPipelineConfiguration(PipelineConfiguration conf) {
            this.myWrapped.setPipelineConfiguration(conf);
        }

        public void startDocument(int i) throws XPathException {
            this.myWrapped.startDocument(i);
        }

        public void endDocument() throws XPathException {
            this.myWrapped.endDocument();
        }

        public void startElement(NodeName name, SchemaType st, Location loc, int i) throws XPathException {
            this.myWrapped.startElement(name, st, loc, i);
        }

        public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
            this.myWrapped.namespace(namespaceBindings, properties);
        }

        public void attribute(NodeName name, SimpleType st, CharSequence cs, Location loc, int i) throws XPathException {
            this.myWrapped.attribute(name, st, cs, loc, i);
        }

        public void startContent() throws XPathException {
            this.myWrapped.startContent();
        }

        public void endElement() throws XPathException {
            this.myWrapped.endElement();
        }

        public void characters(CharSequence cs, Location loc, int i) throws XPathException {
            this.myWrapped.characters(cs, loc, i);
        }

        public void processingInstruction(String string, CharSequence cs, Location loc, int i) throws XPathException {
            this.myWrapped.processingInstruction(string, cs, loc, i);
        }

        public void comment(CharSequence cs, Location loc, int i) throws XPathException {
            this.myWrapped.comment(cs, loc, i);
        }

        public void close() throws XPathException {
            this.myWrapped.close();
        }

        public boolean usesTypeAnnotations() {
            return this.myWrapped.usesTypeAnnotations();
        }

        public PipelineConfiguration getPipelineConfiguration() {
            return this.myWrapped.getPipelineConfiguration();
        }
    }

    class CatchMessages
    implements MessageListener {
        XdmNode terminatingMessage = null;

        CatchMessages() {
        }

        public void message(XdmNode content, boolean terminate, SourceLocator locator) {
            if (XSLT.this.runtime.getShowMessages()) {
                System.err.println(content.toString());
            }
            TreeWriter treeWriter = new TreeWriter(XSLT.this.runtime);
            treeWriter.startDocument(content.getBaseURI());
            treeWriter.addStartElement(XProcConstants.c_error);
            treeWriter.startContent();
            treeWriter.addSubtree(content);
            treeWriter.addEndElement();
            treeWriter.endDocument();
            if (!terminate) {
                XSLT.this.step.info(XSLT.this.step.getNode(), content.toString());
            } else {
                this.terminatingMessage = content;
            }
        }

        public XdmNode getTerminatingMessage() {
            return this.terminatingMessage;
        }
    }

    class OutputResolver
    implements OutputURIResolver {
        public OutputURIResolver newInstance() {
            return new OutputResolver();
        }

        public Result resolve(String href, String base) throws TransformerException {
            URI baseURI = null;
            try {
                baseURI = new URI(base);
                baseURI = baseURI.resolve(href);
            }
            catch (URISyntaxException use) {
                throw new XProcException(use);
            }
            XSLT.this.logger.trace(MessageFormatter.nodeMessage(XSLT.this.step.getNode(), "XSLT secondary result document: " + baseURI));
            try {
                XdmDestination xdmResult = new XdmDestination();
                xdmResult.setTreeModel(TreeModel.getTreeModel((int)XSLT.this.runtime.getProcessor().getUnderlyingConfiguration().getTreeModel()));
                XSLT.this.secondaryResults.put(baseURI.toASCIIString(), xdmResult);
                Receiver receiver = xdmResult.getReceiver(XSLT.this.runtime.getProcessor().getUnderlyingConfiguration());
                return new FixedSysidReceiver(receiver, baseURI.toASCIIString());
            }
            catch (SaxonApiException sae) {
                throw new XProcException(sae);
            }
        }

        public void close(Result result) throws TransformerException {
            String href = result.getSystemId();
            XdmDestination xdmResult = (XdmDestination)XSLT.this.secondaryResults.get(href);
            XdmNode doc = xdmResult.getXdmNode();
            try {
                S9apiUtils.assertDocument(doc);
                XSLT.this.secondaryPipe.write(doc);
            }
            catch (XProcException e) {
                if (XSLT.this.runtime.getAllowTextResults()) {
                    TreeWriter tree = new TreeWriter(XSLT.this.runtime);
                    tree.startDocument(doc.getBaseURI());
                    tree.addStartElement(XProcConstants.c_result);
                    tree.addAttribute(_content_type, "text/plain");
                    tree.addAttribute(cx_decode, "true");
                    tree.startContent();
                    tree.addText(doc.toString());
                    tree.addEndElement();
                    tree.endDocument();
                    XSLT.this.secondaryPipe.write(tree.getResult());
                }
                throw new XProcException((XStep)XSLT.this.step, (Throwable)new RuntimeException("p:xslt returned non-XML secondary result", e.getCause()));
            }
        }
    }
}

