/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.S9apiUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

@XMLCalabash(name="p:wrap", type="{http://www.w3.org/ns/xproc}wrap")
public class Wrap
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _match = new QName("match");
    private static final QName _wrapper = new QName("wrapper");
    private static final QName _wrapper_prefix = new QName("wrapper-prefix");
    private static final QName _wrapper_namespace = new QName("wrapper-namespace");
    private static final QName _group_adjacent = new QName("group-adjacent");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private Map<QName, RuntimeValue> inScopeOptions = null;
    private QName wrapper = null;
    private NodeName wrapperCode = null;
    private RuntimeValue groupAdjacent = null;
    private Stack<Boolean> inGroup = new Stack();

    public Wrap(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue wrapperNameValue = this.getOption(_wrapper);
        String wrapperNameStr = wrapperNameValue.getString();
        String wpfx = this.getOption(_wrapper_prefix, (String)null);
        String wns = this.getOption(_wrapper_namespace, (String)null);
        if (wpfx != null && wns == null) {
            throw XProcException.dynamicError(34, this.step.getNode(), "You can't specify a prefix without a namespace");
        }
        if (wns != null && wrapperNameStr.contains(":")) {
            throw XProcException.dynamicError(34, this.step.getNode(), "You can't specify a namespace if the wrapper name contains a colon");
        }
        this.wrapper = wrapperNameStr.contains(":") ? new QName(wrapperNameStr, wrapperNameValue.getNode()) : new QName(wpfx == null ? "" : wpfx, wns, wrapperNameStr);
        this.groupAdjacent = this.getOption(_group_adjacent);
        this.inGroup.push(false);
        XdmNode doc = this.source.read();
        this.wrapperCode = new FingerprintedQName(this.wrapper.getPrefix(), this.wrapper.getNamespaceURI(), this.wrapper.getLocalName());
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(doc, this.getOption(_match));
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6, "Reading source on " + this.getStep().getName());
        }
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) throws SaxonApiException {
        this.matcher.startDocument(node.getBaseURI());
        this.matcher.addStartElement(this.wrapperCode, (SchemaType)Untyped.getInstance(), null);
        this.matcher.startContent();
        this.matcher.addSubtree(node);
        this.matcher.addEndElement();
        this.matcher.endDocument();
        return false;
    }

    @Override
    public void processEndDocument(XdmNode node) throws SaxonApiException {
    }

    @Override
    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        if (!this.inGroup.peek().booleanValue()) {
            this.matcher.addStartElement(this.wrapperCode, (SchemaType)Untyped.getInstance(), null);
        }
        if (this.groupAdjacent != null && this.nextMatches(node)) {
            this.inGroup.pop();
            this.inGroup.push(true);
        } else {
            this.inGroup.pop();
            this.inGroup.push(false);
        }
        this.matcher.addStartElement(node);
        this.matcher.addAttributes(node);
        this.inGroup.push(false);
        return true;
    }

    @Override
    public void processAttribute(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processEndElement(XdmNode node) throws SaxonApiException {
        this.matcher.addEndElement();
        this.inGroup.pop();
        if (!this.inGroup.peek().booleanValue()) {
            this.matcher.addEndElement();
        }
    }

    @Override
    public void processText(XdmNode node) throws SaxonApiException {
        if (!this.inGroup.peek().booleanValue()) {
            this.matcher.addStartElement(this.wrapperCode, (SchemaType)Untyped.getInstance(), null);
        }
        this.matcher.addText(node.getStringValue());
        if (this.groupAdjacent != null && this.nextMatches(node)) {
            this.inGroup.pop();
            this.inGroup.push(true);
        } else {
            this.matcher.addEndElement();
            this.inGroup.pop();
            this.inGroup.push(false);
        }
    }

    @Override
    public void processComment(XdmNode node) throws SaxonApiException {
        if (!this.inGroup.peek().booleanValue()) {
            this.matcher.addStartElement(this.wrapperCode, (SchemaType)Untyped.getInstance(), null);
        }
        this.matcher.addComment(node.getStringValue());
        if (this.groupAdjacent != null && this.nextMatches(node)) {
            this.inGroup.pop();
            this.inGroup.push(true);
        } else {
            this.matcher.addEndElement();
            this.inGroup.pop();
            this.inGroup.push(false);
        }
    }

    @Override
    public void processPI(XdmNode node) throws SaxonApiException {
        if (!this.inGroup.peek().booleanValue()) {
            this.matcher.addStartElement(this.wrapperCode, (SchemaType)Untyped.getInstance(), null);
        }
        this.matcher.addPI(node.getNodeName().getLocalName(), node.getStringValue());
        if (this.groupAdjacent != null && this.nextMatches(node)) {
            this.inGroup.pop();
            this.inGroup.push(true);
        } else {
            this.matcher.addEndElement();
            this.inGroup.pop();
            this.inGroup.push(false);
        }
    }

    private boolean nextMatches(XdmNode node) {
        XdmItem nodeValue = this.computeGroup(node);
        if (nodeValue == null) {
            return false;
        }
        XdmSequenceIterator iter = node.axisIterator(Axis.FOLLOWING_SIBLING);
        while (iter.hasNext()) {
            boolean skippable;
            XdmNode chk = (XdmNode)iter.next();
            boolean bl = skippable = chk.getNodeKind() == XdmNodeKind.COMMENT || chk.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION;
            if (chk.getNodeKind() == XdmNodeKind.TEXT && "".equals(chk.toString().trim())) {
                skippable = true;
            }
            if (this.matcher.matches(chk)) {
                XdmItem nextValue = this.computeGroup(chk);
                boolean same = S9apiUtils.xpathEqual(this.runtime.getProcessor(), nodeValue, nextValue);
                return same;
            }
            if (skippable) continue;
            return false;
        }
        return false;
    }

    private XdmItem computeGroup(XdmNode node) {
        try {
            XPathCompiler xcomp = this.runtime.getProcessor().newXPathCompiler();
            xcomp.setBaseURI(this.step.getNode().getBaseURI());
            for (String prefix : this.groupAdjacent.getNamespaceBindings().keySet()) {
                xcomp.declareNamespace(prefix, this.groupAdjacent.getNamespaceBindings().get(prefix));
            }
            XPathExecutable xexec = xcomp.compile(this.groupAdjacent.getString());
            XPathSelector selector = xexec.load();
            selector.setContextItem((XdmItem)node);
            Iterator values = selector.iterator();
            if (values.hasNext()) {
                return (XdmItem)values.next();
            }
            return null;
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
    }
}

