/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

@XMLCalabash(name="pxf:touch", type="{http://exproc.org/proposed/steps/file}touch {http://xmlcalabash.com/ns/extensions/fileutils}touch")
public class Touch
extends DefaultStep {
    private static final QName _href = new QName("href");
    private WritablePipe result = null;

    public Touch(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        RuntimeValue href = this.getOption(_href);
        final TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_result);
        tree.startContent();
        try {
            DataStore store = this.runtime.getDataStore();
            String base = href.getBaseURI().toASCIIString();
            try {
                store.infoEntry(href.getString(), base, "*/*", new DataStore.DataInfo(){

                    @Override
                    public void list(URI id, String media, long lastModified) throws IOException {
                        tree.addText(id.toASCIIString());
                    }
                });
            }
            catch (FileNotFoundException e) {
                URI uri = store.writeEntry(href.getString(), base, "text/plain", new DataStore.DataWriter(){

                    @Override
                    public void store(OutputStream content) throws IOException {
                    }
                });
                tree.addText(uri.toASCIIString());
            }
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

