/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.TreeWriter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.GregorianCalendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;

@XMLCalabash(name="pxp:unzip", type="{http://exproc.org/proposed/steps}unzip {http://xmlcalabash.com/ns/extensions}unzip")
public class Unzip
extends DefaultStep {
    private static final String ACCEPT_ZIP = "application/zip, */*";
    protected static final QName _href = new QName("", "href");
    protected static final QName _content_type = new QName("", "content-type");
    protected static final QName c_zipfile = new QName("c", "http://www.w3.org/ns/xproc-step", "zipfile");
    protected static final QName c_file = new QName("c", "http://www.w3.org/ns/xproc-step", "file");
    protected static final QName _file = new QName("", "file");
    protected static final QName _charset = new QName("", "charset");
    protected static final QName _name = new QName("", "name");
    protected static final QName c_directory = new QName("c", "http://www.w3.org/ns/xproc-step", "directory");
    protected static final QName _compressed_size = new QName("", "compressed-size");
    protected static final QName _comment = new QName("", "comment");
    protected static final QName _size = new QName("", "size");
    protected static final QName _date = new QName("", "date");
    private WritablePipe result = null;
    private String zipFn = null;
    private URI zipURI = null;
    private String name = null;
    private String contentType = "application/xml";
    private String charset = null;

    public Unzip(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        this.zipFn = this.getOption(_href).getString();
        this.zipURI = this.getOption(_href).getBaseURI();
        if (this.getOption(_file) != null) {
            this.name = this.getOption(_file).getString();
        }
        if (this.getOption(_content_type) != null) {
            this.contentType = this.getOption(_content_type).getString();
        }
        if (this.getOption(_charset) != null) {
            this.charset = this.getOption(_charset).getString();
        }
        try {
            final DatatypeFactory dfactory = DatatypeFactory.newInstance();
            DataStore store = this.runtime.getDataStore();
            String base = this.zipURI.toASCIIString();
            store.readEntry(this.zipFn, base, ACCEPT_ZIP, null, new DataStore.DataReader(){

                @Override
                public void load(URI id, String media, InputStream content, long len) throws IOException {
                    Unzip.this.unzip(dfactory, id.toASCIIString(), content);
                }
            });
        }
        catch (MalformedURLException mue) {
            throw new XProcException(XProcException.err_E0001, (Throwable)mue);
        }
        catch (IOException ioe) {
            throw new XProcException(XProcException.err_E0001, (Throwable)ioe);
        }
        catch (DatatypeConfigurationException dce) {
            throw new XProcException(XProcException.err_E0001, (Throwable)dce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unzip(DatatypeFactory dfactory, String systemId, InputStream stream) throws IOException {
        block23: {
            try (ZipInputStream zipFile = new ZipInputStream(stream);){
                TreeWriter tree = new TreeWriter(this.runtime);
                if (this.name == null) {
                    tree.startDocument(this.step.getNode().getBaseURI());
                    tree.addStartElement(c_zipfile);
                    tree.addAttribute(_href, systemId);
                    tree.startContent();
                    GregorianCalendar cal = new GregorianCalendar();
                    ZipEntry entry = zipFile.getNextEntry();
                    while (entry != null) {
                        cal.setTimeInMillis(entry.getTime());
                        XMLGregorianCalendar xmlCal = dfactory.newXMLGregorianCalendar(cal);
                        if (entry.isDirectory()) {
                            tree.addStartElement(c_directory);
                        } else {
                            tree.addStartElement(c_file);
                            tree.addAttribute(_compressed_size, "" + entry.getCompressedSize());
                            tree.addAttribute(_size, "" + entry.getSize());
                        }
                        if (entry.getComment() != null) {
                            tree.addAttribute(_comment, entry.getComment());
                        }
                        tree.addAttribute(_name, "" + entry.getName());
                        tree.addAttribute(_date, xmlCal.toXMLFormat());
                        tree.startContent();
                        tree.addEndElement();
                        entry = zipFile.getNextEntry();
                    }
                    tree.addEndElement();
                    tree.endDocument();
                    this.result.write(tree.getResult());
                    break block23;
                }
                ZipEntry entry = zipFile.getNextEntry();
                while (entry != null && !this.name.equals(entry.getName())) {
                    entry = zipFile.getNextEntry();
                }
                if (entry == null) {
                    throw new XProcException((XStep)this.step, "ZIP file does not contain '" + this.name + "'");
                }
                if ("application/xml".equals(this.contentType) || "text/xml".equals(this.contentType) || this.contentType.endsWith("+xml")) {
                    InputSource isource = new InputSource(zipFile);
                    XdmNode doc = this.runtime.parse(isource);
                    this.result.write(doc);
                    break block23;
                }
                boolean storeText = this.contentType != null && this.contentType.startsWith("text/") && this.charset != null;
                URI zipURI = URI.create("zip:" + this.zipFn + "!" + URLEncoder.encode(entry.getName(), "UTF-8"));
                tree.startDocument(zipURI);
                tree.addStartElement(XProcConstants.c_data);
                tree.addAttribute(_name, this.name);
                tree.addAttribute(_content_type, this.contentType);
                if (!storeText) {
                    tree.addAttribute(_encoding, "base64");
                }
                tree.startContent();
                if (storeText) {
                    try (InputStreamReader reader = new InputStreamReader((InputStream)zipFile, this.charset);){
                        int maxlen = 4096;
                        char[] chars = new char[maxlen];
                        int read = reader.read(chars, 0, maxlen);
                        while (read >= 0) {
                            if (read > 0) {
                                String s = new String(chars);
                                tree.addText(s);
                            }
                            read = reader.read(chars, 0, maxlen);
                        }
                    }
                }
                try (BufferedInputStream bufstream = new BufferedInputStream(zipFile);){
                    int maxlen = 12288;
                    byte[] bytes = new byte[maxlen];
                    int read = bufstream.read(bytes, 0, maxlen);
                    while (read >= 0) {
                        if (read > 0) {
                            String base64 = Base64.encodeBytes(bytes, 0, read);
                            tree.addText(base64 + "\n");
                        }
                        read = bufstream.read(bytes, 0, maxlen);
                    }
                }
                tree.addEndElement();
                tree.endDocument();
                this.result.write(tree.getResult());
            }
        }
    }
}

