/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.runtime.XInput;
import com.xmlcalabash.runtime.XLibrary;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.AxisNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;

@XMLCalabash(name="cx:eval", type="{http://xmlcalabash.com/ns/extensions}eval")
public class Eval
extends DefaultStep {
    protected static final QName cx_document = new QName("cx", "http://xmlcalabash.com/ns/extensions", "document");
    protected static final QName cx_options = new QName("cx", "http://xmlcalabash.com/ns/extensions", "options");
    protected static final QName cx_option = new QName("cx", "http://xmlcalabash.com/ns/extensions", "option");
    private static final QName _port = new QName("port");
    private static final QName _detailed = new QName("detailed");
    private static final QName _step = new QName("step");
    private static final QName _name = new QName("name");
    private static final QName _value = new QName("value");
    private Vector<ReadablePipe> sources = new Vector();
    private ReadablePipe pipeline = null;
    private Hashtable<QName, RuntimeValue> params = new Hashtable();
    private Vector<ReadablePipe> options = new Vector();
    private WritablePipe result = null;

    public Eval(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.sources.add(pipe);
        } else if ("pipeline".equals(port)) {
            if (this.pipeline != null) {
                throw new XProcException((XStep)this.step, "You can't specify more than one pipeline.");
            }
            this.pipeline = pipe;
        } else if ("options".equals(port)) {
            this.options.add(pipe);
        } else {
            throw new XProcException((XStep)this.step, "Unexpected port: " + port);
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        for (ReadablePipe pipe : this.sources) {
            pipe.resetReader();
        }
        for (ReadablePipe pipe : this.options) {
            pipe.resetReader();
        }
        this.pipeline.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        this.params.put(name, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() throws SaxonApiException {
        XProcRuntime innerRuntime;
        block37: {
            super.run();
            XdmNode pipedoc = this.pipeline.read();
            XdmNode piperoot = S9apiUtils.getDocumentElement(pipedoc);
            innerRuntime = new XProcRuntime(this.runtime);
            XPipeline pipeline = null;
            try {
                XdmNode doc;
                QName stepName = this.getOption(_step, (QName)null);
                if (XProcConstants.p_pipeline.equals((Object)piperoot.getNodeName()) || XProcConstants.p_declare_step.equals((Object)piperoot.getNodeName())) {
                    if (stepName != null) {
                        throw new XProcException((XStep)this.step, "Step option can only be used when loading a p:library");
                    }
                    pipeline = innerRuntime.use(pipedoc);
                } else if (XProcConstants.p_library.equals((Object)piperoot.getNodeName())) {
                    XLibrary library = innerRuntime.useLibrary(piperoot);
                    pipeline = stepName == null ? library.getFirstPipeline() : library.getPipeline(stepName);
                }
                Set<String> inputports = pipeline.getInputs();
                Set<String> outputports = pipeline.getOutputs();
                int inputCount = 0;
                for (String port : inputports) {
                    XInput input = pipeline.getInput(port);
                    if (input.getParameters()) continue;
                    ++inputCount;
                }
                boolean detailed = this.getOption(_detailed, false);
                if (!detailed) {
                    if (inputCount > true) throw new XProcException((XStep)this.step, "You must specify detailed='true' to eval pipelines with multiple inputs or outputs");
                    if (outputports.size() > 1) {
                        throw new XProcException((XStep)this.step, "You must specify detailed='true' to eval pipelines with multiple inputs or outputs");
                    }
                }
                DeclareStep decl = pipeline.getDeclareStep();
                String primaryin = null;
                for (String port : inputports) {
                    Input input = decl.getInput(port);
                    if (input.getParameterInput() || (inputports.size() != 1 || input.getPrimarySet()) && !input.getPrimary()) continue;
                    primaryin = port;
                }
                Hashtable inputs = new Hashtable();
                for (ReadablePipe pipe : this.sources) {
                    while (pipe.moreDocuments()) {
                        Object port = primaryin;
                        XdmNode doc2 = pipe.read();
                        XdmNode root = S9apiUtils.getDocumentElement(doc2);
                        if (detailed && cx_document.equals((Object)root.getNodeName())) {
                            port = root.getAttributeValue(_port);
                            boolean seenelem = false;
                            XdmDestination dest = new XdmDestination();
                            Vector<XdmValue> nodes = new Vector<XdmValue>();
                            XdmSequenceIterator iter = root.axisIterator(Axis.CHILD);
                            while (iter.hasNext()) {
                                XdmNode child = (XdmNode)iter.next();
                                if (child.getNodeKind() == XdmNodeKind.ELEMENT) {
                                    if (seenelem) {
                                        throw new IllegalArgumentException("Not a well-formed inline document");
                                    }
                                    seenelem = true;
                                }
                                nodes.add((XdmValue)child);
                            }
                            S9apiUtils.writeXdmValue(this.runtime, nodes, (Destination)dest, root.getBaseURI());
                            doc2 = dest.getXdmNode();
                        }
                        if (port == null) {
                            throw new XProcException((XStep)this.step, "You must use cx:document for pipelines with no primary input port");
                        }
                        if (!inputs.containsKey(port)) {
                            inputs.put(port, new Vector());
                        }
                        ((Vector)inputs.get(port)).add(doc2);
                    }
                }
                for (String port : inputs.keySet()) {
                    if (!inputports.contains(port)) throw new XProcException((XStep)this.step, "Eval pipeline has no input port named '" + port + "'");
                    pipeline.clearInputs(port);
                    for (XdmNode node : (Vector)inputs.get(port)) {
                        pipeline.writeTo(port, node);
                    }
                }
                if (this.params != null) {
                    for (QName name : this.params.keySet()) {
                        pipeline.setParameter(name, this.params.get(name));
                    }
                }
                for (ReadablePipe pipe : this.options) {
                    while (pipe.moreDocuments()) {
                        doc = pipe.read();
                        XdmNode root = S9apiUtils.getDocumentElement(doc);
                        if (!cx_options.equals((Object)root.getNodeName())) {
                            throw new XProcException((XStep)this.step, "Options port must be a cx:options document.");
                        }
                        for (XdmNode opt : new AxisNodes(this.runtime, root, Axis.CHILD, 7)) {
                            if (opt.getNodeKind() != XdmNodeKind.ELEMENT) throw new XProcException((XStep)this.step, "A cx:options document must only contain cx:option elements");
                            if (!cx_option.equals((Object)opt.getNodeName())) {
                                throw new XProcException((XStep)this.step, "A cx:options document must only contain cx:option elements");
                            }
                            String name = opt.getAttributeValue(_name);
                            QName qname = new QName(name, opt);
                            String value = opt.getAttributeValue(_value);
                            if (name == null) throw new XProcException((XStep)this.step, "A cx:option element must have name and value attributes");
                            if (value == null) {
                                throw new XProcException((XStep)this.step, "A cx:option element must have name and value attributes");
                            }
                            RuntimeValue runtimeValue = new RuntimeValue(value);
                            pipeline.passOption(qname, runtimeValue);
                        }
                    }
                }
                pipeline.run();
                for (String port : outputports) {
                    ReadablePipe rpipe = pipeline.readFrom(port);
                    rpipe.canReadSequence(true);
                    while (rpipe.moreDocuments()) {
                        doc = rpipe.read();
                        TreeWriter tree = new TreeWriter(this.runtime);
                        tree.startDocument(doc.getBaseURI());
                        if (detailed) {
                            tree.addStartElement(cx_document);
                            tree.addAttribute(_port, port);
                            tree.startContent();
                            tree.addSubtree(doc);
                            tree.addEndElement();
                        } else {
                            tree.addSubtree(doc);
                        }
                        tree.endDocument();
                        this.result.write(tree.getResult());
                    }
                }
                if (pipeline == null) break block37;
            }
            catch (XProcException e) {
                try {
                    throw e.rebase(this.step.getLocation());
                }
                catch (Throwable throwable) {
                    if (pipeline != null) {
                        for (XdmNode doc : pipeline.errors()) {
                            this.step.reportError(doc);
                        }
                    }
                    innerRuntime.close();
                    this.runtime.resetExtensionFunctions();
                    throw throwable;
                }
            }
            for (XdmNode doc : pipeline.errors()) {
                this.step.reportError(doc);
            }
        }
        innerRuntime.close();
        this.runtime.resetExtensionFunctions();
    }
}

