/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.drivers;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.util.AxisNodes;
import com.xmlcalabash.util.DefaultTestReporter;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TestReporter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class RunTestReport {
    public static final QName _path = new QName("path");
    public static final QName _port = new QName("port");
    public static final QName _href = new QName("href");
    public static final QName _name = new QName("name");
    public static final QName _value = new QName("value");
    public static final String NS_TEST = "http://xproc.org/ns/testsuite";
    public static final QName t_test = new QName("http://xproc.org/ns/testsuite", "test");
    public static final QName t_title = new QName("http://xproc.org/ns/testsuite", "title");
    public static final QName t_description = new QName("http://xproc.org/ns/testsuite", "description");
    public static final QName t_input = new QName("http://xproc.org/ns/testsuite", "input");
    public static final QName t_output = new QName("http://xproc.org/ns/testsuite", "output");
    public static final QName t_parameter = new QName("http://xproc.org/ns/testsuite", "parameter");
    public static final QName t_option = new QName("http://xproc.org/ns/testsuite", "option");
    public static final QName t_pipeline = new QName("http://xproc.org/ns/testsuite", "pipeline");
    public static final QName t_compare_pipeline = new QName("http://xproc.org/ns/testsuite", "compare-pipeline");
    public static final QName t_document = new QName("http://xproc.org/ns/testsuite", "document");
    private static boolean debug = false;
    private static boolean schemaAware = false;
    private static XdmNode prettyPrint = null;
    private static String defaultLog = null;
    private XProcRuntime runtime = null;
    private TestReporter reporter = null;
    protected Logger logger = LoggerFactory.getLogger(RunTestReport.class);

    public RunTestReport(XProcRuntime runtime, TestReporter reporter) {
        this.runtime = runtime;
        this.reporter = reporter;
    }

    public void setDebug(boolean dbg) {
        debug = dbg;
    }

    public void setSchemaAware(boolean aware) {
        schemaAware = aware;
    }

    public void setDefaultLog(String deflog) {
        defaultLog = deflog;
    }

    public static void main(String[] args) throws SaxonApiException, IOException, URISyntaxException {
        String usage = "RunTests [-D] [-d directory] [-a] test.xml";
        Vector<String> tests = new Vector<String>();
        for (int pos = 0; pos < args.length; ++pos) {
            if ("-D".equals(args[pos])) {
                debug = true;
                continue;
            }
            if ("-L".equals(args[pos])) {
                defaultLog = args[pos + 1];
                ++pos;
                continue;
            }
            if ("-a".equals(args[pos])) {
                schemaAware = true;
                continue;
            }
            if ("-d".equals(args[pos])) {
                int count = 0;
                File dir = new File(args[++pos]);
                String dirname = null;
                try {
                    dir = dir.getCanonicalFile();
                    dirname = dir.getName();
                }
                catch (IOException ioe) {
                    throw new XProcException(ioe);
                }
                for (File file : dir.listFiles()) {
                    if (file.isDirectory() || !file.getName().endsWith(".xml")) continue;
                    ++count;
                    System.err.println("Test: " + file.getAbsolutePath());
                    tests.add(file.getAbsolutePath());
                }
                if (count != 0) continue;
                System.err.println("No tests found in " + dirname);
                continue;
            }
            System.err.println("Test: " + args[pos]);
            tests.add(args[pos]);
        }
        if (tests.size() == 0) {
            System.err.println(usage);
            System.exit(1);
        }
        XProcConfiguration config = new XProcConfiguration("ee", schemaAware);
        XProcRuntime runtime = new XProcRuntime(config);
        RunTestReport test = new RunTestReport(runtime, new DefaultTestReporter(runtime));
        test.runTests(tests);
        runtime.close();
    }

    public void runTests(Vector<String> tests) {
        this.startReport();
        for (String testfile : tests) {
            this.reportRun(testfile);
        }
        this.endReport();
    }

    public TestSuiteResults run(String testfile) {
        XdmNode test;
        XdmNode root;
        Vector<TestSuiteResult> results = new Vector<TestSuiteResult>();
        try {
            InputStream instream = this.getClass().getResourceAsStream("/etc/prettyprint.xpl");
            if (instream == null) {
                throw new UnsupportedOperationException("Failed to load prettyprint stylesheet from resources.");
            }
            XdmNode ppd = this.runtime.parse(new InputSource(instream));
            prettyPrint = S9apiUtils.getDocumentElement(ppd);
            InputSource isource = new InputSource(testfile);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setEntityResolver(this.runtime.getResolver());
            SAXSource source = new SAXSource(reader, isource);
            DocumentBuilder builder = this.runtime.getProcessor().newDocumentBuilder();
            builder.setLineNumbering(true);
            builder.setDTDValidation(false);
            XdmNode doc = builder.build((Source)source);
            root = S9apiUtils.getDocumentElement(doc);
        }
        catch (Exception sae) {
            TestSuiteResult result = new TestSuiteResult(testfile);
            result.catchException(sae);
            results.add(result);
            return new TestSuiteResults(results);
        }
        if (t_test.equals((Object)root.getNodeName())) {
            TestSuiteResult result = this.runTest(root);
            results.add(result);
            return new TestSuiteResults(results);
        }
        String title = "";
        XdmSequenceIterator iter = root.axisIterator(Axis.CHILD, t_title);
        while (iter.hasNext()) {
            test = (XdmNode)iter.next();
            title = title + test.getStringValue();
        }
        iter = root.axisIterator(Axis.CHILD, t_test);
        while (iter.hasNext()) {
            test = (XdmNode)iter.next();
            TestSuiteResult result = this.runTest(test);
            results.add(result);
        }
        if (!"".equals(title)) {
            return new TestSuiteResults(title, results);
        }
        return new TestSuiteResults(results);
    }

    public void reportRun(String testfile) {
        TestSuiteResults results = this.run(testfile);
        results.reportResults();
    }

    public TestSuiteResult runTest(XdmNode testNode) {
        if (testNode.getAttributeValue(_href) != null) {
            TestSuiteResult result;
            URI turi = testNode.getBaseURI().resolve(testNode.getAttributeValue(_href));
            try {
                InputSource isource = new InputSource(turi.toASCIIString());
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setEntityResolver(this.runtime.getResolver());
                SAXSource source = new SAXSource(reader, isource);
                DocumentBuilder builder = this.runtime.getProcessor().newDocumentBuilder();
                builder.setLineNumbering(true);
                builder.setDTDValidation(false);
                XdmNode xdmNode = builder.build((Source)source);
                XdmNode root = S9apiUtils.getDocumentElement(xdmNode);
                result = this.runTest(root);
            }
            catch (Exception sae) {
                result = new TestSuiteResult(turi.toASCIIString());
                result.catchException(sae);
            }
            return result;
        }
        TestSuiteResult result = new TestSuiteResult(testNode.getBaseURI().toASCIIString());
        this.reporter.runningTest(testNode.getBaseURI());
        XProcTest t = new XProcTest(testNode);
        result.setTitle(t.title);
        result.setDescription(t.description);
        if (t.pipeline == null) {
            result.catchException(new UnsupportedOperationException("Pipeline must be provided."));
            return result;
        }
        Hashtable<Object, Object> pipeoutputs = new Hashtable();
        try {
            pipeoutputs = this.runPipe(t.pipeline.pipeline, t.inputs, t.outputs, t.parameters, t.options);
        }
        catch (XProcException xprocex) {
            if (t.error == null) {
                result.fail(xprocex);
                return result;
            }
            if (xprocex.getErrorCode() != null) {
                result.catchException(xprocex);
                result.success(t.error, xprocex.getErrorCode());
                return result;
            }
            result.success(t.error, null);
            return result;
        }
        catch (Exception err) {
            result.catchException(err);
            return result;
        }
        if (t.error != null) {
            result.fail(t.error);
            return result;
        }
        if (t.comparepipeline != null) {
            XProcPipeline compare = t.comparepipeline;
            Hashtable<String, Vector<XdmNode>> cinputs = new Hashtable<String, Vector<XdmNode>>();
            for (String string : pipeoutputs.keySet()) {
                if (!compare.inputPorts.contains(string)) continue;
                ReadablePipe pipe = (ReadablePipe)pipeoutputs.get(string);
                try {
                    while (pipe.moreDocuments()) {
                        XdmNode xdmNode = pipe.read();
                        if (!cinputs.containsKey(string)) {
                            cinputs.put(string, new Vector());
                        }
                        cinputs.get(string).add(xdmNode);
                    }
                }
                catch (SaxonApiException saxonApiException) {
                    result.catchException(saxonApiException);
                    return result;
                }
            }
            try {
                pipeoutputs = this.runPipe(compare.pipeline, cinputs, t.outputs, null, null);
            }
            catch (Exception err) {
                result.fail(err, "Compare pipelines failed: this shouldn't happen.");
            }
        }
        Hashtable results = new Hashtable();
        Hashtable expects = new Hashtable();
        try {
            XdmNode pdoc;
            Vector pexp;
            Vector pres;
            for (String string : pipeoutputs.keySet()) {
                Vector<XdmNode> touts = t.outputs.get(string);
                ReadablePipe readablePipe = (ReadablePipe)pipeoutputs.get(string);
                if (!results.containsKey(string)) {
                    results.put(string, new Vector());
                }
                if (!expects.containsKey(string)) {
                    expects.put(string, new Vector());
                }
                pres = (Vector)results.get(string);
                pexp = (Vector)expects.get(string);
                while (readablePipe.moreDocuments()) {
                    if (touts.size() > 0) {
                        XdmNode tdoc = touts.remove(0);
                        pdoc = readablePipe.read();
                        if (t.ignoreWS) {
                            XPipeline pppipe = this.runtime.use(prettyPrint);
                            pppipe.writeTo("source", tdoc);
                            pppipe.run();
                            ReadablePipe rpipe = pppipe.readFrom("result");
                            tdoc = rpipe.read();
                            pppipe.reset();
                            pppipe.writeTo("source", pdoc);
                            pppipe.run();
                            rpipe = pppipe.readFrom("result");
                            pdoc = rpipe.read();
                        }
                        pres.add(pdoc);
                        pexp.add(tdoc);
                        continue;
                    }
                    XdmNode pdoc2 = readablePipe.read();
                    pres.add(pdoc2);
                }
            }
            QName doca = new QName("", "doca");
            QName qName = new QName("", "docb");
            for (String string : pipeoutputs.keySet()) {
                pres = (Vector)results.get(string);
                pexp = (Vector)expects.get(string);
                if (pres.size() == 0 && pexp.size() == 0) {
                    result.success();
                }
                for (int pos = 0; pos < pres.size() || pos < pexp.size(); ++pos) {
                    XdmNode tdoc;
                    if (pos >= pres.size()) {
                        tdoc = (XdmNode)pexp.get(pos);
                        result.fail(tdoc, null);
                        continue;
                    }
                    if (pos >= pexp.size()) {
                        pdoc = (XdmNode)pres.get(pos);
                        result.fail(null, pdoc);
                        continue;
                    }
                    tdoc = (XdmNode)pexp.get(pos);
                    XdmNode pdoc3 = (XdmNode)pres.get(pos);
                    XPathCompiler xcomp = this.runtime.getProcessor().newXPathCompiler();
                    xcomp.declareVariable(doca);
                    xcomp.declareVariable(qName);
                    XPathExecutable xexec = xcomp.compile("deep-equal($doca,$docb)");
                    XPathSelector selector = xexec.load();
                    selector.setVariable(doca, (XdmValue)tdoc);
                    selector.setVariable(qName, (XdmValue)pdoc3);
                    Iterator values = selector.iterator();
                    XdmAtomicValue item = (XdmAtomicValue)values.next();
                    boolean same = item.getBooleanValue();
                    if (same) {
                        result.success();
                        continue;
                    }
                    result.fail(tdoc, pdoc3);
                }
            }
        }
        catch (SaxonApiException sae) {
            result.fail((Exception)((Object)sae), "Error comparing results: this shouldn't happen");
        }
        if (pipeoutputs.size() == 0 && expects.size() == 0) {
            result.success();
        }
        return result;
    }

    private Hashtable<String, ReadablePipe> runPipe(XdmNode pipeline, Hashtable<String, Vector<XdmNode>> inputs, Hashtable<String, Vector<XdmNode>> outputs, Hashtable<QName, String> parameters, Hashtable<QName, String> options) throws SaxonApiException {
        XPipeline xpipeline = this.runtime.use(pipeline);
        if (inputs != null) {
            for (String port : inputs.keySet()) {
                if (!xpipeline.getInputs().contains(port)) {
                    throw new UnsupportedOperationException("Error: Test sets input port that doesn't exist: " + port);
                }
                xpipeline.clearInputs(port);
                for (XdmNode node : inputs.get(port)) {
                    xpipeline.writeTo(port, node);
                }
            }
        }
        if (parameters != null) {
            for (QName name : parameters.keySet()) {
                xpipeline.setParameter(name, new RuntimeValue(parameters.get(name)));
            }
        }
        if (options != null) {
            for (QName name : options.keySet()) {
                RuntimeValue v = _path.equals((Object)name) ? new RuntimeValue("file:///home/www/tests.xproc.org/tests/required/" + options.get(name)) : new RuntimeValue(options.get(name));
                xpipeline.passOption(name, v);
            }
        }
        try {
            xpipeline.run();
        }
        catch (XProcException e) {
            this.logger.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            this.logger.debug(e.getMessage(), e);
            throw new XProcException(e);
        }
        Hashtable<String, ReadablePipe> pipeoutputs = new Hashtable<String, ReadablePipe>();
        Set<String> pipeouts = xpipeline.getOutputs();
        for (String port : pipeouts) {
            if (port.startsWith("!")) continue;
            ReadablePipe rpipe = xpipeline.readFrom(port);
            rpipe.canReadSequence(true);
            pipeoutputs.put(port, rpipe);
        }
        return pipeoutputs;
    }

    private void makeReport(Vector<TestSuiteResult> results) {
        for (TestSuiteResult result : results) {
            result.report();
        }
    }

    private void startReport() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("name", this.runtime.getProductName());
        props.put("vendor", this.runtime.getVendor());
        props.put("vendor-uri", this.runtime.getVendorURI());
        props.put("version", this.runtime.getProductVersion());
        props.put("language", this.runtime.getLanguage());
        props.put("xproc-version", this.runtime.getXProcVersion());
        props.put("xpath-version", this.runtime.getXPathVersion());
        props.put("psvi-supported", "" + this.runtime.getPSVISupported());
        this.reporter.startReport(props);
    }

    private void endReport() {
        this.reporter.endReport();
    }

    public String serializeAsXML(XdmNode node) {
        try {
            Serializer serializer = this.runtime.getProcessor().newSerializer();
            serializer.setOutputProperty(Serializer.Property.BYTE_ORDER_MARK, "no");
            serializer.setOutputProperty(Serializer.Property.ENCODING, "utf-8");
            serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            serializer.setOutputStream((OutputStream)os);
            S9apiUtils.serialize(this.runtime, node, serializer);
            String result = os.toString();
            return result;
        }
        catch (SaxonApiException sae) {
            this.logger.warn("Failed to serialize node: " + node);
            this.logger.debug(sae.getMessage(), (Throwable)sae);
            return "";
        }
    }

    public String serialize(XdmNode node) {
        String result = this.serializeAsXML(node);
        result = result.replace("&", "&amp;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        return result;
    }

    public class TestSuiteResult {
        public String testfile = null;
        public String title = "";
        public Vector<XdmNode> description = null;
        public boolean passed = false;
        public QName expectedError = null;
        public QName actualError = null;
        public Vector<String> errorMessages = new Vector();
        public XdmNode expected = null;
        public XdmNode actual = null;

        public TestSuiteResult(String testfile) {
            this.testfile = testfile;
        }

        public void setTitle(XdmNode title) {
            if (title != null) {
                this.title = title.getStringValue();
            }
        }

        public void setDescription(XdmNode desc) {
            if (desc != null) {
                XdmSequenceIterator iter = desc.axisIterator(Axis.CHILD);
                this.description = new Vector();
                while (iter.hasNext()) {
                    XdmNode node = (XdmNode)iter.next();
                    HashSet<String> prefixes = new HashSet<String>();
                    XdmSequenceIterator nsiter = node.axisIterator(Axis.NAMESPACE);
                    while (nsiter.hasNext()) {
                        XdmNode nsnode = (XdmNode)nsiter.next();
                        if (nsnode.getNodeName() == null) continue;
                        String prefix = nsnode.getNodeName().getLocalName();
                        String uri = nsnode.getStringValue();
                        if ("http://www.w3.org/1999/xhtml".equals(uri) || "xml".equals(prefix)) continue;
                        prefixes.add(uri);
                    }
                    node = S9apiUtils.removeNamespaces(RunTestReport.this.runtime, node, prefixes, true);
                    this.description.add(node);
                }
            }
        }

        public boolean passed() {
            return this.passed;
        }

        public void success() {
            this.passed = true;
        }

        public void success(QName expected, QName actual) {
            this.expectedError = expected;
            this.actualError = actual;
            this.passed = true;
        }

        public void fail(QName expectedError) {
            this.errorMessages.add("Test passed, but should have raised " + expectedError);
        }

        public void fail(Exception e) {
            this.catchException(e);
        }

        public void fail(Exception e, String message) {
            this.catchException(e);
            if (message != null) {
                this.errorMessages.add(message);
            }
        }

        public void fail(XdmNode expected, XdmNode actual) {
            this.expected = expected;
            this.actual = actual;
        }

        public void report() {
            RunTestReport.this.reporter.startTestResults(this.passed, this.testfile, this.title);
            if (this.actualError != null && this.expectedError == null || this.actualError == null && this.expectedError != null || this.actualError != null && this.expectedError != null && !this.actualError.equals((Object)this.expectedError)) {
                RunTestReport.this.reporter.testError(this.expectedError, this.actualError);
            }
            RunTestReport.this.reporter.testErrorMessages(this.errorMessages);
            RunTestReport.this.reporter.testExpected(this.expected);
            RunTestReport.this.reporter.testActual(this.actual);
            RunTestReport.this.reporter.endTestResults(this.passed);
        }

        public void catchException(Throwable t) {
            while (t != null) {
                if (t.getMessage() != null) {
                    this.errorMessages.add(t.getMessage());
                } else {
                    this.errorMessages.add(t.toString());
                }
                if (t instanceof XProcException) {
                    XProcException xe = (XProcException)t;
                    this.actualError = xe.getErrorCode();
                    return;
                }
                t = t.getCause();
            }
        }
    }

    public class TestSuiteResults {
        String title = null;
        Vector<TestSuiteResult> results = null;

        public TestSuiteResults(String title, Vector<TestSuiteResult> results) {
            this.title = title;
            this.results = results;
        }

        public TestSuiteResults(Vector<TestSuiteResult> results) {
            this.results = results;
        }

        public String getTitle() {
            return this.title;
        }

        public Vector<TestSuiteResult> getResults() {
            return this.results;
        }

        public void reportResults() {
            if (this.title == null) {
                RunTestReport.this.makeReport(this.results);
            } else {
                RunTestReport.this.reporter.startTestSuite();
                RunTestReport.this.makeReport(this.results);
                RunTestReport.this.reporter.endTestSuite();
            }
        }
    }

    private class XProcPipeline {
        public HashSet<String> inputPorts = new HashSet();
        public HashSet<String> outputPorts = new HashSet();
        public XdmNode pipeline = null;

        public XProcPipeline(XdmNode root) {
            this.pipeline = root;
            for (XdmNode node : new AxisNodes(RunTestReport.this.runtime, root, Axis.CHILD, 31)) {
                if (XProcConstants.p_input.equals((Object)node.getNodeName())) {
                    this.inputPorts.add(node.getAttributeValue(_port));
                }
                if (!XProcConstants.p_output.equals((Object)node.getNodeName())) continue;
                this.outputPorts.add(node.getAttributeValue(_port));
            }
        }
    }

    private class XProcTest {
        private final QName _error = new QName("error");
        private final QName _ignoreWS = new QName("ignore-whitespace-differences");
        public Hashtable<String, Vector<XdmNode>> inputs = new Hashtable();
        public Hashtable<String, Vector<XdmNode>> outputs = new Hashtable();
        public Hashtable<QName, String> parameters = new Hashtable();
        public Hashtable<QName, String> options = new Hashtable();
        public XProcPipeline pipeline = null;
        public XProcPipeline comparepipeline = null;
        public XdmNode title = null;
        public XdmNode description = null;
        public QName error = null;
        public boolean ignoreWS = false;

        public XProcTest(XdmNode root) {
            if (!t_test.equals((Object)root.getNodeName())) {
                throw new XProcException(root, "Test must have t:test as root element.");
            }
            if (root.getAttributeValue(this._error) != null) {
                String errString = root.getAttributeValue(this._error);
                this.error = new QName(errString, root);
            }
            this.ignoreWS = true;
            if (root.getAttributeValue(this._ignoreWS) != null) {
                String ignore = root.getAttributeValue(this._ignoreWS);
                this.ignoreWS = !"false".equals(ignore);
            }
            try {
                this.scan(root);
            }
            catch (Exception e) {
                throw new XProcException(e);
            }
        }

        private void scan(XdmNode pipeline) throws SaxonApiException {
            for (XdmNode node : new AxisNodes(RunTestReport.this.runtime, pipeline, Axis.CHILD, 31)) {
                if (t_title.equals((Object)node.getNodeName())) {
                    this.title = node;
                    continue;
                }
                if (t_description.equals((Object)node.getNodeName())) {
                    this.description = node;
                    continue;
                }
                if (t_input.equals((Object)node.getNodeName()) || t_output.equals((Object)node.getNodeName())) {
                    this.scanio(node);
                    continue;
                }
                if (t_parameter.equals((Object)node.getNodeName()) || t_option.equals((Object)node.getNodeName())) {
                    this.scanop(node);
                    continue;
                }
                if (t_pipeline.equals((Object)node.getNodeName()) || t_compare_pipeline.equals((Object)node.getNodeName())) {
                    this.scanpipe(node);
                    continue;
                }
                throw new XProcException(pipeline, "Not a valid test: " + node.getNodeName());
            }
        }

        private void scanio(XdmNode input) throws SaxonApiException {
            String port = input.getAttributeValue(_port);
            if (port == null) {
                throw new IllegalArgumentException("Each input and output must specify a port");
            }
            if (t_output.equals((Object)input.getNodeName()) && this.outputs.containsKey(port)) {
                throw new IllegalArgumentException("Attempt to redefine output port: " + port);
            }
            String href = input.getAttributeValue(_href);
            if (href != null) {
                this.add(input, port, href);
            } else {
                for (XdmNode node : new AxisNodes(input, Axis.CHILD, 0)) {
                    if (node.getNodeKind() != XdmNodeKind.ELEMENT) {
                        if (node.getNodeKind() != XdmNodeKind.TEXT || "".equals(node.getStringValue().trim())) continue;
                        throw new IllegalArgumentException("Content of t:input/t:output must be well-formed XML");
                    }
                    if (t_document.equals((Object)node.getNodeName())) {
                        href = node.getAttributeValue(_href);
                        if (href != null) {
                            this.add(input, port, href);
                            continue;
                        }
                        Vector<XdmValue> nodes = new Vector<XdmValue>();
                        XdmSequenceIterator iter = node.axisIterator(Axis.CHILD);
                        while (iter.hasNext()) {
                            nodes.add((XdmValue)iter.next());
                        }
                        XdmDestination dest = new XdmDestination();
                        S9apiUtils.writeXdmValue(RunTestReport.this.runtime, nodes, (Destination)dest, node.getBaseURI());
                        this.add(input, port, dest.getXdmNode());
                        continue;
                    }
                    XdmDestination dest = new XdmDestination();
                    dest.setBaseURI(node.getBaseURI());
                    S9apiUtils.writeXdmValue(RunTestReport.this.runtime, (XdmItem)node, (Destination)dest, node.getBaseURI());
                    XdmNode newNode = dest.getXdmNode();
                    this.add(input, port, newNode);
                }
            }
        }

        private void scanpipe(XdmNode input) throws SaxonApiException {
            URI baseURI = input.getBaseURI();
            String href = input.getAttributeValue(_href);
            if (href != null) {
                this.add(input, null, baseURI.resolve(href).toASCIIString());
            } else {
                XdmNode docroot = null;
                for (XdmNode node : new AxisNodes(RunTestReport.this.runtime, input, Axis.CHILD, 31)) {
                    if (node.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                    docroot = node;
                }
                if (t_document.equals((Object)docroot.getNodeName())) {
                    href = docroot.getAttributeValue(_href);
                    if (href != null) {
                        this.add(input, null, docroot.getBaseURI().resolve(href).toASCIIString());
                    } else {
                        XdmNode root = S9apiUtils.getDocumentElement(docroot);
                        this.add(input, null, root);
                    }
                } else {
                    this.add(input, null, docroot);
                }
            }
        }

        private void scanop(XdmNode input) {
            String namestr = input.getAttributeValue(_name);
            String value = input.getAttributeValue(_value);
            if (namestr == null || value == null) {
                throw new IllegalArgumentException("Each option and parameter must specify a name and a value");
            }
            QName name = new QName(namestr, input);
            if (t_option.equals((Object)input.getNodeName())) {
                if (this.options.containsKey(name)) {
                    throw new IllegalArgumentException("Attempt to redefine option: " + name);
                }
                this.options.put(name, value);
            } else {
                if (this.parameters.containsKey(name)) {
                    throw new IllegalArgumentException("Attempt to redefine parameter: " + name);
                }
                this.parameters.put(name, value);
            }
            Iterator<XdmNode> iterator = new AxisNodes(RunTestReport.this.runtime, input, Axis.CHILD, 31).iterator();
            if (iterator.hasNext()) {
                XdmNode node = iterator.next();
                throw new IllegalArgumentException("Options and parameters must be empty.");
            }
        }

        private void add(XdmNode node, String port, String href) throws SaxonApiException {
            String rhref = node.getBaseURI().resolve(href).toASCIIString();
            this.add(node, port, RunTestReport.this.runtime.parse(new InputSource(rhref)));
        }

        private void add(XdmNode node, String port, XdmNode root) {
            String type = node.getNodeName().getLocalName();
            if ("input".equals(type)) {
                if (!this.inputs.containsKey(port)) {
                    this.inputs.put(port, new Vector());
                }
                this.inputs.get(port).add(root);
            } else if ("output".equals(type)) {
                if (!this.outputs.containsKey(port)) {
                    this.outputs.put(port, new Vector());
                }
                this.outputs.get(port).add(root);
            } else if ("pipeline".equals(type)) {
                if (this.pipeline != null) {
                    throw new UnsupportedOperationException("Only one pipeline can be defined.");
                }
                this.pipeline = new XProcPipeline(root);
            } else if ("compare-pipeline".equals(type)) {
                if (this.comparepipeline != null) {
                    throw new UnsupportedOperationException("Only one compare pipeline can be defined.");
                }
                this.comparepipeline = new XProcPipeline(root);
            } else {
                throw new UnsupportedOperationException("Unexpected type: " + type);
            }
        }
    }
}

