/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.TypeUtils;
import com.xmlcalabash.util.XPointerScheme;
import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class XPointer {
    private static final QName _xmlns = new QName("", "xmlns");
    private static final QName _element = new QName("", "element");
    private static final QName _xpath = new QName("", "xpath");
    private static final QName _text = new QName("", "text");
    private static final QName _search = new QName("", "search");
    private Vector<XPointerScheme> parts = new Vector();
    private int readLimit = 0;
    private XProcRuntime runtime = null;

    public XPointer(XProcRuntime runtime, String xpointer, int readLimit) {
        this.runtime = runtime;
        this.readLimit = readLimit;
        String pointer = xpointer;
        while (pointer != null) {
            pointer = this.parse(pointer);
        }
    }

    public Hashtable<String, String> xpathNamespaces() {
        Hashtable<String, String> bindings = new Hashtable<String, String>();
        for (XPointerScheme scheme : this.parts) {
            if (!_xmlns.equals((Object)scheme.getName())) continue;
            XPointerXmlnsScheme xmlns = (XPointerXmlnsScheme)scheme;
            bindings.put(xmlns.getPrefix(), xmlns.getURI());
        }
        return bindings;
    }

    public Vector<XdmNode> selectNodes(XProcRuntime runtime, XdmNode doc) {
        Vector<XdmNode> result = null;
        for (XPointerScheme scheme : this.parts) {
            String select = scheme.xpathEquivalent();
            if (result != null || select == null) continue;
            try {
                result = scheme.selectNodes(runtime, doc, this.xpathNamespaces());
            }
            catch (XProcException e) {
                result = null;
            }
            if (result == null || result.size() != 0) continue;
            result = null;
        }
        return result;
    }

    public String selectText(BufferedReader stream, int contentLength) {
        String result = null;
        RuntimeException except = null;
        for (XPointerScheme scheme : this.parts) {
            String select = scheme.textEquivalent();
            if (result != null || select == null) continue;
            try {
                if (select.startsWith("search=")) {
                    result = scheme.selectSearchText(stream, contentLength);
                    continue;
                }
                result = scheme.selectText(stream, contentLength);
            }
            catch (IllegalArgumentException iae) {
                except = iae;
                result = null;
            }
            catch (XProcException xe) {
                except = xe;
                result = null;
            }
        }
        if (result == null && except != null) {
            throw except;
        }
        return result;
    }

    private String parse(String xpointer) {
        if (xpointer.startsWith("/") && !xpointer.contains("(")) {
            xpointer = "element(" + xpointer + ")";
        } else {
            try {
                TypeUtils.checkType(this.runtime, null, xpointer, XProcConstants.xs_NCName, null);
                xpointer = "element(" + xpointer + ")";
            }
            catch (XProcException xProcException) {
                // empty catch block
            }
        }
        xpointer = xpointer.trim();
        if (xpointer.matches("^[\\w:]+\\s*\\(.*")) {
            Pattern scheme = Pattern.compile("^([\\w+:]+)\\s*(\\(.*)$");
            Matcher matcher = scheme.matcher(xpointer);
            if (matcher.matches()) {
                QName name = this.schemeName(matcher.group(1));
                String data = matcher.group(2);
                int dataend = this.indexOfEnd(data);
                if (dataend < 0) {
                    throw new XProcException("Unparseable XPointer: " + xpointer);
                }
                String rest = data.substring(dataend);
                data = data.substring(1, dataend - 1);
                data = this.cleanup(data);
                if (_xmlns.equals((Object)name)) {
                    this.parts.add(new XPointerXmlnsScheme(name, data, this.readLimit));
                } else if (_element.equals((Object)name)) {
                    this.parts.add(new XPointerElementScheme(name, data, this.readLimit));
                } else if (_xpath.equals((Object)name)) {
                    this.parts.add(new XPointerXPathScheme(name, data, this.readLimit));
                } else if (_text.equals((Object)name)) {
                    this.parts.add(new XPointerTextScheme(name, data, this.readLimit));
                } else if (_search.equals((Object)name)) {
                    this.parts.add(new XPointerTextSearchScheme(name, data, this.readLimit));
                } else {
                    this.parts.add(new XPointerScheme(name, data, this.readLimit));
                }
                if ("".equals(rest)) {
                    rest = null;
                }
                return rest;
            }
            scheme = Pattern.compile("^([\\w+:]+)\\s*\\(\\)\\s*(.*)$");
            matcher = scheme.matcher(xpointer);
            if (matcher.matches()) {
                QName name = this.schemeName(matcher.group(1));
                String data = this.cleanup(matcher.group(2));
                this.parts.add(new XPointerScheme(name, data, this.readLimit));
                String rest = matcher.group(3);
                if ("".equals(rest)) {
                    rest = null;
                }
                return rest;
            }
            throw new XProcException("Unparseable XPointer: " + xpointer);
        }
        if (xpointer.matches("^[\\w:]+\\s*$")) {
            this.parts.add(new XPointerScheme(_element, xpointer, this.readLimit));
            return null;
        }
        throw new XProcException("Unparseable XPointer: " + xpointer);
    }

    private QName schemeName(String name) {
        if (name.contains(":")) {
            int pos = name.indexOf(":");
            String pfx = name.substring(0, pos);
            String lcl = name.substring(pos + 1);
            Object qname = null;
            for (pos = this.parts.size() - 1; qname == null && pos >= 0; --pos) {
                XPointerScheme scheme = this.parts.get(pos);
                if (!(scheme instanceof XPointerXmlnsScheme)) continue;
                String prefix = ((XPointerXmlnsScheme)scheme).prefix;
                String uri = ((XPointerXmlnsScheme)scheme).uri;
                if (!pfx.equals(prefix)) continue;
                return new QName(pfx, uri, lcl);
            }
        } else {
            return new QName("", name);
        }
        throw new XProcException("Scheme name without bound prefix: " + name);
    }

    private int indexOfEnd(String data) {
        int pos;
        data = data.replaceAll("\\^[\\(\\)]", "xx");
        int depth = 0;
        boolean done = false;
        for (pos = 0; pos < data.length() && !done; ++pos) {
            String s = data.substring(pos, pos + 1);
            if ("(".equals(s)) {
                ++depth;
            } else if (")".equals(s)) {
                --depth;
            }
            done = ")".equals(s) && depth == 0;
        }
        if (depth != 0) {
            return -1;
        }
        return pos;
    }

    private String cleanup(String data) {
        String repl = data.replaceAll("\\^([\\(\\)\\^])", "$1");
        return repl;
    }

    private class XPointerTextSearchScheme
    extends XPointerScheme {
        public XPointerTextSearchScheme(QName name, String data, int readLimit) {
            super(name, data, readLimit);
        }

        @Override
        public String textEquivalent() {
            return this.schemeData;
        }
    }

    private class XPointerTextScheme
    extends XPointerScheme {
        public XPointerTextScheme(QName name, String data, int readLimit) {
            super(name, data, readLimit);
        }

        @Override
        public String textEquivalent() {
            return this.schemeData;
        }
    }

    private class XPointerXPathScheme
    extends XPointerScheme {
        public XPointerXPathScheme(QName name, String data, int readLimit) {
            super(name, data, readLimit);
        }

        @Override
        public String xpathEquivalent() {
            return this.schemeData;
        }
    }

    private class XPointerElementScheme
    extends XPointerScheme {
        public XPointerElementScheme(QName name, String data, int readLimit) {
            super(name, data, readLimit);
        }

        @Override
        public String xpathEquivalent() {
            String xpath = "";
            String data = this.schemeData;
            int pos = data.indexOf("/");
            if (pos < 0) {
                return "id('" + data + "')";
            }
            if (pos > 0) {
                xpath = "id('" + data.substring(0, pos) + "')";
                data = data.substring(pos);
            }
            Pattern dscheme = Pattern.compile("^/(\\d+)(.*)$");
            Matcher dmatcher = dscheme.matcher(data);
            while (dmatcher.matches()) {
                xpath = xpath + "/*[" + dmatcher.group(1) + "]";
                data = dmatcher.group(2);
                dmatcher = dscheme.matcher(data);
            }
            if (!"".equals(data)) {
                throw new XProcException("Element pointer didn't parse.");
            }
            return xpath;
        }
    }

    private class XPointerXmlnsScheme
    extends XPointerScheme {
        protected String prefix;
        protected String uri;

        public XPointerXmlnsScheme(QName name, String data, int readLimit) {
            super(name, data, readLimit);
            this.prefix = null;
            this.uri = null;
            Pattern scheme = Pattern.compile("([\\w:]+)\\s*=\\s*([^=]+)$");
            Matcher matcher = scheme.matcher(data);
            if (!matcher.matches()) {
                throw new XProcException("Unparseable xmlns(): " + data);
            }
            this.prefix = matcher.group(1);
            this.uri = matcher.group(2);
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getURI() {
            return this.uri;
        }
    }
}

