/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.util.TreeWriter;
import java.util.Iterator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONtoXML {
    public static final String CALABASH_DEPRECATED = "calabash-deprecated";
    public static final String CALABASH = "calabash";
    public static final String JSONX = "jsonx";
    public static final String JXML = "jxml";
    public static final String MARKLOGIC = "marklogic";
    public static final String JSONX_NS = "http://www.ibm.com/xmlns/prod/2009/jsonx";
    public static final String MLJS_NS = "http://marklogic.com/json";
    public static final String JXML_NS = "http://www.xmlsh.org/jxml";
    private static final QName _type = new QName("", "type");
    private static final QName _name = new QName("", "name");
    private static final QName c_json = new QName("c", "http://www.w3.org/ns/xproc-step", "json");
    private static final QName c_pair = new QName("c", "http://www.w3.org/ns/xproc-step", "pair");
    private static final QName c_item = new QName("c", "http://www.w3.org/ns/xproc-step", "item");
    private static final QName _json = new QName("json");
    private static final QName _pair = new QName("pair");
    private static final QName _item = new QName("item");
    private static final QName j_object = new QName("j", "http://www.ibm.com/xmlns/prod/2009/jsonx", "object");
    private static final QName j_array = new QName("j", "http://www.ibm.com/xmlns/prod/2009/jsonx", "array");
    private static final QName j_string = new QName("j", "http://www.ibm.com/xmlns/prod/2009/jsonx", "string");
    private static final QName j_number = new QName("j", "http://www.ibm.com/xmlns/prod/2009/jsonx", "number");
    private static final QName j_boolean = new QName("j", "http://www.ibm.com/xmlns/prod/2009/jsonx", "boolean");
    private static final QName j_null = new QName("j", "http://www.ibm.com/xmlns/prod/2009/jsonx", "null");
    private static final QName mj_json = new QName("j", "http://marklogic.com/json", "json");
    private static final QName jx_object = new QName("j", "http://www.xmlsh.org/jxml", "object");
    private static final QName jx_member = new QName("j", "http://www.xmlsh.org/jxml", "member");
    private static final QName jx_boolean = new QName("j", "http://www.xmlsh.org/jxml", "boolean");
    private static final QName jx_array = new QName("j", "http://www.xmlsh.org/jxml", "array");
    private static final QName jx_string = new QName("j", "http://www.xmlsh.org/jxml", "string");
    private static final QName jx_number = new QName("j", "http://www.xmlsh.org/jxml", "number");
    private static final QName jx_null = new QName("j", "http://www.xmlsh.org/jxml", "null");

    public static boolean knownFlavor(String jsonFlavor) {
        return CALABASH_DEPRECATED.equals(jsonFlavor) || CALABASH.equals(jsonFlavor) || JSONX.equals(jsonFlavor) || JXML.equals(jsonFlavor) || MARKLOGIC.equals(jsonFlavor);
    }

    public static XdmNode convert(Processor processor, JSONTokener jt, String flavor) {
        TreeWriter tree = new TreeWriter(processor);
        tree.startDocument(null);
        if (JSONX.equals(flavor)) {
            JSONtoXML.buildJsonX(tree, jt);
        } else if (MARKLOGIC.equals(flavor)) {
            JSONtoXML.buildMarkLogic(tree, jt);
        } else if (JXML.equals(flavor)) {
            JSONtoXML.buildJxml(tree, jt);
        } else if (CALABASH.equals(flavor)) {
            JSONtoXML.buildMine(tree, jt, true);
        } else {
            JSONtoXML.buildMine(tree, jt, false);
        }
        tree.endDocument();
        return tree.getResult();
    }

    private static void buildJsonX(TreeWriter tree, JSONTokener jt) {
        try {
            char ch = jt.next();
            jt.back();
            if (ch == '{') {
                tree.addStartElement(j_object);
                tree.startContent();
                JSONtoXML.buildJsonXPairs(tree, new JSONObject(jt));
            } else {
                tree.addStartElement(j_array);
                JSONtoXML.buildJsonXArray(tree, new JSONArray(jt));
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
        tree.addEndElement();
    }

    private static void buildJsonXPairs(TreeWriter tree, JSONObject jo) {
        try {
            Iterator<String> keys = jo.keys();
            while (keys.hasNext()) {
                String name = keys.next();
                Object json = jo.get(name);
                JSONtoXML.serializeJsonX(tree, json, name);
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }

    private static void buildJsonXArray(TreeWriter tree, JSONArray arr) {
        try {
            for (int pos = 0; pos < arr.length(); ++pos) {
                Object json = arr.get(pos);
                JSONtoXML.serializeJsonX(tree, json, null);
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }

    private static void serializeJsonX(TreeWriter tree, Object json, String name) {
        if (json instanceof JSONObject) {
            tree.addStartElement(j_object);
            if (name != null) {
                tree.addAttribute(_name, name);
            }
            tree.startContent();
            JSONtoXML.buildJsonXPairs(tree, (JSONObject)json);
            tree.addEndElement();
        } else if (json instanceof JSONArray) {
            tree.addStartElement(j_array);
            if (name != null) {
                tree.addAttribute(_name, name);
            }
            tree.startContent();
            JSONtoXML.buildJsonXArray(tree, (JSONArray)json);
            tree.addEndElement();
        } else if (json instanceof Integer || json instanceof Double || json instanceof Long) {
            tree.addStartElement(j_number);
            if (name != null) {
                tree.addAttribute(_name, name);
            }
            tree.startContent();
            tree.addText(json.toString());
            tree.addEndElement();
        } else if (json instanceof String) {
            tree.addStartElement(j_string);
            if (name != null) {
                tree.addAttribute(_name, name);
            }
            tree.startContent();
            tree.addText(json.toString());
            tree.addEndElement();
        } else if (json instanceof Boolean) {
            tree.addStartElement(j_boolean);
            if (name != null) {
                tree.addAttribute(_name, name);
            }
            tree.startContent();
            tree.addText(json.toString());
            tree.addEndElement();
        } else if (json == JSONObject.NULL) {
            tree.addStartElement(j_null);
            if (name != null) {
                tree.addAttribute(_name, name);
            }
            tree.startContent();
            tree.addEndElement();
        } else {
            throw new XProcException("Unexpected type in JSON conversion.");
        }
    }

    private static void buildMarkLogic(TreeWriter tree, JSONTokener jt) {
        tree.addStartElement(mj_json);
        try {
            char ch = jt.next();
            jt.back();
            if (ch == '{') {
                tree.addAttribute(_type, "object");
                tree.startContent();
                JSONtoXML.buildMarkLogicPairs(tree, new JSONObject(jt));
            } else {
                tree.addAttribute(_type, "object");
                JSONtoXML.buildMarkLogicArray(tree, new JSONArray(jt));
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
        tree.addEndElement();
    }

    private static void buildMarkLogicPairs(TreeWriter tree, JSONObject jo) {
        try {
            Iterator<String> keys = jo.keys();
            while (keys.hasNext()) {
                String name = keys.next();
                Object json = jo.get(name);
                JSONtoXML.serializeMarkLogic(tree, json, name);
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }

    private static void buildMarkLogicArray(TreeWriter tree, JSONArray arr) {
        try {
            for (int pos = 0; pos < arr.length(); ++pos) {
                Object json = arr.get(pos);
                JSONtoXML.serializeMarkLogic(tree, json, null);
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }

    private static void serializeMarkLogic(TreeWriter tree, Object json, String name) {
        String localName = "item";
        if (name != null) {
            if ("".equals(name)) {
                localName = "_";
            } else {
                localName = "";
                for (int pos = 0; pos < name.length(); ++pos) {
                    char ch = name.charAt(pos);
                    localName = '_' != ch && (pos == 0 && XMLCharacterData.isNCNameStart10((int)ch) || pos > 0 && XMLCharacterData.isNCName10((int)ch)) ? localName + Character.toString(ch) : localName + String.format("_%04x", ch);
                }
            }
        }
        QName elemName = new QName("j", MLJS_NS, localName);
        tree.addStartElement(elemName);
        if (json instanceof JSONObject) {
            tree.addAttribute(_type, "object");
            tree.startContent();
            JSONtoXML.buildMarkLogicPairs(tree, (JSONObject)json);
        } else if (json instanceof JSONArray) {
            tree.addAttribute(_type, "array");
            tree.startContent();
            JSONtoXML.buildMarkLogicArray(tree, (JSONArray)json);
        } else if (json instanceof Integer || json instanceof Double || json instanceof Long) {
            tree.addAttribute(_type, "number");
            tree.startContent();
            tree.addText(json.toString());
        } else if (json instanceof String) {
            tree.addAttribute(_type, "string");
            tree.startContent();
            tree.addText(json.toString());
        } else if (json instanceof Boolean) {
            tree.addAttribute(_type, "boolean");
            tree.startContent();
            tree.addText(json.toString());
        } else if (json == JSONObject.NULL) {
            tree.addAttribute(_type, "null");
            tree.startContent();
        } else {
            throw new XProcException("Unexpected type in JSON conversion.");
        }
        tree.addEndElement();
    }

    private static void buildJxml(TreeWriter tree, JSONTokener jt) {
        try {
            char ch = jt.next();
            jt.back();
            if (ch == '{') {
                tree.addStartElement(jx_object);
                tree.startContent();
                JSONtoXML.buildJxmlPairs(tree, new JSONObject(jt));
            } else {
                tree.addStartElement(jx_array);
                JSONtoXML.buildJxmlArray(tree, new JSONArray(jt));
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
        tree.addEndElement();
    }

    private static void buildJxmlPairs(TreeWriter tree, JSONObject jo) {
        try {
            Iterator<String> keys = jo.keys();
            while (keys.hasNext()) {
                String name = keys.next();
                Object json = jo.get(name);
                JSONtoXML.serializeJxml(tree, json, name);
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }

    private static void buildJxmlArray(TreeWriter tree, JSONArray arr) {
        try {
            for (int pos = 0; pos < arr.length(); ++pos) {
                Object json = arr.get(pos);
                JSONtoXML.serializeJxml(tree, json, null);
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }

    private static void serializeJxml(TreeWriter tree, Object json, String name) {
        if (name != null) {
            tree.addStartElement(jx_member);
            tree.addAttribute(_name, name);
            tree.startContent();
        }
        if (json instanceof JSONObject) {
            tree.addStartElement(jx_object);
            tree.startContent();
            JSONtoXML.buildJxmlPairs(tree, (JSONObject)json);
            tree.addEndElement();
        } else if (json instanceof JSONArray) {
            tree.addStartElement(jx_array);
            tree.startContent();
            JSONtoXML.buildJxmlArray(tree, (JSONArray)json);
            tree.addEndElement();
        } else if (json instanceof Integer || json instanceof Double || json instanceof Long) {
            tree.addStartElement(jx_number);
            tree.startContent();
            tree.addText(json.toString());
            tree.addEndElement();
        } else if (json instanceof String) {
            tree.addStartElement(jx_string);
            tree.startContent();
            tree.addText(json.toString());
            tree.addEndElement();
        } else if (json instanceof Boolean) {
            tree.addStartElement(jx_boolean);
            tree.startContent();
            tree.addText(json.toString());
            tree.addEndElement();
        } else if (json == JSONObject.NULL) {
            tree.addStartElement(jx_null);
            tree.startContent();
            tree.addEndElement();
        } else {
            throw new XProcException("Unexpected type in JSON conversion.");
        }
        if (name != null) {
            tree.addEndElement();
        }
    }

    private static void buildMine(TreeWriter tree, JSONTokener jt, boolean usens) {
        tree.addStartElement(usens ? c_json : _json);
        try {
            char ch = jt.next();
            jt.back();
            if (ch == '{') {
                tree.addAttribute(_type, "object");
                tree.startContent();
                JSONtoXML.buildMyPairs(tree, new JSONObject(jt), usens);
            } else {
                tree.addAttribute(_type, "array");
                tree.startContent();
                JSONtoXML.buildMyArray(tree, new JSONArray(jt), usens);
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
        tree.addEndElement();
    }

    private static void buildMyPairs(TreeWriter tree, JSONObject jo, boolean usens) {
        try {
            Iterator<String> keys = jo.keys();
            while (keys.hasNext()) {
                String name = keys.next();
                Object json = jo.get(name);
                tree.addStartElement(usens ? c_pair : _pair);
                tree.addAttribute(_name, name);
                if (json instanceof JSONObject) {
                    tree.addAttribute(_type, "object");
                    tree.startContent();
                    JSONtoXML.buildMyPairs(tree, (JSONObject)json, usens);
                } else if (json instanceof JSONArray) {
                    tree.addAttribute(_type, "array");
                    tree.startContent();
                    JSONtoXML.buildMyArray(tree, (JSONArray)json, usens);
                } else if (json instanceof Integer) {
                    tree.addAttribute(_type, "number");
                    tree.startContent();
                    tree.addText(json.toString());
                } else if (json instanceof Double) {
                    tree.addAttribute(_type, "number");
                    tree.startContent();
                    tree.addText(json.toString());
                } else if (json instanceof Long) {
                    tree.addAttribute(_type, "number");
                    tree.startContent();
                    tree.addText(json.toString());
                } else if (json instanceof String) {
                    tree.addAttribute(_type, "string");
                    tree.startContent();
                    tree.addText(json.toString());
                } else if (json instanceof Boolean) {
                    tree.addAttribute(_type, "boolean");
                    tree.startContent();
                    tree.addText(json.toString());
                } else if (json == JSONObject.NULL) {
                    tree.addAttribute(_type, "null");
                    tree.startContent();
                } else {
                    throw new XProcException("Unexpected type in JSON conversion.");
                }
                tree.addEndElement();
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }

    private static void buildMyArray(TreeWriter tree, JSONArray arr, boolean usens) {
        try {
            for (int pos = 0; pos < arr.length(); ++pos) {
                Object json = arr.get(pos);
                tree.addStartElement(usens ? c_item : _item);
                if (json instanceof JSONObject) {
                    tree.addAttribute(_type, "object");
                    tree.startContent();
                    JSONtoXML.buildMyPairs(tree, (JSONObject)json, usens);
                } else if (json instanceof JSONArray) {
                    tree.addAttribute(_type, "array");
                    tree.startContent();
                    JSONtoXML.buildMyArray(tree, (JSONArray)json, usens);
                } else if (json instanceof Integer) {
                    tree.addAttribute(_type, "number");
                    tree.startContent();
                    tree.addText(json.toString());
                } else if (json instanceof Double) {
                    tree.addAttribute(_type, "number");
                    tree.startContent();
                    tree.addText(json.toString());
                } else if (json instanceof Long) {
                    tree.addAttribute(_type, "number");
                    tree.startContent();
                    tree.addText(json.toString());
                } else if (json instanceof String) {
                    tree.addAttribute(_type, "string");
                    tree.startContent();
                    tree.addText(json.toString());
                } else if (json instanceof Boolean) {
                    tree.addAttribute(_type, "boolean");
                    tree.startContent();
                    tree.addText(json.toString());
                } else if (json == JSONObject.NULL) {
                    tree.addAttribute(_type, "null");
                    tree.startContent();
                } else {
                    throw new XProcException("Unexpected type in JSON conversion.");
                }
                tree.addEndElement();
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }
}

