/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

public class HttpUtils {
    protected HttpUtils() {
    }

    public static String baseContentType(String contentType) {
        if (contentType != null && contentType.matches("(^.*)[ \t]*;.*$")) {
            return contentType.replaceAll("(^.*)[ \t]*;.*$", "$1");
        }
        return contentType;
    }

    public static boolean xmlContentType(String contentType) {
        String baseType = HttpUtils.baseContentType(contentType);
        return baseType != null && ("application/xml".equals(baseType) || "text/xml".equals(baseType) || baseType.endsWith("+xml"));
    }

    public static boolean jsonContentType(String contentType) {
        String baseType = HttpUtils.baseContentType(contentType);
        return baseType != null && ("application/json".equals(baseType) || "text/json".equals(baseType));
    }

    public static boolean textContentType(String contentType) {
        return contentType != null && contentType.startsWith("text/");
    }

    public static String getCharset(String contentType, String defaultCharset) {
        String charset = HttpUtils.getCharset(contentType);
        if (charset == null) {
            return defaultCharset;
        }
        return charset;
    }

    public static String getCharset(String contentType) {
        String charset = null;
        if (contentType != null && contentType.matches("^.*;[ \t]*charset=([^ \t]+).*$") && ((charset = contentType.replaceAll("^.*;[ \t]*charset=([^ \t]+).*$", "$1")).startsWith("\"") || charset.startsWith("'"))) {
            charset = charset.substring(1, charset.length() - 1);
        }
        return charset;
    }
}

