/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Variable;
import com.xmlcalabash.runtime.XCatch;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XGroup;
import com.xmlcalabash.runtime.XInput;
import com.xmlcalabash.runtime.XOutput;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XProcMessageListenerHelper;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class XTry
extends XCompoundStep {
    private static final QName c_errors = new QName("c", "http://www.w3.org/ns/xproc-step", "errors");
    private static final QName c_error = new QName("c", "http://www.w3.org/ns/xproc-step", "error");
    private static final QName _href = new QName("", "href");
    private static final QName _line = new QName("", "line");
    private static final QName _column = new QName("", "column");
    private static final QName _code = new QName("", "code");
    private boolean inCatch = false;
    private Vector<XdmNode> errors = new Vector();

    public XTry(XProcRuntime runtime, Step step, XCompoundStep parent) {
        super(runtime, step, parent);
    }

    @Override
    public void instantiate(Step step) {
        this.parent.addStep(this);
        DeclareStep decl = step.getDeclaration();
        for (Step substep : decl.subpipeline()) {
            XCompoundStep newstep;
            if (XProcConstants.p_group.equals((Object)substep.getType())) {
                newstep = new XGroup(this.runtime, substep, this);
                newstep.instantiate(substep);
                continue;
            }
            if (XProcConstants.p_catch.equals((Object)substep.getType())) {
                newstep = new XCatch(this.runtime, substep, this);
                newstep.instantiate(substep);
                continue;
            }
            throw new XProcException(step, "This can't happen, can it? try contains something that isn't a group or a catch?");
        }
        for (Output output : step.outputs()) {
            String port = output.getPort();
            if (port.endsWith("|")) {
                String rport = port.substring(0, port.length() - 1);
                XInput xinput = this.getInput(rport);
                Pipe wpipe = xinput.getWriter();
                this.outputs.put(port, wpipe);
                this.logger.trace(MessageFormatter.nodeMessage(step.getNode(), " writes to " + wpipe + " for " + port));
                continue;
            }
            XOutput xoutput = new XOutput(this.runtime, output);
            this.addOutput(xoutput);
            Pipe wpipe = xoutput.getWriter();
            this.outputs.put(port, wpipe);
            this.logger.trace(MessageFormatter.nodeMessage(step.getNode(), " writes to " + wpipe + " for " + port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() throws SaxonApiException {
        this.inScopeOptions = this.parent.getInScopeOptions();
        for (Variable variable : this.step.getVariables()) {
            RuntimeValue value = this.computeValue(variable);
            this.inScopeOptions.put(variable.getName(), value);
        }
        XGroup xgroup = (XGroup)this.subpipeline.get(0);
        for (String port : this.inputs.keySet()) {
            if (port.startsWith("|")) continue;
            xgroup.inputs.put(port, this.inputs.get(port));
        }
        for (String port : this.outputs.keySet()) {
            if (port.endsWith("|")) continue;
            xgroup.outputs.put(port, this.outputs.get(port));
        }
        XProcMessageListenerHelper.openStep(this.runtime, this);
        try {
            xgroup.run();
        }
        catch (XProcException xProcException) {
            this.logger.trace("p:try: caught error: " + xProcException.toString());
            this.logger.trace("", (Throwable)xProcException);
            TreeWriter treeWriter = new TreeWriter(this.runtime);
            treeWriter.startDocument(this.step.getNode().getBaseURI());
            treeWriter.addStartElement(c_errors);
            treeWriter.startContent();
            boolean reported = false;
            for (XdmNode doc : this.runtime.getXProcData().errors()) {
                treeWriter.addSubtree(doc);
                reported = true;
            }
            for (XdmNode doc : this.errors) {
                treeWriter.addSubtree(doc);
                reported = true;
            }
            if (!reported) {
                xProcException.serialize(treeWriter);
            }
            treeWriter.addEndElement();
            treeWriter.endDocument();
            XCatch xcatch = (XCatch)this.subpipeline.get(1);
            xcatch.writeError(treeWriter.getResult());
            for (String port : this.inputs.keySet()) {
                if (port.startsWith("|")) continue;
                xcatch.inputs.put(port, this.inputs.get(port));
            }
            for (String port : this.outputs.keySet()) {
                if (port.endsWith("|")) continue;
                xcatch.outputs.put(port, this.outputs.get(port));
            }
            this.inCatch = true;
            xcatch.run();
        }
        finally {
            this.inCatch = false;
            this.runtime.getMessageListener().closeStep();
        }
    }

    @Override
    public void reportError(XdmNode doc) {
        if (this.inCatch) {
            super.reportError(doc);
        } else {
            this.errors.add(doc);
        }
    }
}

