/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadOnlyPipe;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Log;
import com.xmlcalabash.model.Output;
import java.util.Vector;
import net.sf.saxon.s9api.XdmNode;

public class XOutput {
    private final XProcRuntime runtime;
    private final String port;
    private final XdmNode node;
    private final boolean sequenceOk;
    private final Pipe writer;
    private boolean writerReturned = false;
    private final Vector<ReadablePipe> readers;

    public XOutput(XProcRuntime runtime, Output output) {
        this.runtime = runtime;
        this.node = output.getNode();
        this.port = output.getPort();
        this.sequenceOk = output.getSequence();
        this.writer = new Pipe(runtime);
        this.writer.canWriteSequence(this.sequenceOk);
        this.readers = new Vector();
    }

    public void setLogger(Log log) {
        this.writer.documents().setLogger(log);
    }

    public XdmNode getNode() {
        return this.node;
    }

    public String getPort() {
        return this.port;
    }

    public boolean getSequence() {
        return this.sequenceOk;
    }

    public ReadablePipe getReader() {
        ReadOnlyPipe pipe = new ReadOnlyPipe(this.runtime, this.writer.documents());
        this.readers.add(pipe);
        return pipe;
    }

    public Pipe getWriter() {
        if (this.writerReturned) {
            throw new XProcException(this.node, "Attempt to create two writers for the same output.");
        }
        return this.writer;
    }
}

