/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.Catch;
import com.xmlcalabash.model.Choose;
import com.xmlcalabash.model.CompoundStep;
import com.xmlcalabash.model.DeclarationScope;
import com.xmlcalabash.model.EmptyBinding;
import com.xmlcalabash.model.EndPoint;
import com.xmlcalabash.model.Environment;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Parameter;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.PipelineLibrary;
import com.xmlcalabash.model.Port;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.When;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class DeclareStep
extends CompoundStep
implements DeclarationScope {
    protected boolean psviRequired = false;
    protected String xpathVersion = "2.0";
    private QName declaredType = null;
    private boolean atomic = true;
    protected Hashtable<QName, DeclareStep> declaredSteps = new Hashtable();
    private List<PipelineLibrary> importedLibs = new ArrayList<PipelineLibrary>();
    private List<XdmNode> xsltFunctionImports = new ArrayList<XdmNode>();
    private DeclarationScope parentScope = null;
    private Vector<XdmNode> rest = null;
    private HashSet<String> excludedInlineNamespaces = null;
    private URI sourceImport = null;
    private boolean setup = false;

    public DeclareStep(XProcRuntime xproc, XdmNode node, String name) {
        super(xproc, node, XProcConstants.p_declare_step, name);
    }

    protected void setXmlContent(Vector<XdmNode> nodes) {
        this.rest = nodes;
    }

    protected Vector<XdmNode> getXmlContent() {
        return this.rest;
    }

    public void setPsviRequired(boolean psvi) {
        this.psviRequired = psvi;
    }

    public void setXPathVersion(String version) {
        this.xpathVersion = version;
    }

    public void setDeclaredType(QName type) {
        this.declaredType = type;
    }

    public void setExcludeInlineNamespaces(HashSet<String> uris) {
        this.excludedInlineNamespaces = uris;
    }

    public HashSet<String> getExcludeInlineNamespaces() {
        return this.excludedInlineNamespaces;
    }

    public void setAtomic(boolean isAtomic) {
        this.atomic = isAtomic;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    @Override
    public boolean isPipeline() {
        return !this.atomic;
    }

    @Override
    public QName getDeclaredType() {
        return this.declaredType;
    }

    public void setParentScope(DeclarationScope decls) {
        this.parentScope = decls;
    }

    @Override
    public void declareStep(QName type, DeclareStep step) {
        DeclareStep d = this.getDeclaration(type);
        if (d != null) {
            if (!d.equals(step)) {
                throw new XProcException(step, "Duplicate step type: " + type);
            }
        } else {
            this.declaredSteps.put(type, step);
        }
    }

    public void addImport(PipelineLibrary lib) {
        this.importedLibs.add(lib);
    }

    public void addXsltFunctionImport(XdmNode lib) {
        this.xsltFunctionImports.add(lib);
    }

    public void setSourceImport(URI href) {
        this.sourceImport = href;
    }

    public URI getSourceImport() {
        return this.sourceImport;
    }

    @Override
    public DeclareStep getDeclaration() {
        return this.getDeclaration(this.declaredType);
    }

    @Override
    public DeclareStep getDeclaration(QName type) {
        DeclareStep decl = null;
        if (this.parentScope != null) {
            try {
                decl = this.parentScope.getDeclaration(type);
            }
            catch (XProcException e) {
                if (XProcConstants.staticError(44).equals((Object)e.getErrorCode())) {
                    throw XProcException.staticError(44, this.node, "Unexpected step name: " + type);
                }
                throw e;
            }
        }
        for (PipelineLibrary lib : this.importedLibs) {
            DeclareStep d = lib.getDeclaration(type);
            if (d == null) continue;
            if (decl == null) {
                decl = d;
                continue;
            }
            if (decl.equals(d)) continue;
            throw new XProcException(d, "Duplicate step type: " + type);
        }
        DeclareStep d = this.declaredSteps.get(type);
        if (d != null) {
            if (decl == null) {
                decl = d;
            } else if (!decl.equals(d)) {
                throw new XProcException(d, "Duplicate step type: " + type);
            }
        }
        return decl;
    }

    @Override
    public Set<QName> getInScopeTypes() {
        HashSet<QName> decls = new HashSet<QName>();
        decls.addAll(this.declaredSteps.keySet());
        if (this.parentScope != null) {
            decls.addAll(this.parentScope.getInScopeTypes());
        }
        for (PipelineLibrary lib : this.importedLibs) {
            decls.addAll(lib.getInScopeTypes());
        }
        return decls;
    }

    public List<XdmNode> getXsltFunctionImports() {
        return this.xsltFunctionImports;
    }

    private void setupEnvironment() {
        this.setEnvironment(new Environment(this));
    }

    @Override
    protected void patchEnvironment(Environment env) {
        if (!this.atomic) {
            int count = 0;
            Input defin = null;
            boolean foundPrimary = false;
            for (Input input : this.inputs) {
                if (input.getPort().startsWith("|") || input.getParameterInput()) continue;
                ++count;
                foundPrimary |= input.getPrimary();
                if (!input.getPrimary() && input.getPrimarySet() || defin != null && !input.getPrimary()) continue;
                defin = input;
            }
            if (count == 1 || foundPrimary) {
                env.setDefaultReadablePort(defin);
            }
        }
    }

    public void setup() {
        if (this.setup) {
            return;
        }
        this.setup = true;
        XProcRuntime runtime = this.runtime;
        DeclareStep decl = this;
        boolean debug = runtime.getDebug();
        if (decl.psviRequired && !runtime.getPSVISupported()) {
            throw XProcException.dynamicError(22);
        }
        if (debug) {
            this.logger.trace("=====================================================================================");
            this.logger.trace("Before augment:");
            decl.dump();
        }
        boolean seenPrimaryDocument = false;
        boolean seenPrimaryParameter = false;
        for (Input input : decl.inputs()) {
            if (input.getPort().startsWith("|") || !input.getPrimary()) continue;
            if (seenPrimaryDocument && !input.getParameterInput()) {
                this.error(XProcException.staticError(30, "At most one primary document input port is allowed"));
            }
            if (seenPrimaryParameter && input.getParameterInput()) {
                this.error(XProcException.staticError(30, "At most one primary parameter input port is allowed"));
            }
            if (input.getParameterInput()) {
                seenPrimaryParameter = true;
                continue;
            }
            seenPrimaryDocument = true;
        }
        boolean seenPrimary = false;
        for (Output output : decl.outputs()) {
            if (output.getPort().endsWith("|") || !output.getPrimary()) continue;
            if (seenPrimary) {
                this.error(XProcException.staticError(30, "At most one primary output port is allowed"));
            }
            seenPrimary = true;
        }
        if (debug) {
            this.logger.trace("After binding pipeline inputs and outputs:");
            decl.dump();
        }
        if (this.subpipeline.size() == 0) {
            this.error(XProcException.staticError(100, "Declared step has no subpipeline, but is not known."));
            return;
        }
        decl.augment();
        if (debug) {
            this.logger.trace("After augment:");
            decl.dump();
        }
        decl.setupEnvironment();
        if (!decl.valid()) {
            if (debug) {
                decl.dump();
            }
            return;
        }
        if (debug) {
            this.logger.trace("After valid:");
            decl.dump();
        }
        if (!decl.orderSteps()) {
            if (debug) {
                decl.dump();
            }
            return;
        }
        if (debug) {
            this.logger.trace("After ordering:");
            decl.dump();
        }
        HashSet<QName> hashSet = new HashSet<QName>();
        this.checkDuplicateVars(hashSet);
        if (!this.checkOutputBindings()) {
            if (debug) {
                decl.dump();
            }
            return;
        }
    }

    protected boolean checkOutputBindings() {
        PipeNameBinding b;
        Output output;
        HashSet<Output> uboutputs = new HashSet<Output>();
        for (Step substep : this.subpipeline) {
            for (Output output2 : substep.outputs()) {
                if (output2.getBinding().size() != 0 || output2.getPort().endsWith("|") || output2.getPort().startsWith("#")) continue;
                uboutputs.add(output2);
            }
        }
        for (Input input : this.inputs()) {
            for (Binding binding : input.bindings) {
                if (binding.getBindingType() != 1 || !uboutputs.contains(output = this.env.readablePort((b = (PipeNameBinding)binding).getStep(), b.getPort()))) continue;
                uboutputs.remove(output);
            }
        }
        for (Option option : this.options()) {
            for (Binding binding : option.bindings) {
                if (binding.getBindingType() != 1 || !uboutputs.contains(output = this.env.readablePort((b = (PipeNameBinding)binding).getStep(), b.getPort()))) continue;
                uboutputs.remove(output);
            }
        }
        for (Parameter param : this.parameters()) {
            for (Binding binding : param.bindings) {
                if (binding.getBindingType() != 1 || !uboutputs.contains(output = this.env.readablePort((b = (PipeNameBinding)binding).getStep(), b.getPort()))) continue;
                uboutputs.remove(output);
            }
        }
        for (Step substep : this.subpipeline) {
            substep.checkForBindings(uboutputs);
        }
        boolean valid = true;
        for (Output output3 : uboutputs) {
            if (!output3.getPrimary()) continue;
            this.error(new XProcException(new QName("", "ERR"), "Unbound primary output: " + output3));
            valid = false;
        }
        return valid;
    }

    @Override
    protected boolean checkBinding(Input input) {
        XProcData data;
        boolean valid = true;
        if (input.getBinding().size() == 0) {
            Step substep;
            Port port = null;
            if ("#xpath-context".equals(input.getPort())) {
                if (this instanceof When) {
                    port = new Port(this.runtime, this.getNode());
                    port.setStep(this.parent);
                    port.setPort("#xpath-context");
                } else {
                    port = this.env.getDefaultReadablePort();
                }
            }
            if ("#iteration-source".equals(input.getPort()) || "#viewport-source".equals(input.getPort())) {
                port = this.env.getParent().getDefaultReadablePort();
            }
            Vector<Binding> declBinding = null;
            if (XProcConstants.p_pipeline.equals((Object)this.getType())) {
                DeclareStep decl = this.declaration;
                for (Input dinput : decl.inputs()) {
                    if (!dinput.getPort().equals(input.getPort())) continue;
                    declBinding = dinput.getBinding();
                }
            }
            if (input.getPrimary() && input.getPort().startsWith("|") && this.subpipeline.size() > 0 && (port = (substep = (Step)this.subpipeline.get(this.subpipeline.size() - 1)).getDefaultOutput()) == null) {
                this.error(XProcException.staticError(5, "Output port '" + input.getPort().substring(1) + "' on " + this.getStep() + " unbound"));
                valid = false;
            }
            EndPoint output = null;
            if (input.getPort().startsWith("|") && this.parent != null) {
                Iterator<Binding> oport = input.getPort().substring(1);
                output = this.getOutput((String)((Object)oport));
            }
            if (output != null && output.getBinding().size() > 0) {
                for (Binding binding : output.getBinding()) {
                    input.addBinding(binding);
                }
                output.clearBindings();
            } else if (port == null) {
                if (declBinding != null) {
                    for (Binding binding : declBinding) {
                        input.addBinding(binding);
                    }
                } else if (input.getParameterInput()) {
                    EmptyBinding empty = new EmptyBinding();
                    input.addBinding(empty);
                }
            } else {
                String stepName = port.getStep().getName();
                String portName = port.getPort();
                PipeNameBinding binding = new PipeNameBinding(this.runtime, this.node);
                binding.setStep(stepName);
                binding.setPort(portName);
                input.addBinding(binding);
            }
        } else if (input.getParameterInput() && (data = this.runtime.getXProcData()).getDepth() == 0 && input.getBinding().size() > 0) {
            throw XProcException.staticError(35, input.getNode(), "You must not specify bindings in this context.");
        }
        for (Binding binding : input.getBinding()) {
            Output output;
            PipeNameBinding pipe;
            Step step;
            if (binding.getBindingType() != 1 || (step = this.env.visibleStep((pipe = (PipeNameBinding)binding).getStep())) instanceof Catch && "error".equals(pipe.getPort()) || step instanceof Choose && "#xpath-context".equals(pipe.getPort()) || (output = this.env.readablePort(pipe.getStep(), pipe.getPort())) != null) continue;
            this.error(new XProcException(XProcException.err_E0001, "Unreadable port: " + pipe.getPort() + " on " + pipe.getStep()));
            valid = false;
        }
        return valid;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.sourceImport == null) {
            return false;
        }
        if (!(o instanceof DeclareStep)) {
            return false;
        }
        DeclareStep that = (DeclareStep)o;
        if (!this.declaredType.equals((Object)that.declaredType)) {
            return false;
        }
        return this.sourceImport.equals(that.sourceImport);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.declaredType.hashCode();
        result = 31 * result + (this.sourceImport == null ? 0 : this.sourceImport.hashCode());
        return result;
    }
}

