/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.S9apiUtils;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import org.xml.sax.InputSource;

@XMLCalabash(name="p:validate-with-schematron", type="{http://www.w3.org/ns/xproc}validate-with-schematron")
public class ValidateWithSCH
extends DefaultStep {
    private static final StructuredQName _untyped = StructuredQName.fromClarkName((String)"{http://www.w3.org/2001/XMLSchema}untyped");
    private static final QName _assert_valid = new QName("", "assert-valid");
    private static final QName _phase = new QName("", "phase");
    private InputStream skeleton = null;
    private ReadablePipe source = null;
    private ReadablePipe schema = null;
    private WritablePipe resultPipe = null;
    private WritablePipe reportPipe = null;
    private Hashtable<QName, RuntimeValue> params = new Hashtable();
    private boolean schemaAware = false;

    public ValidateWithSCH(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.source = pipe;
        } else if ("schema".equals(port)) {
            this.schema = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        if ("result".equals(port)) {
            this.resultPipe = pipe;
        } else if ("report".equals(port)) {
            this.reportPipe = pipe;
        }
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        this.params.put(name, value);
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.schema.resetReader();
        this.resultPipe.resetWriter();
        this.reportPipe.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        XdmNode sourceXML = this.source.read();
        SchemaType type = sourceXML.getUnderlyingNode().getSchemaType();
        this.schemaAware = type != null && !type.getStructuredQName().equals((Object)_untyped);
        XdmNode schemaXML = this.schema.read();
        XdmNode theSchema1_sch = this.transform(schemaXML, this.getSchematronXSLT("iso_dsdl_include.xsl"));
        XdmNode theSchema2_sch = this.transform(theSchema1_sch, this.getSchematronXSLT("iso_abstract_expand.xsl"));
        this.skeleton = this.getClass().getResourceAsStream("/etc/schematron/iso_schematron_skeleton_for_saxon.xsl");
        if (this.skeleton == null) {
            throw new UnsupportedOperationException("Failed to load iso_schematron_skeleton_for_saxon.xsl from JAR file.");
        }
        XsltCompiler compiler = this.runtime.getProcessor().newXsltCompiler();
        compiler.setSchemaAware(this.schemaAware);
        compiler.setURIResolver((URIResolver)new UResolver());
        XsltExecutable exec = compiler.compile((Source)this.getSchematronXSLT("iso_svrl_for_xslt2.xsl"));
        XsltTransformer schemaCompiler = exec.load();
        if (this.getOption(_phase) != null) {
            String phase = this.getOption(_phase).getString();
            schemaCompiler.setParameter(new QName("", "phase"), (XdmValue)new XdmAtomicValue(phase));
        }
        for (QName name : this.params.keySet()) {
            RuntimeValue v = this.params.get(name);
            schemaCompiler.setParameter(name, (XdmValue)new XdmAtomicValue(v.getString()));
        }
        schemaCompiler.setInitialContextNode(theSchema2_sch);
        XdmDestination result = new XdmDestination();
        schemaCompiler.setDestination((Destination)result);
        this.runtime.getConfigurer().getSaxonConfigurer().configSchematron(schemaCompiler.getUnderlyingController().getConfiguration());
        schemaCompiler.transform();
        XdmNode compiledSchema = result.getXdmNode();
        XdmNode compiledRoot = S9apiUtils.getDocumentElement(compiledSchema);
        if (compiledRoot == null) {
            XdmNode schemaRoot = S9apiUtils.getDocumentElement(schemaXML);
            String root = schemaRoot == null ? "null" : schemaRoot.getNodeName().toString();
            throw new XProcException("p:validate-with-schematron failed to compile provided schema: " + root);
        }
        compiler = this.runtime.getProcessor().newXsltCompiler();
        compiler.setSchemaAware(this.schemaAware);
        exec = compiler.compile(compiledSchema.asSource());
        XsltTransformer transformer = exec.load();
        for (QName name : this.params.keySet()) {
            RuntimeValue v = this.params.get(name);
            transformer.setParameter(name, (XdmValue)v.getUntypedAtomic(this.runtime));
        }
        transformer.setInitialContextNode(sourceXML);
        result = new XdmDestination();
        transformer.setDestination((Destination)result);
        transformer.transform();
        XdmNode report = result.getXdmNode();
        this.reportPipe.write(report);
        boolean failedAsserts = this.checkFailedAssert(report);
        if (failedAsserts && this.getOption(_assert_valid, false)) {
            throw XProcException.stepError(54);
        }
        this.resultPipe.write(sourceXML);
    }

    private boolean checkFailedAssert(XdmNode doc) {
        Hashtable<String, String> nsBindings = new Hashtable<String, String>();
        nsBindings.put("svrl", "http://purl.oclc.org/dsdl/svrl");
        String xpath = "//svrl:failed-assert";
        Vector results = new Vector();
        Configuration config = this.runtime.getProcessor().getUnderlyingConfiguration();
        try {
            XPathCompiler xcomp = this.runtime.getProcessor().newXPathCompiler();
            xcomp.setBaseURI(this.step.getNode().getBaseURI());
            for (String prefix : nsBindings.keySet()) {
                xcomp.declareNamespace(prefix, (String)nsBindings.get(prefix));
            }
            XPathExecutable xexec = null;
            xexec = xcomp.compile(xpath);
            XPathSelector selector = xexec.load();
            selector.setContextItem((XdmItem)doc);
            try {
                Iterator values = selector.iterator();
                while (values.hasNext()) {
                    results.add(values.next());
                }
            }
            catch (SaxonApiUncheckedException saue) {
                Throwable sae = saue.getCause();
                if (sae instanceof XPathException) {
                    XPathException xe = (XPathException)sae;
                    if ("http://www.w3.org/2005/xqt-errors".equals(xe.getErrorCodeNamespace()) && "XPDY0002".equals(xe.getErrorCodeLocalPart())) {
                        throw XProcException.dynamicError(26, this.step.getNode(), "Expression refers to context when none is available: " + xpath);
                    }
                    throw saue;
                }
                throw saue;
            }
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
        return results.size() != 0;
    }

    private SAXSource getSchematronXSLT(String xslt) {
        InputStream instream = this.getClass().getResourceAsStream("/etc/schematron/" + xslt);
        if (instream == null) {
            throw new UnsupportedOperationException("Failed to load " + xslt + " from JAR file.");
        }
        return new SAXSource(new InputSource(instream));
    }

    private XdmNode transform(XdmNode source, SAXSource stylesheet) throws SaxonApiException {
        XsltCompiler compiler = this.runtime.getProcessor().newXsltCompiler();
        compiler.setSchemaAware(this.schemaAware);
        compiler.setURIResolver((URIResolver)new UResolver());
        XsltExecutable exec = compiler.compile((Source)stylesheet);
        XsltTransformer schemaCompiler = exec.load();
        schemaCompiler.setInitialContextNode(source);
        XdmDestination result = new XdmDestination();
        schemaCompiler.setDestination((Destination)result);
        schemaCompiler.transform();
        return result.getXdmNode();
    }

    private class UResolver
    implements URIResolver {
        private UResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            if ("iso_schematron_skeleton_for_saxon.xsl".equals(href)) {
                return new SAXSource(new InputSource(ValidateWithSCH.this.skeleton));
            }
            throw new XProcException((XStep)ValidateWithSCH.this.step, "Failed to resolve " + href + " from JAR file.");
        }
    }
}

