/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.util.Map;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

@XMLCalabash(name="p:rename", type="{http://www.w3.org/ns/xproc}rename")
public class Rename
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _match = new QName("", "match");
    private static final QName _new_name = new QName("", "new-name");
    private static final QName _new_prefix = new QName("", "new-prefix");
    private static final QName _new_namespace = new QName("", "new-namespace");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private Map<QName, RuntimeValue> inScopeOptions = null;
    private ProcessMatch matcher = null;
    private QName newName = null;

    public Rename(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue nameValue = this.getOption(_new_name);
        String nameStr = nameValue.getString();
        String npfx = this.getOption(_new_prefix, (String)null);
        String nns = this.getOption(_new_namespace, (String)null);
        if (npfx != null && nns == null) {
            throw XProcException.dynamicError(34, this.step, "You can't specify a prefix without a namespace");
        }
        if (nns != null && nameStr.contains(":")) {
            throw XProcException.dynamicError(34, this.step, "You can't specify a namespace if the new-name contains a colon");
        }
        this.newName = nameStr.contains(":") ? new QName(nameStr, nameValue.getNode()) : new QName(npfx == null ? "" : npfx, nns, nameStr);
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), this.getOption(_match));
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6, "Reading source on " + this.getStep().getName());
        }
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) throws SaxonApiException {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) throws SaxonApiException {
    }

    @Override
    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        this.matcher.addStartElement(node, this.newName);
        this.matcher.addAttributes(node);
        return true;
    }

    @Override
    public void processEndElement(XdmNode node) throws SaxonApiException {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processComment(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processPI(XdmNode node) throws SaxonApiException {
        if (!"".equals(this.newName.getNamespaceURI())) {
            throw XProcException.stepError(13);
        }
        this.matcher.addPI(this.newName.getLocalName(), node.getStringValue());
    }

    @Override
    public void processAttribute(XdmNode node) throws SaxonApiException {
        this.matcher.addAttribute(this.newName, node.getStringValue());
    }
}

