/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadableDocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.MessageFormatter;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyPipe
implements ReadablePipe {
    protected final Logger logger = LoggerFactory.getLogger(Pipe.class);
    private static int idCounter = 0;
    private final int id;
    private final XProcRuntime runtime;
    private final ReadableDocumentSequence documents;
    protected int pos = 0;
    private boolean readSeqOk = false;
    private Step reader = null;
    private String stepName = null;
    private String portName = null;

    public ReadOnlyPipe(XProcRuntime runtime, ReadableDocumentSequence seq) {
        this.runtime = runtime;
        this.documents = seq;
        this.id = ++idCounter;
    }

    @Override
    public void canReadSequence(boolean sequence) {
        this.readSeqOk = sequence;
    }

    @Override
    public boolean readSequence() {
        return this.readSeqOk;
    }

    @Override
    public XdmNode read() throws SaxonApiException {
        if (this.pos > 0 && !this.readSeqOk) {
            this.dynamicError(6);
        }
        XdmNode doc = this.documents.get(this.pos++);
        if (this.reader != null) {
            this.logger.trace(MessageFormatter.nodeMessage(this.reader.getNode(), this.reader.getName() + " read '" + (doc == null ? "null" : doc.getBaseURI()) + "' from " + this));
        }
        return doc;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public void setNames(String stepName, String portName) {
        this.stepName = stepName;
        this.portName = portName;
    }

    @Override
    public void resetReader() {
        this.pos = 0;
    }

    @Override
    public boolean moreDocuments() throws SaxonApiException {
        return this.pos < this.documents.size();
    }

    @Override
    public int documentCount() throws SaxonApiException {
        return this.documents.size();
    }

    @Override
    public ReadableDocumentSequence documents() {
        return this.documents;
    }

    public String toString() {
        return "[pipe #" + this.id + "] (" + this.documents + ")";
    }

    protected void dynamicError(int errno) {
        String msg = null;
        if (this.stepName != null) {
            msg = "Reading " + this.portName + " on " + this.stepName;
        }
        throw XProcException.dynamicError(errno, this.reader, msg);
    }
}

