/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

@XMLCalabash(name="pxf:mkdir", type="{http://exproc.org/proposed/steps/file}mkdir {http://xmlcalabash.com/ns/extensions/fileutils}mkdir")
public class Mkdir
extends DefaultStep {
    private static final QName _href = new QName("href");
    private WritablePipe result = null;

    public Mkdir(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        RuntimeValue href = this.getOption(_href);
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_result);
        tree.startContent();
        try {
            DataStore store = this.runtime.getDataStore();
            URI uri = store.createList(href.getString(), href.getBaseURI().toASCIIString());
            tree.addText(uri.toASCIIString());
        }
        catch (FileNotFoundException e) {
            throw new XProcException((XStep)this.step, "Cannot mkdir: file exists: " + href.getString());
        }
        catch (IOException e) {
            throw new XProcException((XStep)this.step, "Mkdir failed for: " + href.getString());
        }
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

