/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.AxisNodes;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XMLtoJSON;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;

@XMLCalabash(name="pxp:zip", type="{http://exproc.org/proposed/steps}zip {http://xmlcalabash.com/ns/extensions}zip")
public class Zip
extends DefaultStep {
    protected static final QName _href = new QName("", "href");
    protected static final QName _name = new QName("", "name");
    protected static final QName _command = new QName("", "command");
    protected static final QName _compression_method = new QName("", "compression-method");
    protected static final QName _compression_level = new QName("", "compression-level");
    protected static final QName c_zip_manifest = new QName("c", "http://www.w3.org/ns/xproc-step", "zip-manifest");
    protected static final QName c_zipfile = new QName("c", "http://www.w3.org/ns/xproc-step", "zipfile");
    protected static final QName c_entry = new QName("c", "http://www.w3.org/ns/xproc-step", "entry");
    protected static final QName c_file = new QName("c", "http://www.w3.org/ns/xproc-step", "file");
    protected static final QName c_directory = new QName("c", "http://www.w3.org/ns/xproc-step", "directory");
    protected static final QName _compressed_size = new QName("", "compressed-size");
    protected static final QName _comment = new QName("", "comment");
    protected static final QName _size = new QName("", "size");
    protected static final QName _date = new QName("", "date");
    private static final QName _status_only = new QName("status-only");
    private static final QName _detailed = new QName("detailed");
    private static final QName _status = new QName("status");
    private static final QName _value = new QName("value");
    private static final QName c_encoding = new QName("c", "http://www.w3.org/ns/xproc-step", "encoding");
    private static final QName c_body = new QName("c", "http://www.w3.org/ns/xproc-step", "body");
    private static final QName c_json = new QName("c", "http://www.w3.org/ns/xproc-step", "json");
    private static final QName _content_type = new QName("content-type");
    private static final int bufsize = 8192;
    private static final QName[] serializerAttrs = new QName[]{_byte_order_mark, _cdata_section_elements, _doctype_public, _doctype_system, _encoding, _escape_uri_attributes, _include_content_type, _indent, _media_type, _method, _normalization_form, _omit_xml_declaration, _standalone, _undeclare_prefixes, _version};
    private ReadablePipe source = null;
    private ReadablePipe manifest = null;
    private WritablePipe result = null;
    private Map<String, FileToZip> zipManifest = new LinkedHashMap<String, FileToZip>();
    private Map<String, XdmNode> srcManifest = new LinkedHashMap<String, XdmNode>();

    public Zip(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.source = pipe;
        } else {
            this.manifest = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.manifest.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        DataStore store;
        super.run();
        final String zipFn = this.getOption(_href).getString();
        XdmNode man = S9apiUtils.getDocumentElement(this.manifest.read());
        if (man == null) {
            throw new NullPointerException("XML document " + man.getDocumentURI() + " has no root element.");
        }
        if (!c_zip_manifest.equals((Object)man.getNodeName())) {
            throw new XProcException((XStep)this.step, "The cx:zip manifest must be a c:zip-manifest.");
        }
        while (this.source.moreDocuments()) {
            XdmNode doc = this.source.read();
            XdmNode root = S9apiUtils.getDocumentElement(doc);
            if (root == null) {
                throw new NullPointerException("XML document " + doc.getDocumentURI() + " has no root element.");
            }
            this.srcManifest.put(root.getBaseURI().toASCIIString(), doc);
        }
        this.parseManifest(man);
        try {
            final String base = this.getOption(_href).getBaseURI().toASCIIString();
            store = this.runtime.getDataStore();
            store.writeEntry(zipFn, base, "application/zip", new DataStore.DataWriter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void store(OutputStream content) throws IOException {
                    try (final ZipOutputStream outZip = new ZipOutputStream(content);){
                        store.readEntry(zipFn, base, "application/zip", null, new DataStore.DataReader(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void load(URI id, String media, InputStream content, long len) throws IOException {
                                try (ZipInputStream inZip = new ZipInputStream(content);){
                                    Zip.this.update(inZip, outZip);
                                }
                            }
                        });
                    }
                }
            });
        }
        catch (IOException e) {
            throw new XProcException(e);
        }
        try {
            final DatatypeFactory dfactory = DatatypeFactory.newInstance();
            store = this.runtime.getDataStore();
            store.readEntry(zipFn, zipFn, "application/zip, */*", null, new DataStore.DataReader(){

                @Override
                public void load(URI id, String media, InputStream stream, long len) throws IOException {
                    TreeWriter tree = new TreeWriter(Zip.this.runtime);
                    tree.startDocument(Zip.this.step.getNode().getBaseURI());
                    tree.addStartElement(c_zipfile);
                    tree.addAttribute(_href, id.toASCIIString());
                    tree.startContent();
                    if (zipFn.startsWith("file:/")) {
                        Zip.this.readFile(tree, id, zipFn, dfactory);
                    } else {
                        Zip.this.readStream(tree, id, stream, dfactory);
                    }
                    tree.addEndElement();
                    tree.endDocument();
                    Zip.this.result.write(tree.getResult());
                }
            });
        }
        catch (MalformedURLException mue) {
            throw new XProcException(XProcException.err_E0001, (Throwable)mue);
        }
        catch (IOException ioe) {
            throw new XProcException(XProcException.err_E0001, (Throwable)ioe);
        }
        catch (DatatypeConfigurationException dce) {
            throw new XProcException(XProcException.err_E0001, (Throwable)dce);
        }
    }

    private void update(ZipInputStream inZip, ZipOutputStream outZip) {
        String command = this.getOption(_command).getString();
        if ("create".equals(command)) {
            try {
                if (inZip != null) {
                    inZip.close();
                }
            }
            catch (IOException ioe) {
                throw new XProcException(ioe);
            }
            inZip = null;
        }
        if ("update".equals(command) || "create".equals(command)) {
            this.update(inZip, outZip, false);
        } else if ("freshen".equals(command)) {
            this.update(inZip, outZip, true);
        } else if ("delete".equals(command)) {
            this.delete(inZip, outZip);
        } else {
            throw new XProcException((XStep)this.step, "Unexpected cx:zip command: " + command);
        }
    }

    private void readFile(TreeWriter tree, URI id, String zipFn, DatatypeFactory dfactory) throws IOException {
        try (ZipFile zipFile = null;){
            File uriFile = new File(new URI(zipFn));
            zipFile = new ZipFile(uriFile);
            Enumeration<? extends ZipEntry> zipEntryEnum = zipFile.entries();
            while (zipEntryEnum.hasMoreElements()) {
                ZipEntry entry = zipEntryEnum.nextElement();
                this.processEntry(tree, entry, dfactory);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStream(TreeWriter tree, URI id, InputStream stream, DatatypeFactory dfactory) throws IOException {
        try (ZipInputStream zipStream = new ZipInputStream(stream);){
            ZipEntry entry = zipStream.getNextEntry();
            while (entry != null) {
                this.processEntry(tree, entry, dfactory);
            }
        }
    }

    private void processEntry(TreeWriter tree, ZipEntry entry, DatatypeFactory dfactory) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(entry.getTime());
        XMLGregorianCalendar xmlCal = dfactory.newXMLGregorianCalendar(cal);
        if (entry.isDirectory()) {
            tree.addStartElement(c_directory);
        } else {
            tree.addStartElement(c_file);
            tree.addAttribute(_compressed_size, "" + entry.getCompressedSize());
            tree.addAttribute(_size, "" + entry.getSize());
        }
        if (entry.getComment() != null) {
            tree.addAttribute(_comment, entry.getComment());
        }
        tree.addAttribute(_name, "" + entry.getName());
        tree.addAttribute(_date, xmlCal.toXMLFormat());
        tree.startContent();
        tree.addEndElement();
    }

    private void parseManifest(XdmNode man) {
        for (XdmNode child : new AxisNodes(man, Axis.CHILD, 7)) {
            if (XdmNodeKind.ELEMENT == child.getNodeKind()) {
                if (c_entry.equals((Object)child.getNodeName())) {
                    String name = child.getAttributeValue(_name);
                    if (name == null || "".equals(name)) {
                        throw new XProcException((XStep)this.step, "Missing or invalid name in cx:zip manifest.");
                    }
                    String href = child.getAttributeValue(_href);
                    if (href == null || "".equals(href)) {
                        throw new XProcException((XStep)this.step, "Missing or invalid href in cx:zip manifest.");
                    }
                    String hrefuri = child.getBaseURI().resolve(href).toASCIIString();
                    String comment = child.getAttributeValue(_comment);
                    int method = 8;
                    int level = -1;
                    String value = child.getAttributeValue(_compression_method);
                    if ("stored".equals(value)) {
                        method = 0;
                    }
                    if ("smallest".equals(value = child.getAttributeValue(_compression_level))) {
                        level = 9;
                    } else if ("fastest".equals(value)) {
                        level = 1;
                    } else if ("huffman".equals(value)) {
                        level = 2;
                    } else if ("none".equals(value)) {
                        level = 0;
                        method = 0;
                    }
                    this.zipManifest.put(name, new FileToZip(name, hrefuri, method, level, comment, child));
                    continue;
                }
                throw new XProcException((XStep)this.step, "Unexpected element in cx:zip manifest: " + child.getNodeName());
            }
            throw new XProcException((XStep)this.step, "Unexpected content in cx:zip manifest.");
        }
    }

    public void update(ZipInputStream inZip, final ZipOutputStream outZip, boolean freshen) {
        final byte[] buffer = new byte[8192];
        try {
            FileToZip file;
            if (inZip != null) {
                ZipEntry entry;
                while ((entry = inZip.getNextEntry()) != null) {
                    String name = entry.getName();
                    boolean skip = this.srcManifest.containsKey(name);
                    if (!skip) {
                        if (this.zipManifest.containsKey(name) && freshen) {
                            file = this.zipManifest.get(name);
                            long zipDate = entry.getTime();
                            long lastMod = file.getLastModified();
                            boolean bl = skip = lastMod > zipDate;
                            if (!skip) {
                                this.zipManifest.remove(name);
                            }
                        } else if (this.zipManifest.containsKey(name)) {
                            skip = true;
                        }
                    }
                    if (skip) continue;
                    ZipEntry copy = new ZipEntry(entry);
                    copy.setCompressedSize(-1L);
                    outZip.putNextEntry(copy);
                    int read = inZip.read(buffer, 0, 8192);
                    while (read >= 0) {
                        outZip.write(buffer, 0, read);
                        read = inZip.read(buffer, 0, 8192);
                    }
                    outZip.closeEntry();
                }
            }
            CRC32 crc = new CRC32();
            for (String name : this.zipManifest.keySet()) {
                file = this.zipManifest.get(name);
                ZipEntry ze = new ZipEntry(name);
                if (file.getComment() != null) {
                    ze.setComment(file.getComment());
                }
                ze.setMethod(file.getMethod());
                outZip.setLevel(file.getLevel());
                URI uri = this.zipManifest.get(name).getHref();
                String href = uri.toASCIIString();
                if (ze.getMethod() == 0) {
                    final ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (this.srcManifest.containsKey(uri.toString())) {
                        XdmNode doc = this.srcManifest.get(href);
                        this.store(file, doc, baos);
                    } else {
                        DataStore store = this.runtime.getDataStore();
                        store.readEntry(href, href, "*/*", null, new DataStore.DataReader(){

                            @Override
                            public void load(URI id, String media, InputStream stream, long len) throws IOException {
                                int read = stream.read(buffer, 0, 8192);
                                while (read > 0) {
                                    baos.write(buffer, 0, read);
                                    read = stream.read(buffer, 0, 8192);
                                }
                            }
                        });
                    }
                    byte[] bytes = baos.toByteArray();
                    ze.setSize(bytes.length);
                    crc.reset();
                    crc.update(bytes);
                    ze.setCrc(crc.getValue());
                }
                outZip.putNextEntry(ze);
                if (this.srcManifest.containsKey(href)) {
                    XdmNode doc = this.srcManifest.get(href);
                    this.store(file, doc, outZip);
                } else {
                    DataStore store = this.runtime.getDataStore();
                    store.readEntry(href, href, "*/*", null, new DataStore.DataReader(){

                        @Override
                        public void load(URI id, String media, InputStream stream, long len) throws IOException {
                            int read = stream.read(buffer, 0, 8192);
                            while (read >= 0) {
                                outZip.write(buffer, 0, read);
                                read = stream.read(buffer, 0, 8192);
                            }
                        }
                    });
                }
                outZip.closeEntry();
            }
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
    }

    public void delete(ZipInputStream inZip, ZipOutputStream outZip) {
        try {
            if (inZip != null) {
                ZipEntry entry;
                while ((entry = inZip.getNextEntry()) != null) {
                    String name = entry.getName();
                    boolean delete = false;
                    if (this.zipManifest.containsKey(name)) {
                        delete = true;
                    }
                    if (delete) continue;
                    outZip.putNextEntry(entry);
                    byte[] buffer = new byte[8192];
                    int read = inZip.read(buffer, 0, 8192);
                    while (read >= 0) {
                        outZip.write(buffer, 0, read);
                        read = inZip.read(buffer, 0, 8192);
                    }
                    outZip.closeEntry();
                }
            }
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
    }

    protected void store(FileToZip file, XdmNode doc, OutputStream out) throws SaxonApiException, IOException {
        XdmNode root = S9apiUtils.getDocumentElement(doc);
        if ("http://www.w3.org/ns/xproc-step".equals(root.getNodeName().getNamespaceURI()) && "base64".equals(root.getAttributeValue(_encoding)) || "".equals(root.getNodeName().getNamespaceURI()) && "base64".equals(root.getAttributeValue(c_encoding))) {
            this.storeBinary(file, doc, out);
        } else if (XProcConstants.c_result.equals((Object)root.getNodeName()) && root.getAttributeValue(_content_type) != null && root.getAttributeValue(_content_type).startsWith("text/")) {
            this.storeText(file, doc, out);
        } else if (this.runtime.transparentJSON() && (c_body.equals((Object)root.getNodeName()) && ("application/json".equals(root.getAttributeValue(_content_type)) || "text/json".equals(root.getAttributeValue(_content_type))) || c_json.equals((Object)root.getNodeName()) || "http://www.ibm.com/xmlns/prod/2009/jsonx".equals(root.getNodeName().getNamespaceURI()) || "http://www.xmlsh.org/jxml".equals(root.getNodeName().getNamespaceURI()) || "http://marklogic.com/json".equals(root.getNodeName().getNamespaceURI()))) {
            this.storeJSON(file, doc, out);
        } else {
            this.storeXML(file, doc, out);
        }
    }

    public void storeBinary(FileToZip file, XdmNode doc, OutputStream out) throws IOException {
        byte[] decoded = Base64.decode(doc.getStringValue());
        out.write(decoded);
    }

    public void storeText(FileToZip file, XdmNode doc, OutputStream out) throws IOException {
        out.write(doc.getStringValue().getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJSON(FileToZip file, XdmNode doc, OutputStream out) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter(out, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            String json = XMLtoJSON.convert(doc);
            writer.print(json);
        }
        finally {
            writer.close();
        }
    }

    public void storeXML(FileToZip file, XdmNode doc, OutputStream out) throws SaxonApiException {
        Serializer serializer = this.makeSerializer(file.getOptions());
        serializer.setOutputStream(out);
        S9apiUtils.serialize(this.runtime, doc, serializer);
    }

    public Serializer makeSerializer(Hashtable<QName, String> options) {
        String list;
        Serializer serializer = this.runtime.getProcessor().newSerializer();
        if (options == null) {
            return serializer;
        }
        if (options.containsKey(_byte_order_mark)) {
            serializer.setOutputProperty(Serializer.Property.BYTE_ORDER_MARK, "false".equals(options.get(_byte_order_mark)) ? "yes" : "no");
        }
        if (options.containsKey(_cdata_section_elements) && !"".equals(list = options.get(_cdata_section_elements))) {
            String[] names = list.split("\\s+");
            list = "";
            for (String name : names) {
                QName q = new QName(name, this.step.getNode());
                list = list + q.getClarkName() + " ";
            }
            serializer.setOutputProperty(Serializer.Property.CDATA_SECTION_ELEMENTS, list);
        }
        if (options.containsKey(_doctype_public)) {
            serializer.setOutputProperty(Serializer.Property.DOCTYPE_PUBLIC, options.get(_doctype_public));
        }
        if (options.containsKey(_doctype_system)) {
            serializer.setOutputProperty(Serializer.Property.DOCTYPE_SYSTEM, options.get(_doctype_system));
        }
        if (options.containsKey(_encoding)) {
            serializer.setOutputProperty(Serializer.Property.ENCODING, options.get(_encoding));
        }
        if (options.containsKey(_escape_uri_attributes)) {
            serializer.setOutputProperty(Serializer.Property.ESCAPE_URI_ATTRIBUTES, "true".equals(options.get(_escape_uri_attributes)) ? "yes" : "no");
        }
        if (options.containsKey(_include_content_type)) {
            serializer.setOutputProperty(Serializer.Property.INCLUDE_CONTENT_TYPE, "true".equals(options.get(_include_content_type)) ? "yes" : "no");
        }
        if (options.containsKey(_indent)) {
            serializer.setOutputProperty(Serializer.Property.INDENT, "true".equals(options.get(_indent)) ? "yes" : "no");
        }
        if (options.containsKey(_media_type)) {
            serializer.setOutputProperty(Serializer.Property.MEDIA_TYPE, options.get(_media_type));
        }
        if (options.containsKey(_method)) {
            serializer.setOutputProperty(Serializer.Property.METHOD, options.get(_method));
        }
        if (options.containsKey(_normalization_form)) {
            serializer.setOutputProperty(Serializer.Property.NORMALIZATION_FORM, options.get(_normalization_form));
        }
        if (options.containsKey(_omit_xml_declaration)) {
            serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "true".equals(options.get(_omit_xml_declaration)) ? "yes" : "no");
        }
        if (options.containsKey(_standalone)) {
            String standalone = options.get(_standalone);
            if ("true".equals(standalone)) {
                serializer.setOutputProperty(Serializer.Property.STANDALONE, "yes");
            } else if ("false".equals(standalone)) {
                serializer.setOutputProperty(Serializer.Property.STANDALONE, "no");
            }
        }
        if (options.containsKey(_undeclare_prefixes)) {
            serializer.setOutputProperty(Serializer.Property.UNDECLARE_PREFIXES, "true".equals(options.get(_undeclare_prefixes)) ? "yes" : "no");
        }
        if (options.containsKey(_version)) {
            serializer.setOutputProperty(Serializer.Property.VERSION, options.get(_version));
        }
        return serializer;
    }

    private class FileToZip {
        private String zipName = null;
        private URI href = null;
        private String origHref = null;
        private int method = -1;
        private int level = -1;
        private String comment = null;
        private long lastModified = -1L;
        private Hashtable<QName, String> options = null;

        public FileToZip(String zipName, String href, int method, int level, String comment, XdmNode entry) {
            try {
                this.origHref = href;
                this.zipName = zipName;
                this.href = new URI(href);
                this.method = method;
                this.level = level;
                this.comment = comment;
                this.lastModified = this.readLastModified(this.href);
                for (QName attr : serializerAttrs) {
                    String value = entry.getAttributeValue(attr);
                    if (value == null) continue;
                    if (this.options == null) {
                        this.options = new Hashtable();
                    }
                    this.options.put(attr, value);
                }
            }
            catch (URISyntaxException use) {
                throw new XProcException(use);
            }
        }

        public String getName() {
            return this.zipName;
        }

        public URI getHref() {
            return this.href;
        }

        public int getMethod() {
            return this.method;
        }

        public int getLevel() {
            return this.level;
        }

        public String getComment() {
            return this.comment;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public Hashtable<QName, String> getOptions() {
            return this.options;
        }

        private long readLastModified(URI uri) {
            if (Zip.this.srcManifest.containsKey(this.origHref)) {
                Date date = new Date();
                return date.getTime();
            }
            final ArrayList list = new ArrayList(1);
            DataStore store = Zip.this.runtime.getDataStore();
            try {
                store.infoEntry(uri.toASCIIString(), uri.toASCIIString(), "*/*", new DataStore.DataInfo(){

                    @Override
                    public void list(URI id, String media, long lastModified) throws IOException {
                        list.add(lastModified);
                    }
                });
            }
            catch (IOException e) {
                throw new XProcException(e);
            }
            if (list.size() == 1) {
                return (Long)list.get(0);
            }
            return -1L;
        }
    }
}

