/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.MessageFormatter;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

@XMLCalabash(name="cx:message", type="{http://xmlcalabash.com/ns/extensions}message")
public class Message
extends DefaultStep {
    private static final QName _message = new QName("", "message");
    private static final QName _log = new QName("", "log");
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public Message(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String message = this.getOption(_message).getString();
        RuntimeValue loglevel = this.getOption(_log);
        if (loglevel == null) {
            System.err.println("Message: " + message);
        } else {
            String level = loglevel.getString();
            if ("error".equals(level)) {
                this.logger.error(message);
            } else if ("warn".equals(level)) {
                this.logger.warn(message);
            } else if ("info".equals(level)) {
                this.logger.info(message);
            } else if ("debug".equals(level)) {
                this.logger.debug(message);
            } else if ("trace".equals(level)) {
                this.logger.trace(message);
            } else {
                this.logger.warn("Unrecognized cx:message log level: " + level);
                this.logger.warn(message);
            }
        }
        while (this.source.moreDocuments()) {
            XdmNode doc = this.source.read();
            this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "Message step " + this.step.getName() + " read " + doc.getDocumentURI()));
            this.result.write(doc);
        }
    }
}

