/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.core;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.URIUtils;
import java.util.ArrayList;
import java.util.Objects;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMLocator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trace.ContextStackFrame;
import net.sf.saxon.trace.ContextStackIterator;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.AttributeLocation;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.ValidationException;

public class XProcException
extends RuntimeException {
    public static final QName err_E0001 = new QName("http://xproc.org/ns/errors", "XE0001");
    public static final QName err_E0002 = new QName("http://xproc.org/ns/errors", "XE0002");
    private static final String NS_DAISY_PIPELINE_XPROC = "http://www.daisy.org/ns/pipeline/xproc";
    private static final QName c_error = new QName("c", "http://www.w3.org/ns/xproc-step", "error");
    private static final QName _href = new QName("", "href");
    private static final QName _line = new QName("", "line");
    private static final QName _column = new QName("", "column");
    private static final QName _code = new QName("", "code");
    private static final QName _type = new QName("", "type");
    private static final QName _name = new QName("", "name");
    private static final QName px_cause = new QName("px", "http://www.daisy.org/ns/pipeline/xproc", "cause");
    private static final QName px_location = new QName("px", "http://www.daisy.org/ns/pipeline/xproc", "location");
    private static final QName px_file = new QName("px", "http://www.daisy.org/ns/pipeline/xproc", "file");
    private final QName errorCode;
    private final XdmNode errorContent;
    private final XProcException errorCause;
    private final SourceLocator[] location;
    private static final SourceLocator NO_LOCATOR = new SourceLocator(){

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public int getLineNumber() {
            return -1;
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }
    };
    private static final SourceLocator[] NO_LOCATION = new SourceLocator[]{NO_LOCATOR};

    protected XProcException(QName code, Object location, Object message, XProcException cause) {
        super(message instanceof String ? (String)message : (message instanceof XdmNode ? ((XdmNode)message).getStringValue() : (message instanceof Throwable ? ((Throwable)message).getMessage() : null)), message instanceof Throwable ? (Throwable)message : null);
        this.errorCode = code;
        if (!(message == null || message instanceof String || message instanceof XdmNode || message instanceof Throwable)) {
            throw new IllegalStateException("coding error");
        }
        this.errorContent = message instanceof XdmNode ? (XdmNode)message : (message instanceof XProcException ? ((XProcException)message).getErrorContent() : null);
        this.location = XProcException.getLocation(location);
        this.errorCause = cause;
    }

    public static XProcException staticError(int code) {
        return new StaticXProcError(code, null, null);
    }

    public static XProcException staticError(int code, String message) {
        return new StaticXProcError(code, null, (Object)message);
    }

    public static XProcException staticError(int code, XdmNode location, String message) {
        return new StaticXProcError(code, (Object)location, (Object)message);
    }

    public static XProcException staticError(int code, XdmNode location, Throwable message) {
        return new StaticXProcError(code, (Object)location, (Object)message);
    }

    public static XProcException dynamicError(int code) {
        return new DynamicXProcError(code, null, null, null);
    }

    public static XProcException dynamicError(int code, String message) {
        return new DynamicXProcError(code, null, message, null);
    }

    public static XProcException dynamicError(int code, Throwable message) {
        return new DynamicXProcError(code, null, message, null);
    }

    public static XProcException dynamicError(int code, XdmNode location, String message) {
        return new DynamicXProcError(code, location, message, null);
    }

    public static XProcException dynamicError(int code, XdmNode location, Throwable message) {
        return new DynamicXProcError(code, location, message, null);
    }

    public static XProcException dynamicError(int code, Step location) {
        return new DynamicXProcError(code, location, null, null);
    }

    public static XProcException dynamicError(int code, Step location, String message) {
        return new DynamicXProcError(code, location, message, null);
    }

    public static XProcException dynamicError(int code, XStep location, String message) {
        return new DynamicXProcError(code, location, message, null);
    }

    public static XProcException stepError(int code) {
        return new DynamicXProcError(XProcConstants.stepError(code), null, null, null);
    }

    public static XProcException stepError(int code, String message) {
        return new DynamicXProcError(XProcConstants.stepError(code), null, message, null);
    }

    public static XProcException stepError(int code, Throwable message) {
        return new DynamicXProcError(XProcConstants.stepError(code), null, message, null);
    }

    public static XProcException stepError(int code, XdmNode location, String message) {
        return new DynamicXProcError(XProcConstants.stepError(code), location, message, null);
    }

    public static XProcException stepError(int code, XStep location) {
        return new DynamicXProcError(XProcConstants.stepError(code), location, null, null);
    }

    public static XProcException stepError(int code, XStep location, Throwable message) {
        return new DynamicXProcError(XProcConstants.stepError(code), location, message, null);
    }

    public XProcException(QName code, XdmNode location, String message) {
        this(code, location, (Object)message, null);
    }

    public XProcException(QName code, XStep location, String message) {
        this(code, location, message, null);
    }

    public XProcException(QName code, XStep location, XdmNode message) {
        this(code, (Object)location, (Object)message, null);
    }

    public XProcException(QName code, XStep location, Throwable message) {
        this(code, location, message, null);
    }

    public XProcException(QName code, TransformerException location, XdmNode message) {
        this(code, location, message, null);
    }

    public XProcException(QName code, TransformerException location, Throwable message) {
        this(code, location, message, null);
    }

    public XProcException(QName code, TransformerException location, XdmNode message, XProcException cause) {
        this(code, (Object)location, (Object)message, cause);
    }

    public XProcException(QName code, TransformerException location, Throwable message, XProcException cause) {
        this(code, (Object)location, (Object)message, cause);
    }

    public XProcException(QName code, XStep location, String message, XProcException cause) {
        this(code, (Object)location, (Object)message, cause);
    }

    public XProcException(QName code, XStep location, Throwable message, XProcException cause) {
        this(code, (Object)location, (Object)message, cause);
    }

    public XProcException(QName code, String message) {
        this(code, null, message, null);
    }

    public XProcException(QName code, Throwable message) {
        this(code, null, (Object)message, null);
    }

    public XProcException(String message) {
        this(null, null, message, null);
    }

    public XProcException(Throwable message) {
        this(null, null, (Object)message, null);
    }

    public XProcException(Throwable message, XProcException cause) {
        this(null, null, (Object)message, cause);
    }

    public XProcException(SourceLocator[] location, Throwable message) {
        this(null, location, (Object)message, null);
    }

    public XProcException(XdmNode location, String message) {
        this(null, location, (Object)message, null);
    }

    public XProcException(XdmNode location, Throwable message) {
        this(null, location, (Object)message, null);
    }

    public XProcException(Step location, String message) {
        this(null, location, (Object)message, null);
    }

    public XProcException(XStep location, String message) {
        this(null, location, message, null);
    }

    public XProcException(XStep location, Throwable message) {
        this(null, location, message, null);
    }

    public XProcException(XStep location, String message, XProcException cause) {
        this(null, location, message, cause);
    }

    public XProcException(XStep location, Throwable message, XProcException cause) {
        this(null, location, message, cause);
    }

    public XProcException(TransformerException location, XdmNode message) {
        this(null, location, message, null);
    }

    public XProcException(TransformerException location, Throwable message) {
        this(null, location, message, null);
    }

    public XProcException(TransformerException location, XdmNode message, XProcException cause) {
        this(null, location, message, cause);
    }

    public XProcException(TransformerException location, Throwable message, XProcException cause) {
        this(null, location, message, cause);
    }

    public static XProcException fromException(Throwable throwable) {
        XProcException cause = throwable.getCause() != null ? XProcException.fromException(throwable.getCause()) : null;
        return new XProcException(null, (Object)throwable, (Object)throwable, cause);
    }

    public XProcException copy() {
        return new XProcException(this.errorCode, this.location, (Object)this, this.errorCause);
    }

    public XProcException rebase(SourceLocator[] base) {
        return this.rebase(base, null);
    }

    public XProcException rebase(XStep base) {
        return this.rebase(base, null);
    }

    public XProcException rebase(TransformerException base) {
        return this.rebase(base, null);
    }

    public XProcException rebase(SourceLocator[] newBase, StackTraceElement[] oldBase) {
        return this.rebase((Object)newBase, (Object)oldBase);
    }

    private XProcException rebase(Object newBaseObject, Object oldBaseObject) {
        SourceLocator[] newLocation;
        SourceLocator[] newBase = XProcException.getLocation(newBaseObject);
        SourceLocator[] oldBase = XProcException.getLocation(oldBaseObject);
        int newLength = 0;
        if (this.location != NO_LOCATION) {
            if (oldBase != NO_LOCATION) {
                int n;
                int m = this.location.length - 1;
                for (n = oldBase.length - 1; m >= 0 && n >= 0 && Objects.equals(this.location[m].getSystemId(), oldBase[n].getSystemId()) && Objects.equals(this.location[m].getLineNumber(), oldBase[n].getLineNumber()) && Objects.equals(this.location[m].getColumnNumber(), oldBase[n].getColumnNumber()); --m, --n) {
                }
                if (m >= 0 && n >= 0 && this.location[m] instanceof JavaFrame && oldBase[n] instanceof JavaFrame) {
                    StackTraceElement frame = ((JavaFrame)this.location[m]).frame;
                    StackTraceElement oldFrame = ((JavaFrame)oldBase[n]).frame;
                    if (frame.getClassName().equals(oldFrame.getClassName()) && Objects.equals(frame.getMethodName(), oldFrame.getMethodName()) && Objects.equals(frame.getFileName(), oldFrame.getFileName())) {
                        --m;
                        --n;
                    }
                }
                newLength = n < 0 ? (newLength += m + 2) : (newLength += this.location.length);
            } else {
                newLength += this.location.length;
            }
        }
        if (newBase != NO_LOCATION) {
            newLength += newBase.length;
        }
        if (newLength == 0) {
            newLocation = NO_LOCATION;
        } else {
            newLocation = new SourceLocator[newLength];
            int i = 0;
            if (newBase != NO_LOCATION) {
                newLength -= newBase.length;
            }
            while (i < newLength) {
                newLocation[i] = this.location[i];
                ++i;
            }
            if (newBase != NO_LOCATION) {
                for (SourceLocator l : newBase) {
                    newLocation[i++] = l;
                }
            }
        }
        XProcException newErrorCause = this.errorCause != null ? this.errorCause.rebase((Object)newBase, oldBase) : null;
        return new XProcException(this.errorCode, newLocation, (Object)this, newErrorCause);
    }

    public QName getErrorCode() {
        return this.errorCode;
    }

    public XdmNode getErrorContent() {
        return this.errorContent;
    }

    public XProcException getErrorCause() {
        return this.errorCause;
    }

    public SourceLocator[] getLocation() {
        return this.location;
    }

    public static SourceLocator prettyLocator(SourceLocator locator, final String instructionName) {
        return new SourceLocatorWithInstructionName(locator){

            @Override
            protected String getInstructionName() {
                return instructionName;
            }
        };
    }

    public static SourceLocator prettyLocator(final String systemId, final int lineNumber, final int columnNumber, final String instructionName) {
        return new SourceLocatorWithInstructionName(new SourceLocator(){

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return systemId;
            }

            @Override
            public int getLineNumber() {
                return lineNumber;
            }

            @Override
            public int getColumnNumber() {
                return columnNumber;
            }
        }){

            @Override
            protected String getInstructionName() {
                return instructionName;
            }
        };
    }

    private static SourceLocator[] getLocation(Object object) {
        SourceLocator[] location;
        if (object == null) {
            location = null;
        } else if (object instanceof SourceLocator[]) {
            location = (SourceLocator[])object;
        } else if (object instanceof XStep) {
            location = ((XStep)object).getLocation();
        } else if (object instanceof Step) {
            location = new SourceLocator[]{XProcException.getLocator((Step)object)};
        } else if (object instanceof XdmNode) {
            location = new SourceLocator[]{XProcException.getLocator((XdmNode)object)};
        } else if (object instanceof XProcException) {
            location = ((XProcException)object).getLocation();
        } else if (object instanceof TransformerException) {
            location = XProcException.getLocation((TransformerException)object);
        } else if (object instanceof StackTraceElement[]) {
            location = XProcException.getLocation((StackTraceElement[])object);
        } else if (object instanceof Throwable) {
            location = XProcException.getLocation(((Throwable)object).getStackTrace());
        } else {
            throw new IllegalStateException("coding error");
        }
        if (location == null || location.length == 0) {
            return NO_LOCATION;
        }
        return location;
    }

    private static SourceLocator[] getLocation(TransformerException e) {
        XPathException xe;
        XPathContext ctxt;
        String instructionName;
        ArrayList<SourceLocator> frames = new ArrayList<SourceLocator>();
        SourceLocator loc = e.getLocator();
        if (loc == null) {
            TransformerException err = e;
            while (loc == null) {
                if (err.getException() instanceof TransformerException) {
                    err = (TransformerException)err.getException();
                    loc = err.getLocator();
                    continue;
                }
                if (!(err.getCause() instanceof TransformerException)) break;
                err = (TransformerException)err.getCause();
                loc = err.getLocator();
            }
        }
        if (loc == null) {
            loc = ExplicitLocation.UNKNOWN_LOCATION;
        }
        if (loc instanceof XPathParser.NestedLocation) {
            loc = ((XPathParser.NestedLocation)loc).getContainingLocation();
        }
        if ((instructionName = XProcException.getInstructionName(loc)) == null && e instanceof TerminationException) {
            instructionName = "xsl:message";
        }
        loc = XProcException.prettyLocator(loc, instructionName);
        frames.add(loc);
        if (e instanceof XPathException && (ctxt = (xe = (XPathException)e).getXPathContext()) != null) {
            ContextStackIterator ff = new ContextStackIterator(xe.getXPathContext());
            while (ff.hasNext()) {
                ContextStackFrame f = (ContextStackFrame)ff.next();
                instructionName = XProcException.getInstructionName(f);
                if (instructionName == null) continue;
                frames.add(XProcException.prettyLocator(f.getSystemId(), f.getLineNumber(), -1, instructionName));
            }
        }
        return frames.toArray(new SourceLocator[frames.size()]);
    }

    private static SourceLocator[] getLocation(StackTraceElement[] trace) {
        SourceLocator[] location = new SourceLocator[trace.length];
        for (int i = 0; i < trace.length; ++i) {
            location[i] = new JavaFrame(trace[i]);
        }
        return location;
    }

    private static SourceLocator getLocator(XdmNode node) {
        if (node == null) {
            return NO_LOCATOR;
        }
        final String systemId = URIUtils.cwdAsURI().relativize(node.getBaseURI()).toASCIIString();
        final int line = node.getLineNumber() > 0 ? node.getLineNumber() : S9apiUtils.getDocumentElement(node).getLineNumber();
        final int col = node.getColumnNumber();
        return new SourceLocator(){

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return systemId;
            }

            @Override
            public int getLineNumber() {
                return line;
            }

            @Override
            public int getColumnNumber() {
                return col;
            }
        };
    }

    public static SourceLocator getLocator(Step step) {
        return new XProcLocator(step);
    }

    private static String getInstructionName(SourceLocator loc) {
        if (loc instanceof AttributeLocation) {
            return ((AttributeLocation)loc).getElementName().getDisplayName() + "/@" + ((AttributeLocation)loc).getAttributeName();
        }
        if (loc instanceof DOMLocator) {
            return ((DOMLocator)loc).getOriginatingNode().getNodeName();
        }
        if (loc instanceof NodeInfo) {
            return ((NodeInfo)loc).getDisplayName();
        }
        if (loc instanceof ValidationException && ((ValidationException)loc).getNode() != null) {
            return ((ValidationException)loc).getNode().getDisplayName();
        }
        if (loc instanceof Instruction) {
            return StandardErrorListener.getInstructionName((Instruction)((Instruction)loc));
        }
        if (loc instanceof Actor) {
            return XProcException.getInstructionName((Actor)loc);
        }
        return null;
    }

    private static String getInstructionName(ContextStackFrame frame) {
        if (frame instanceof ContextStackFrame.FunctionCall) {
            StructuredQName name = ((ContextStackFrame.FunctionCall)frame).getFunctionName();
            if (name != null) {
                return name.getClarkName() + "()";
            }
        } else {
            if (frame instanceof ContextStackFrame.ApplyTemplates) {
                String name = "xsl:apply-templates";
                Item node = frame.getContextItem();
                if (node instanceof NodeInfo) {
                    name = name + " processing " + Navigator.getPath((NodeInfo)((NodeInfo)node));
                }
                return name;
            }
            if (frame instanceof ContextStackFrame.CallTemplate) {
                return "xsl:call-template name=\"" + ((ContextStackFrame.CallTemplate)frame).getTemplateName().getDisplayName() + "\"";
            }
            if (frame instanceof ContextStackFrame.VariableEvaluation) {
                Object container = frame.getContainer();
                if (container instanceof Actor) {
                    return XProcException.getInstructionName((Actor)container);
                }
                if (container instanceof TemplateRule) {
                    return "xsl:template match=\"" + ((TemplateRule)container).getMatchPattern().toString() + "\"";
                }
            }
        }
        return null;
    }

    private static String getInstructionName(Actor actor) {
        String objectName;
        StructuredQName name = actor.getObjectName();
        String string = objectName = name == null ? "" : name.getDisplayName();
        if (actor instanceof UserFunction) {
            return "function " + objectName + "()";
        }
        if (actor instanceof NamedTemplate) {
            return "template name=\"" + objectName + "\"";
        }
        if (actor instanceof AttributeSet) {
            return "attribute-set " + objectName;
        }
        if (actor instanceof KeyDefinition) {
            return "key " + objectName;
        }
        if (actor instanceof GlobalVariable) {
            StructuredQName qName = ((GlobalVariable)actor).getVariableQName();
            if (qName.hasURI("http://saxon.sf.net/generated-variable")) {
                return "optimizer-created global variable";
            }
            return "global variable $" + qName.getDisplayName();
        }
        return "procedure " + objectName;
    }

    private String printEnclosedLocation(SourceLocator[] enclosingLocation) {
        StringBuilder s = new StringBuilder();
        String message = this.getMessage();
        if (this.errorCode != null) {
            s.append("[").append(this.errorCode).append("]");
            if (message != null) {
                s.append(" ");
            }
        }
        if (message != null) {
            s.append(message);
        } else if (this.errorCode == null) {
            s.append((String)null);
        }
        int m = this.location.length - 1;
        for (int n = enclosingLocation.length - 1; m >= 0 && n >= 0 && this.location[m].equals(enclosingLocation[n]); --m, --n) {
        }
        int inCommon = this.location.length - 1 - m;
        for (int i = 0; i <= m; ++i) {
            if (this.location[i] == NO_LOCATOR) continue;
            s.append("\n\tat " + this.location[i]);
        }
        if (inCommon != 0) {
            s.append("\n\t... " + inCommon + " more");
        }
        if (this.errorCause != null) {
            s.append("\nCaused by: ");
            s.append(this.errorCause.printEnclosedLocation(this.location));
        }
        return s.toString();
    }

    @Override
    public String toString() {
        return this.printEnclosedLocation(new SourceLocator[0]);
    }

    private static void serializeLocation(SourceLocator[] location, TreeWriter writer) {
        boolean empty = true;
        for (SourceLocator l : location) {
            if (l.getSystemId() == null && l.getLineNumber() <= 0) continue;
            empty = false;
            break;
        }
        if (empty) {
            return;
        }
        writer.addStartElement(px_location);
        writer.startContent();
        for (SourceLocator l : location) {
            int column;
            int line;
            if (l.getSystemId() == null && l.getLineNumber() <= 0) continue;
            writer.addStartElement(px_file);
            if (l.getSystemId() != null) {
                writer.addAttribute(_href, l.getSystemId());
            }
            if ((line = l.getLineNumber()) > 0) {
                writer.addAttribute(_line, "" + line);
            }
            if ((column = l.getColumnNumber()) > 0) {
                writer.addAttribute(_column, "" + column);
            }
            writer.addEndElement();
        }
        writer.addEndElement();
    }

    public void serialize(TreeWriter writer) {
        Step step;
        writer.addStartElement(c_error);
        if (this.errorCode != null) {
            StructuredQName qCode = new StructuredQName(this.errorCode.getPrefix(), this.errorCode.getNamespaceURI(), this.errorCode.getLocalName());
            writer.addNamespace(qCode.getPrefix(), qCode.getNamespaceBinding().getURI());
            writer.addAttribute(_code, qCode.getDisplayName());
        }
        if (this.location[0] instanceof XProcLocator && (step = ((XProcLocator)this.location[0]).step) != null) {
            writer.addAttribute(_name, step.getName());
            writer.addAttribute(_type, step.getType().toString());
        }
        if (this.location[0].getSystemId() != null) {
            writer.addAttribute(_href, this.location[0].getSystemId());
        }
        if (this.location[0].getLineNumber() > 0) {
            writer.addAttribute(_line, "" + this.location[0].getLineNumber());
        }
        if (this.location[0].getColumnNumber() > 0) {
            writer.addAttribute(_column, "" + this.location[0].getColumnNumber());
        }
        writer.startContent();
        if (this.errorContent != null) {
            writer.addSubtree(this.errorContent);
        } else {
            String message = this.getMessage();
            if (message != null) {
                writer.addText(message);
            }
        }
        XProcException.serializeLocation(this.location, writer);
        if (this.errorCause != null) {
            writer.addStartElement(px_cause);
            writer.startContent();
            this.errorCause.serialize(writer);
            writer.addEndElement();
        }
        writer.addEndElement();
    }

    private static class JavaFrame
    implements SourceLocator {
        public final StackTraceElement frame;

        public JavaFrame(StackTraceElement frame) {
            this.frame = frame;
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public String getSystemId() {
            return this.frame.getFileName();
        }

        @Override
        public int getLineNumber() {
            return this.frame.getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        public String toString() {
            return this.frame.toString();
        }
    }

    public static class XProcLocator
    extends SourceLocatorWithInstructionName {
        private final Step step;
        private final String instructionName;

        public XProcLocator(Step step) {
            super(XProcException.getLocator(step != null ? step.getNode() : null));
            this.step = step;
            if (step == null || step.getNode() == null) {
                this.instructionName = null;
            } else {
                String name = step.getName();
                this.instructionName = step.getNode().getNodeName().getClarkName() + (name.startsWith("#") || name.startsWith("!") ? "" : " name=\"" + name + "\"");
            }
        }

        public Step getStep() {
            return this.step;
        }

        @Override
        protected String getInstructionName() {
            return this.instructionName;
        }
    }

    private static abstract class SourceLocatorWithInstructionName
    implements SourceLocator {
        private final SourceLocator locator;

        public SourceLocatorWithInstructionName(SourceLocator locator) {
            this.locator = locator;
        }

        @Override
        public String getPublicId() {
            return this.locator != null ? this.locator.getPublicId() : null;
        }

        @Override
        public String getSystemId() {
            return this.locator != null ? this.locator.getSystemId() : null;
        }

        @Override
        public int getLineNumber() {
            return this.locator != null ? this.locator.getLineNumber() : -1;
        }

        @Override
        public int getColumnNumber() {
            return this.locator != null ? this.locator.getColumnNumber() : -1;
        }

        protected abstract String getInstructionName();

        public String toString() {
            StringBuilder s = new StringBuilder();
            String instructionName = this.getInstructionName();
            String fileName = this.getSystemId();
            if (fileName != null && !"".equals(fileName)) {
                if (fileName.lastIndexOf(47) >= 0) {
                    fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                }
                s.append(fileName);
                int line = this.getLineNumber();
                if (line > 0) {
                    s.append(":" + this.getLineNumber());
                }
            }
            if (instructionName != null && !"".equals(instructionName)) {
                if (s.length() > 0) {
                    s.insert(0, instructionName + "(").append(")");
                } else {
                    s.append(instructionName);
                }
            } else if (s.length() == 0) {
                s.append("?");
            }
            return s.toString();
        }
    }

    private static class DynamicXProcError
    extends XProcException {
        private DynamicXProcError(Object code, Object location, Object message, XProcException cause) {
            super((QName)(code instanceof QName ? (QName)code : (code instanceof Integer ? (code != null ? XProcConstants.dynamicError((Integer)code) : null) : null)), location, message, cause);
            if (code == null || !(code instanceof Integer) && !(code instanceof QName)) {
                throw new IllegalStateException("coding error");
            }
        }
    }

    private static class StaticXProcError
    extends XProcException {
        private StaticXProcError(Integer code, Object location, Object message) {
            super(code != null ? XProcConstants.staticError(code) : null, location, message, null);
            if (code == null || message != null && !(message instanceof String) && !(message instanceof Throwable)) {
                throw new IllegalStateException("coding error");
            }
        }
    }
}

