/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.core;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XStep;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import net.sf.saxon.s9api.XdmNode;

public class XProcData {
    private Stack<StackFrame> stack = null;
    private XProcRuntime runtime = null;

    public XProcData(XProcRuntime runtime) {
        this.runtime = runtime;
        this.stack = new Stack();
    }

    public void openFrame(XStep step) {
        int pos = 1;
        int size = 1;
        if (this.stack.size() > 0) {
            pos = this.stack.peek().iterPos;
            size = this.stack.peek().iterSize;
        }
        StackFrame frame = new StackFrame();
        frame.iterPos = pos;
        frame.iterSize = size;
        this.stack.push(frame);
        this.stack.peek().step = step;
    }

    public void closeFrame() {
        this.stack.pop();
    }

    public int getDepth() {
        return this.stack.size();
    }

    public XStep getStep() {
        if (this.stack.size() == 0) {
            return null;
        }
        return this.stack.peek().step;
    }

    public void setIterationPosition(int pos) {
        this.stack.peek().iterPos = pos;
    }

    public int getIterationPosition() {
        return this.stack.peek().iterPos;
    }

    public void setIterationSize(int size) {
        this.stack.peek().iterSize = size;
    }

    public int getIterationSize() {
        return this.stack.peek().iterSize;
    }

    private boolean tryGroup(XStep step) {
        if (XProcConstants.p_group.equals((Object)step.getType())) {
            XdmNode node = step.getNode();
            return XProcConstants.p_try.equals((Object)node.getParent().getNodeName());
        }
        return false;
    }

    public boolean catchError(XdmNode error) {
        int pos = this.stack.size() - 1;
        if (this.stack.size() > 0 && XProcConstants.p_catch.equals((Object)this.stack.peek().step.getType())) {
            pos -= 2;
        }
        while (pos >= 0 && !this.tryGroup(((StackFrame)this.stack.get((int)pos)).step)) {
            --pos;
        }
        if (pos >= 0) {
            ((StackFrame)this.stack.get((int)pos)).errors.add(error);
            return true;
        }
        return false;
    }

    public List<XdmNode> errors() {
        int pos;
        for (pos = this.stack.size() - 1; pos >= 0 && !this.tryGroup(((StackFrame)this.stack.get((int)pos)).step); --pos) {
        }
        if (pos >= 0) {
            return ((StackFrame)this.stack.get((int)pos)).errors;
        }
        return new Stack<XdmNode>();
    }

    private class StackFrame {
        public XStep step = null;
        public int iterPos = 1;
        public int iterSize = 1;
        public Vector<XdmNode> errors = new Vector();
    }
}

