/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.kaufman.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;

public class S3FileFactoryBean
implements FactoryBean<File>,
DisposableBean {
    private static final Log LOG = LogFactory.getLog(S3FileFactoryBean.class);
    private final String bucketName;
    private final String objectKey;
    private File localFile;
    private final AmazonS3 s3Client;

    public S3FileFactoryBean(AmazonS3 s3Client, String bucketName, String objectKey) {
        this.s3Client = s3Client;
        this.bucketName = bucketName;
        this.objectKey = objectKey;
    }

    public S3FileFactoryBean(AWSCredentials creds, String bucketName, String objectKey) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(creds), bucketName, objectKey);
    }

    public S3FileFactoryBean(AWSCredentialsProvider creds, String bucketName, String objectKey) {
        this((AmazonS3)new AmazonS3Client(creds), bucketName, objectKey);
    }

    public S3FileFactoryBean(String bucketName, String objectKey) {
        this((AWSCredentialsProvider)new InstanceProfileCredentialsProvider(), bucketName, objectKey);
    }

    public void destroy() {
        if (this.localFile.exists()) {
            this.localFile.delete();
            LOG.info((Object)("Local file " + this.localFile + " is deleted"));
        }
    }

    public File getObject() throws IOException {
        if (this.localFile == null) {
            this.localFile = File.createTempFile(S3FileFactoryBean.class.getSimpleName(), ".tmp");
            LOG.info((Object)("Using default local file " + this.localFile));
        }
        LOG.info((Object)String.format("Getting object %s:%s into local file %s", this.bucketName, this.objectKey, this.localFile.getAbsolutePath()));
        ObjectMetadata result = this.s3Client.getObject(new GetObjectRequest(this.bucketName, this.objectKey), this.localFile);
        LOG.info((Object)("Call to S3 succeeded and returned " + result));
        return this.localFile;
    }

    public Class<File> getObjectType() {
        return File.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setLocalFile(File localFile) {
        this.localFile = localFile;
    }
}

