/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.cyclopsgroup.caff.conversion.AnnotatedConverter;
import org.cyclopsgroup.caff.conversion.Converter;
import org.cyclopsgroup.caff.ref.ValueReference;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.MultiValue;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jcli.impl.AnnotationArgument;
import org.cyclopsgroup.jcli.impl.AnnotationCli;
import org.cyclopsgroup.jcli.impl.AnnotationOption;
import org.cyclopsgroup.jcli.impl.AnnotationParsingContext;
import org.cyclopsgroup.jcli.impl.MultiValueReference;
import org.cyclopsgroup.jcli.impl.Reference;
import org.cyclopsgroup.jcli.impl.SingleValueReference;

class ParsingContextBuilder<T> {
    private final Class<? extends T> beanType;

    private static <B, P> Reference<B> createReference(Class<? extends B> beanType, PropertyDescriptor descriptor, String longName) {
        Class<?> valueType = descriptor.getPropertyType();
        MultiValue multiValue = ParsingContextBuilder.getAnnotation(descriptor, MultiValue.class);
        if (multiValue != null) {
            valueType = multiValue.valueType();
        }
        AnnotatedConverter converter = new AnnotatedConverter(valueType, descriptor);
        ValueReference reference = ValueReference.instanceOf((PropertyDescriptor)descriptor);
        if (multiValue != null) {
            return new MultiValueReference<B>(beanType, (Converter<?>)converter, reference, longName, multiValue.listType());
        }
        return new SingleValueReference<B>(beanType, (Converter<?>)converter, reference, longName);
    }

    private static <A extends Annotation> A getAnnotation(PropertyDescriptor descriptor, Class<A> type) {
        A a = null;
        if (descriptor.getWriteMethod() != null) {
            a = descriptor.getWriteMethod().getAnnotation(type);
        }
        if (a == null && descriptor.getReadMethod() != null) {
            a = descriptor.getReadMethod().getAnnotation(type);
        }
        return a;
    }

    ParsingContextBuilder(Class<? extends T> beanType) {
        this.beanType = beanType;
    }

    AnnotationParsingContext<T> build() {
        BeanInfo beanInfo;
        ArrayList<AnnotationOption> options = new ArrayList<AnnotationOption>();
        HashMap references = new HashMap();
        Cli cliAnnotation = this.beanType.getAnnotation(Cli.class);
        try {
            beanInfo = Introspector.getBeanInfo(this.beanType);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Bean " + this.beanType + " is not correctly defined", e);
        }
        Argument argument = null;
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            Method writer = descriptor.getWriteMethod();
            if (writer == null) continue;
            Option option = ParsingContextBuilder.getAnnotation(descriptor, Option.class);
            if (option != null) {
                boolean flag = descriptor.getPropertyType() == Boolean.TYPE || descriptor.getPropertyType() == Boolean.class;
                boolean multiValue = ParsingContextBuilder.getAnnotation(descriptor, MultiValue.class) != null;
                options.add(new AnnotationOption(option, flag, multiValue));
                references.put(option.name(), ParsingContextBuilder.createReference(this.beanType, descriptor, option.longName()));
                continue;
            }
            Argument arg = ParsingContextBuilder.getAnnotation(descriptor, Argument.class);
            if (arg == null) continue;
            argument = arg;
            references.put("----arguments----", ParsingContextBuilder.createReference(this.beanType, descriptor, "----arguments----"));
        }
        return new AnnotationParsingContext(references, options, new AnnotationCli(cliAnnotation), argument == null ? null : new AnnotationArgument(argument));
    }
}

