/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jcli.impl;

import org.apache.commons.lang.StringUtils;
import org.cyclopsgroup.caff.format.FixLengthField;
import org.cyclopsgroup.caff.format.FixLengthType;
import org.cyclopsgroup.jcli.spi.Option;

@FixLengthType(length=256)
public class OptionHelp {
    private final Option option;

    OptionHelp(Option option) {
        this.option = option;
    }

    @FixLengthField(start=26, length=228)
    public String getDescription() {
        String desc = this.option.getDescription();
        if (!this.option.isFlag() && StringUtils.isNotBlank((String)this.option.getDefaultValue())) {
            desc = desc + "(Default value is " + this.option.getDefaultValue() + ")";
        }
        return desc;
    }

    @FixLengthField(start=15, length=10)
    public String getDisplayName() {
        return this.option.isFlag() ? null : "<" + this.option.getDisplayName() + ">";
    }

    @FixLengthField(start=4, length=10)
    public String getLongName() {
        return StringUtils.isBlank((String)this.option.getLongName()) ? null : "--" + this.option.getLongName();
    }

    @FixLengthField(start=1, length=2)
    public String getName() {
        return "-" + this.option.getName();
    }
}

