/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.cym2.awss3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.resource.Resource;

public class S3Wagon
extends StreamWagon {
    private static final String INSTANCE_PROFILE_USER = "INSTANCE_PROFILE";
    private String bucketName;
    private String keyPrefix;
    private final Map<String, String> mimeTypes;
    private AmazonS3 s3;
    private final MimetypesFileTypeMap typeMap = new MimetypesFileTypeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> loadMimeTypes() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        InputStream in = S3Wagon.class.getClassLoader().getResourceAsStream("mime.types");
        try {
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(in));
            String line = reader.readLine();
            while (line != null) {
                String[] pieces;
                if (!StringUtils.isBlank((String)line) && !line.startsWith("#") && (pieces = (line = line.trim()).split("\\s+")).length > 1) {
                    String mimeType = pieces[0];
                    for (int i = 1; i < pieces.length; ++i) {
                        map.put(pieces[i], mimeType);
                    }
                }
                line = reader.readLine();
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public S3Wagon() throws IOException {
        this.mimeTypes = Collections.unmodifiableMap(S3Wagon.loadMimeTypes());
    }

    public void closeConnection() throws ConnectionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPutFromStream(InputStream in, File inFile, String destination, long contentLength, long lastModified) {
        Resource resource = new Resource(destination);
        this.firePutInitiated(resource, inFile);
        String dest = StringUtils.removeStart((String)destination, (String)"./");
        dest = StringUtils.removeStart((String)dest, (String)"/");
        String key = this.keyPrefix + dest;
        this.fireTransferDebug("{keyPreix = " + this.keyPrefix + ", dest=" + destination + "} -> " + dest);
        ObjectMetadata meta = new ObjectMetadata();
        if (contentLength != -1L) {
            meta.setContentLength(contentLength);
        }
        meta.setLastModified(new Date(lastModified));
        int lastDot = destination.lastIndexOf(46);
        String mimeType = null;
        if (lastDot != -1) {
            String ext = destination.substring(lastDot + 1, destination.length());
            mimeType = this.mimeTypes.get(ext);
        }
        if (mimeType == null) {
            mimeType = this.typeMap.getContentType(destination);
        } else {
            this.fireTransferDebug("Mime type of " + dest + " is " + mimeType + " according to build-in types");
        }
        if (mimeType != null) {
            meta.setContentType(mimeType);
        }
        try {
            this.fireTransferDebug("Uploading file " + inFile + " to  s3://" + this.bucketName + "/" + key);
            this.firePutStarted(resource, inFile);
            this.s3.putObject(this.bucketName, key, in, meta);
            this.firePutCompleted(resource, inFile);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public void fillInputData(InputData in) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        S3Object object;
        this.fireTransferDebug("Filling input data");
        String key = this.keyPrefix + in.getResource().getName();
        try {
            object = this.s3.getObject(this.bucketName, key);
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404) {
                throw new ResourceDoesNotExistException("Key " + key + " does not exist in S3 bucket " + this.bucketName);
            }
            if (e.getStatusCode() == 403) {
                throw new ResourceDoesNotExistException("403 implies that key " + key + " does not exist in bucket " + this.bucketName, (Throwable)e);
            }
            throw new TransferFailedException("Can't get object " + key + " from S4 bucket " + this.bucketName, (Throwable)e);
        }
        in.getResource().setContentLength(object.getObjectMetadata().getContentLength());
        in.getResource().setLastModified(object.getObjectMetadata().getLastModified().getTime());
        in.setInputStream((InputStream)object.getObjectContent());
    }

    public void fillOutputData(OutputData out) throws TransferFailedException {
        throw new UnsupportedOperationException("This call is not supported");
    }

    public void get(String resourceName, File destination) throws ResourceDoesNotExistException, TransferFailedException {
        Resource resource = new Resource(resourceName);
        this.fireGetInitiated(resource, destination);
        String key = this.keyPrefix + resourceName;
        try {
            this.fireGetStarted(resource, destination);
            this.s3.getObject(new GetObjectRequest(this.bucketName, key), destination);
            this.fireGetCompleted(resource, destination);
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404) {
                throw new ResourceDoesNotExistException("Key " + key + " does not exist in bucket " + this.bucketName, (Throwable)e);
            }
            if (e.getStatusCode() == 403) {
                throw new ResourceDoesNotExistException("403 implies that key " + key + " does not exist in bucket " + this.bucketName, (Throwable)e);
            }
            throw new TransferFailedException("Getting metadata of key " + key + " failed", (Throwable)e);
        }
    }

    public List getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException {
        String path = this.keyPrefix + destinationDirectory;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.fireSessionDebug("Listing objects with prefix " + path + " under bucket " + this.bucketName);
        ObjectListing result = this.s3.listObjects(new ListObjectsRequest().withBucketName(this.bucketName).withPrefix(path).withDelimiter("/"));
        if (result.getObjectSummaries().isEmpty()) {
            throw new ResourceDoesNotExistException("No keys exist with prefix " + path);
        }
        HashSet<String> results = new HashSet<String>();
        for (S3ObjectSummary summary : result.getObjectSummaries()) {
            String name = StringUtils.removeStart((String)summary.getKey(), (String)path);
            if (name.indexOf(47) == -1) {
                results.add(name);
                continue;
            }
            results.add(name.substring(0, name.indexOf(47)));
        }
        this.fireSessionDebug("Returning result " + results);
        return new ArrayList(results);
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws ResourceDoesNotExistException, TransferFailedException {
        ObjectMetadata meta = this.getRequiredMetadata(resourceName);
        if (meta == null) {
            return false;
        }
        if (meta.getLastModified() != null && meta.getLastModified().getTime() > timestamp) {
            this.fireSessionDebug("Remote timestamp " + meta.getLastModified() + " is greater than local timestamp " + timestamp + ", ignore get");
            return false;
        }
        this.get(resourceName, destination);
        return true;
    }

    public boolean getIfNewerToStream(String resourceName, OutputStream out, long timestamp) throws ResourceDoesNotExistException, TransferFailedException {
        ObjectMetadata meta = this.getRequiredMetadata(resourceName);
        if (meta == null) {
            return false;
        }
        if (meta.getLastModified() != null && meta.getLastModified().getTime() > timestamp) {
            this.fireSessionDebug("Remote timestamp " + meta.getLastModified() + " is greater than local timestamp " + timestamp + ", ignore get");
            return false;
        }
        Resource resource = new Resource(resourceName);
        this.fireGetInitiated(resource, null);
        S3ObjectInputStream in = this.s3.getObject(this.bucketName, this.keyPrefix).getObjectContent();
        try {
            this.fireGetStarted(resource, null);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
            out.close();
            this.fireGetCompleted(resource, null);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new TransferFailedException("Stream copy failed", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private ObjectMetadata getRequiredMetadata(String resourceName) throws ResourceDoesNotExistException, TransferFailedException {
        String key = this.keyPrefix + resourceName;
        try {
            return this.s3.getObjectMetadata(this.bucketName, key);
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404) {
                throw new ResourceDoesNotExistException("Key " + key + " does not exist in bucket " + this.bucketName, (Throwable)e);
            }
            throw new TransferFailedException("Getting metadata of key " + key + "failed", (Throwable)e);
        }
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        InstanceProfileCredentialsProvider credentials;
        if (this.authenticationInfo == null) {
            throw new AuthenticationException("S3 access requires authentication information. Repository is " + this.getRepository());
        }
        if (StringUtils.isEmpty((String)this.authenticationInfo.getUserName())) {
            throw new AuthenticationException("Tag <username> must set to valid AWS access key ID in server configuration, either in pom.xml or settings.xml. Repository is " + this.getRepository());
        }
        boolean instanceProfile = INSTANCE_PROFILE_USER.equalsIgnoreCase(this.authenticationInfo.getUserName());
        if (instanceProfile) {
            this.fireSessionDebug("Creating instance profile credentials...");
            credentials = new InstanceProfileCredentialsProvider();
        } else {
            if (StringUtils.isEmpty((String)this.authenticationInfo.getPassword())) {
                throw new AuthenticationException("Tag <password> must set to valid AWS secret key in server configuration, either in pom.xml or settings.xml. Repository is " + this.getRepository());
            }
            this.fireSessionDebug("Creating static credentials " + this.authenticationInfo.getUserName());
            credentials = new StaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.authenticationInfo.getUserName(), this.authenticationInfo.getPassword()));
        }
        ClientConfiguration config = new ClientConfiguration();
        config.setConnectionTimeout(this.getTimeout());
        config.setSocketTimeout(this.getTimeout());
        this.fireSessionDebug("Connect timeout and socket timeout is set to " + this.getTimeout() + " ms");
        ProxyInfo proxy = this.getProxyInfo();
        this.fireSessionDebug("Setting up AWS S3 client with source " + ToStringBuilder.reflectionToString((Object)this.getRepository()) + ", authentication information and proxy " + ToStringBuilder.reflectionToString((Object)proxy));
        if (proxy != null) {
            config.setProxyDomain(proxy.getNtlmDomain());
            config.setProxyHost(proxy.getHost());
            config.setProxyPassword(proxy.getPassword());
            config.setProxyPort(proxy.getPort());
            config.setProxyUsername(proxy.getUserName());
            config.setProxyWorkstation(proxy.getNtlmHost());
        }
        this.fireSessionDebug("AWS Client config is " + ToStringBuilder.reflectionToString((Object)config));
        this.s3 = new AmazonS3Client((AWSCredentialsProvider)credentials, config);
        this.bucketName = this.getRepository().getHost();
        this.fireSessionDebug("Bucket name is " + this.bucketName);
        String prefix = StringUtils.trimToEmpty((String)this.getRepository().getBasedir());
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        this.keyPrefix = prefix = StringUtils.removeStart((String)prefix, (String)"/");
        this.fireSessionDebug("Key prefix " + this.keyPrefix);
    }

    public void put(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException {
        try {
            this.doPutFromStream(new FileInputStream(source), source, destination, source.length(), source.lastModified());
        }
        catch (FileNotFoundException e) {
            throw new ResourceDoesNotExistException("Source file " + source + " does not exist", (Throwable)e);
        }
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        if (destinationDirectory.equals(".")) {
            destinationDirectory = "";
        }
        this.fireTransferDebug("Putting " + sourceDirectory + " to " + destinationDirectory + " which is noop");
        for (File file : sourceDirectory.listFiles()) {
            String dest = StringUtils.isBlank((String)destinationDirectory) ? file.getName() : destinationDirectory + "/" + file.getName();
            this.fireTransferDebug("Putting child element " + file + " to " + dest);
            if (file.isDirectory()) {
                this.putDirectory(file, dest);
                continue;
            }
            this.put(file, dest);
        }
    }

    public void putFromStream(InputStream in, String destination) throws TransferFailedException, ResourceDoesNotExistException {
        this.doPutFromStream(in, null, destination, -1L, System.currentTimeMillis());
    }

    public void putFromStream(InputStream in, String destination, long contentLength, long lastModified) throws TransferFailedException, ResourceDoesNotExistException {
        this.doPutFromStream(in, null, destination, contentLength, lastModified);
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        String key = this.keyPrefix + resourceName;
        try {
            this.s3.getObjectMetadata(this.bucketName, key);
            return true;
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw new TransferFailedException("Can't verify if resource key " + key + " exist or not", (Throwable)e);
        }
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }
}

