/*
 * Decompiled with CFR 0.152.
 */
package org.cukesalad.db.step;

import cucumber.api.DataTable;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cukesalad.db.support.DBSaladContext;
import org.cukesalad.db.support.DBSaladHook;
import org.cukesalad.db.support.DynamicSQLQuery;
import org.junit.Assert;

public class DBSaladSteps {
    @When(value="^I set up data in DB using \"([^\"]*)\", and rollback test data at the end using \"([^\"]*)\"$")
    public void i_setup_up_data_in_db_using_and_rollback_test_data_at_the_end_using(String setupFile, String tearDownFile) throws Throwable {
        this.i_teardown_data_in_db_using(tearDownFile);
        this.i_set_up_data_in_db_using(setupFile);
        DBSaladSteps.collectTearDownFiles(tearDownFile, null);
    }

    public static void collectTearDownFiles(String tearDownFile, Map<String, String> paramenterMap) {
        DynamicSQLQuery dynamicSQLQuery = new DynamicSQLQuery();
        dynamicSQLQuery.setParameterMap(paramenterMap);
        dynamicSQLQuery.setSqlFileName(tearDownFile);
        DBSaladContext.tearDownFiles.add(dynamicSQLQuery);
    }

    @When(value="^I set up data in DB using \"([^\"]*)\"$")
    public void i_set_up_data_in_db_using(String setupFile) throws Throwable {
        DynamicSQLQuery dynamicSQLQuery = new DynamicSQLQuery();
        dynamicSQLQuery.setSqlFileName(setupFile);
        DBSaladHook.executeUpdate(dynamicSQLQuery);
    }

    @When(value="^I teardown data in DB using \"([^\"]*)\"$")
    public void i_teardown_data_in_db_using(String tearDownFile) throws Throwable {
        DynamicSQLQuery dynamicSQLQuery = new DynamicSQLQuery();
        dynamicSQLQuery.setSqlFileName(tearDownFile);
        DBSaladHook.executeUpdate(dynamicSQLQuery);
    }

    @Given(value="^I teardown data in DB using \"([^\"]*)\" and below parameters:$")
    public void i_teardown_data_in_DB_using_and_below_parameters(String sqlFileName, DataTable parameters) throws Throwable {
        DynamicSQLQuery dynamicSQLQuery = new DynamicSQLQuery();
        dynamicSQLQuery.setSqlFileName(sqlFileName);
        Map<String, String> parameterMap = this.createParamMap(parameters);
        dynamicSQLQuery.setParameterMap(parameterMap);
        DBSaladHook.executeUpdate(dynamicSQLQuery);
    }

    @Given(value="^I set up data in DB using \"([^\"]*)\" and below parameters:$")
    public void i_set_up_data_in_DB_using_and_below_parameters(String sqlFileName, DataTable parameters) throws Throwable {
        DynamicSQLQuery dynamicSQLQuery = new DynamicSQLQuery();
        dynamicSQLQuery.setSqlFileName(sqlFileName);
        Map<String, String> parameterMap = this.createParamMap(parameters);
        dynamicSQLQuery.setParameterMap(parameterMap);
        DBSaladHook.executeUpdate(dynamicSQLQuery);
    }

    @Given(value="^I set up data in DB using \"([^\"]*)\", and rollback test data at the end using \"([^\"]*)\" with below parameters:$")
    public void i_setup_up_data_in_DB_using_and_rollback_test_data_at_the_end_using_with_below_parameters(String setupFileName, String tearDownFileName, DataTable parameters) throws Throwable {
        this.i_teardown_data_in_DB_using_and_below_parameters(tearDownFileName, parameters);
        this.i_set_up_data_in_DB_using_and_below_parameters(setupFileName, parameters);
        DBSaladSteps.collectTearDownFiles(tearDownFileName, this.createParamMap(parameters));
    }

    @Given(value="^I set up data using the sql file \"([^\"]*)\" for the below data:$")
    public void i_set_up_data_using_the_sql_file_for_the_below_data(String setupFileName, DataTable parameters) throws Throwable {
        List paramMapList = parameters.asMaps(String.class, String.class);
        for (Map paramMap : paramMapList) {
            DynamicSQLQuery dynamicSQLQuery = new DynamicSQLQuery();
            dynamicSQLQuery.setSqlFileName(setupFileName);
            dynamicSQLQuery.setParameterMap(paramMap);
            DBSaladHook.executeUpdate(dynamicSQLQuery);
        }
    }

    @Then(value="^the result of the sql \"([^\"]*)\" is:$")
    public void the_result_of_the_sql_is(String setupFileName, DataTable expectedResults) throws Throwable {
        List expectedResultsMaps = expectedResults.asMaps(String.class, String.class);
        DynamicSQLQuery dynamicSQLQuery = new DynamicSQLQuery();
        dynamicSQLQuery.setSqlFileName(setupFileName);
        ResultSet result = DBSaladHook.executeQuery(dynamicSQLQuery);
        List columnNames = expectedResults.topCells();
        ArrayList actualResultsMaps = new ArrayList();
        while (result.next()) {
            HashMap<String, String> actualRow = new HashMap<String, String>();
            for (String columnName : columnNames) {
                actualRow.put(columnName, result.getString(columnName));
            }
            actualResultsMaps.add(actualRow);
        }
        Assert.assertTrue((String)("the result of the cql doesn't match expected: expected result - " + expectedResultsMaps + ", and actual result - " + actualResultsMaps), (boolean)actualResultsMaps.containsAll(expectedResultsMaps));
    }

    @Then(value="^the result of the sql \"([^\"]*)\" is empty$")
    public void the_result_of_the_sql_is_empty(String setupFileName) throws Throwable {
        this.the_result_of_the_sql_has_rows(setupFileName, 0);
    }

    @Then(value="^the result of the sql \"([^\"]*)\" has (\\d+) rows$")
    public void the_result_of_the_sql_has_rows(String setupFileName, Integer expectedRowSize) throws Throwable {
        DynamicSQLQuery dynamicSQLQuery = new DynamicSQLQuery();
        dynamicSQLQuery.setSqlFileName(setupFileName);
        ResultSet result = DBSaladHook.executeQuery(dynamicSQLQuery);
        result.last();
        Assert.assertEquals((long)expectedRowSize.intValue(), (long)result.getRow());
    }

    public Map<String, String> createParamMap(DataTable parameters) {
        HashMap<String, String> parameterMap = new HashMap<String, String>(parameters.asMap(String.class, String.class));
        parameterMap.remove("key");
        return parameterMap;
    }
}

