/*
 * Decompiled with CFR 0.152.
 */
package org.cuberact.storage.deferred;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.cuberact.storage.deferred.DeferredTask;
import org.cuberact.storage.deferred.DeferredThreadPoolExecutor;

public class DeferredExecutor {
    private static final DeferredThreadPoolExecutor DEFERRED_EXECUTOR = new DeferredThreadPoolExecutor();

    public static void runDeferred(DeferredTask task) {
        DEFERRED_EXECUTOR.schedule(task, task.getDelayInMilliSeconds(), TimeUnit.MILLISECONDS);
    }

    public static void runImmediately(Predicate<DeferredTask> matched) {
        List<DeferredTask> selected = DEFERRED_EXECUTOR.getQueue().stream().map(runnable -> (DeferredTask)runnable).filter(matched).collect(Collectors.toList());
        selected.forEach(deferredTask -> {
            boolean canceled = deferredTask.cancel(false);
            if (canceled) {
                DEFERRED_EXECUTOR.getQueue().remove(deferredTask);
                deferredTask.run();
            }
        });
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> DEFERRED_EXECUTOR.shutdownNow().forEach(Runnable::run), "DEFERRED_EXECUTOR - shutdown"));
    }
}

