/*
 * Decompiled with CFR 0.152.
 */
package org.cuberact.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.cuberact.storage.InputStreamProcessor;
import org.cuberact.storage.Storage;
import org.cuberact.storage.StorageException;
import org.cuberact.storage.StorageType;
import org.cuberact.storage.deferred.DeferredExecutor;
import org.cuberact.storage.deferred.DeferredTask;

public class Resource {
    private final Storage storage;
    private final String path;
    private URI uri;
    private String fullName;
    private String name;
    private String extension;
    private final Predicate<DeferredTask> matcher = task -> task instanceof WriteTask && ((WriteTask)task).resource.equals(this);

    Resource(Storage storage, String path) {
        this.storage = storage;
        this.path = path;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public String getPath() {
        return this.path;
    }

    public URI getUri() {
        if (this.uri == null) {
            this.uri = this.getStorage().getType() == StorageType.ZIP ? Storage.createURI("jar:/file:/" + Storage.normalizePath(this.getStorage().getPath().toString()) + "!/" + this.path) : Storage.createURI("file:/" + Storage.normalizePath(this.getStorage().getPath().resolve(this.path).toString()));
        }
        return this.uri;
    }

    public String getFullName() {
        if (this.fullName == null) {
            this.fullName = this.path.lastIndexOf("/") != -1 ? this.path.substring(this.path.lastIndexOf("/") + 1) : this.path;
        }
        return this.fullName;
    }

    public String getName() {
        if (this.name == null) {
            int i = this.getFullName().lastIndexOf(46);
            this.name = i != -1 ? this.getFullName().substring(0, i) : this.getFullName();
        }
        return this.name;
    }

    public String getExtension() {
        if (this.extension == null) {
            int i = this.getFullName().lastIndexOf(46);
            this.extension = i != -1 ? this.getFullName().substring(i + 1) : "";
        }
        return this.extension;
    }

    public boolean exists() {
        DeferredExecutor.runImmediately(this.matcher);
        return this.storage.exists() && this.storage.runInStorage(fs -> Files.exists(fs.getPath(this.path, new String[0]), new LinkOption[0])) != false;
    }

    public long size() {
        DeferredExecutor.runImmediately(this.matcher);
        return this.storage.runInStorage(fs -> Files.size(fs.getPath(this.path, new String[0])));
    }

    public void delete() {
        DeferredExecutor.runImmediately(this.matcher);
        this.storage.runInStorage(fs -> {
            Storage.delete(fs.getPath(this.path, new String[0]));
            return null;
        });
    }

    public byte[] readToBytes() {
        DeferredExecutor.runImmediately(this.matcher);
        return this.storage.runInStorage(fs -> {
            try {
                return Files.readAllBytes(fs.getPath(this.path, new String[0]));
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        });
    }

    public ByteBuffer readToByteBuffer() {
        byte[] content = this.readToBytes();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(content.length).order(ByteOrder.nativeOrder());
        byteBuffer.put(content);
        byteBuffer.flip();
        return byteBuffer;
    }

    public String readToString() {
        return new String(this.readToBytes(), this.getStorage().getCharset());
    }

    public <E> E readFromInputStream(InputStreamProcessor<E> processor) {
        DeferredExecutor.runImmediately(this.matcher);
        return (E)this.storage.runInStorage(fs -> {
            try (InputStream inputStream = Files.newInputStream(fs.getPath(this.path, new String[0]), new OpenOption[0]);){
                Object e = processor.read(inputStream);
                return e;
            }
            catch (Throwable e) {
                throw new StorageException(e);
            }
        });
    }

    public void write(CharSequence content, boolean append) {
        this.write(content.toString().getBytes(this.getStorage().getCharset()), append);
    }

    public void write(Reader content, boolean append) {
        DeferredExecutor.runImmediately(this.matcher);
        this.storage.runInStorage(fs -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public void write(byte[] content, boolean append) {
        DeferredExecutor.runImmediately(this.matcher);
        this.writeInternal(content, append);
    }

    public void write(InputStream content, boolean append) {
        this.write(new InputStreamReader(content, this.getStorage().getCharset()), append);
    }

    public void writeDeferred(CharSequence content) {
        this.writeDeferred(content.toString().getBytes(this.getStorage().getCharset()));
    }

    public void writeDeferred(byte[] content) {
        this.writeDeferred(new BytesSupplier(content));
    }

    public void writeDeferred(Supplier<byte[]> contentProvider) {
        DeferredExecutor.runDeferred(new WriteTask(this, contentProvider));
    }

    void writeInternal(byte[] content, boolean append) {
        this.storage.runInStorage(fs -> {
            try {
                Path writePath = fs.getPath(this.path, new String[0]);
                Path parentPath = writePath.getParent();
                if (parentPath != null) {
                    Files.createDirectories(parentPath, new FileAttribute[0]);
                }
                Files.write(writePath, content, this.getOpenOption(append));
                return null;
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        });
    }

    public int hashCode() {
        return this.getUri().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Resource) {
            Resource other = (Resource)obj;
            return Objects.equals(this.getUri(), other.getUri());
        }
        return false;
    }

    public String toString() {
        return "  Resource - path = " + this.path + " [exists: " + this.exists() + ", uri: " + this.getUri().toString() + "]";
    }

    private OpenOption getOpenOption(boolean append) {
        if (this.exists()) {
            return append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING;
        }
        return StandardOpenOption.CREATE;
    }

    static class WriteTask
    extends DeferredTask {
        final Resource resource;
        final Supplier<byte[]> contentProvider;

        WriteTask(Resource resource, Supplier<byte[]> contentProvider) {
            super(DEFERRED_DELAY_IN_MILLISECONDS);
            this.resource = resource;
            this.contentProvider = contentProvider;
        }

        @Override
        public void run() {
            this.resource.writeInternal(this.contentProvider.get(), false);
        }

        @Override
        public int hashCode() {
            return 31 + this.resource.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && Objects.equals(this.resource, ((WriteTask)o).resource);
        }

        public String toString() {
            return this.resource.getUri().toString();
        }
    }

    private static class BytesSupplier
    implements Supplier<byte[]> {
        private final byte[] bytes;

        private BytesSupplier(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public byte[] get() {
            return this.bytes;
        }
    }
}

