/*
 * Decompiled with CFR 0.152.
 */
package org.cuberact.storage;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

final class GlobMatcher {
    private final String glob;
    private final Pattern pattern;
    private static final String regexMetaChars = ".^$+{[]|()";
    private static final String globMetaChars = "\\*?[{";

    GlobMatcher(String glob) {
        this.glob = glob;
        boolean inGroup = false;
        StringBuilder regex = new StringBuilder("^");
        int i = 0;
        block10: while (i < glob.length()) {
            char c = glob.charAt(i++);
            switch (c) {
                case '\\': {
                    char next;
                    if (i == glob.length()) {
                        throw new PatternSyntaxException("No character to escape", glob, i - 1);
                    }
                    if (GlobMatcher.isGlobMeta(next = glob.charAt(i++)) || GlobMatcher.isRegexMeta(next)) {
                        regex.append('\\');
                    }
                    regex.append(next);
                    continue block10;
                }
                case '/': {
                    regex.append(c);
                    continue block10;
                }
                case '[': {
                    regex.append("[[^/]&&[");
                    if (GlobMatcher.next(glob, i) == '^') {
                        regex.append("\\^");
                        ++i;
                    } else {
                        if (GlobMatcher.next(glob, i) == '!') {
                            regex.append('^');
                            ++i;
                        }
                        if (GlobMatcher.next(glob, i) == '-') {
                            regex.append('-');
                            ++i;
                        }
                    }
                    boolean hasRangeStart = false;
                    char last = '\u0000';
                    while (i < glob.length() && (c = glob.charAt(i++)) != ']') {
                        if (c == '/') {
                            throw new PatternSyntaxException("Explicit 'name separator' in class", glob, i - 1);
                        }
                        if (c == '\\' || c == '[' || c == '&' && GlobMatcher.next(glob, i) == '&') {
                            regex.append('\\');
                        }
                        regex.append(c);
                        if (c == '-') {
                            if (!hasRangeStart) {
                                throw new PatternSyntaxException("Invalid range", glob, i - 1);
                            }
                            if ((c = GlobMatcher.next(glob, i++)) == '\u0000' || c == ']') break;
                            if (c < last) {
                                throw new PatternSyntaxException("Invalid range", glob, i - 3);
                            }
                            regex.append(c);
                            hasRangeStart = false;
                            continue;
                        }
                        hasRangeStart = true;
                        last = c;
                    }
                    if (c != ']') {
                        throw new PatternSyntaxException("Missing ']", glob, i - 1);
                    }
                    regex.append("]]");
                    continue block10;
                }
                case '{': {
                    if (inGroup) {
                        throw new PatternSyntaxException("Cannot nest groups", glob, i - 1);
                    }
                    regex.append("(?:(?:");
                    inGroup = true;
                    continue block10;
                }
                case '}': {
                    if (inGroup) {
                        regex.append("))");
                        inGroup = false;
                        continue block10;
                    }
                    regex.append('}');
                    continue block10;
                }
                case ',': {
                    if (inGroup) {
                        regex.append(")|(?:");
                        continue block10;
                    }
                    regex.append(',');
                    continue block10;
                }
                case '*': {
                    if (GlobMatcher.next(glob, i) == '*') {
                        regex.append(".*");
                        ++i;
                        continue block10;
                    }
                    regex.append("[^/]*");
                    continue block10;
                }
                case '?': {
                    regex.append("[^/]");
                    continue block10;
                }
            }
            if (GlobMatcher.isRegexMeta(c)) {
                regex.append('\\');
            }
            regex.append(c);
        }
        if (inGroup) {
            throw new PatternSyntaxException("Missing '}", glob, i - 1);
        }
        regex.append('$');
        this.pattern = Pattern.compile(regex.toString(), 66);
    }

    boolean matches(String path) {
        return this.pattern.matcher(path).matches();
    }

    public String toString() {
        return "glob: " + this.glob + "\nregex: " + this.pattern.toString();
    }

    private static boolean isRegexMeta(char c) {
        return regexMetaChars.indexOf(c) != -1;
    }

    private static boolean isGlobMeta(char c) {
        return globMetaChars.indexOf(c) != -1;
    }

    private static char next(String glob, int i) {
        if (i < glob.length()) {
            return glob.charAt(i);
        }
        return '\u0000';
    }
}

