/*
 * Decompiled with CFR 0.152.
 */
package org.cubeengine.reflect.codec.hocon;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.cubeengine.converter.ConversionException;
import org.cubeengine.converter.node.ListNode;
import org.cubeengine.converter.node.MapNode;
import org.cubeengine.converter.node.Node;
import org.cubeengine.reflect.Reflected;
import org.cubeengine.reflect.codec.ReaderWriterFileCodec;

public class HoconCodec
extends ReaderWriterFileCodec {
    public String getExtension() {
        return "conf";
    }

    protected MapNode load(Reader in, Reflected reflected) throws ConversionException {
        if (in == null) {
            return MapNode.emptyMap();
        }
        Config config = ConfigFactory.parseReader((Reader)in);
        if (config.isEmpty()) {
            return MapNode.emptyMap();
        }
        return (MapNode)this.getConverterManager().convertToNode((Object)config.root().unwrapped());
    }

    protected void save(MapNode node, Writer writer, Reflected reflected) throws ConversionException {
        Config config = ConfigFactory.parseMap(this.getHoconMap(node));
        try {
            writer.append(config.root().render());
        }
        catch (IOException ex) {
            throw ConversionException.of((Object)((Object)this), null, (String)"Could not write", (Throwable)ex);
        }
    }

    private Map<String, Object> getHoconMap(MapNode node) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.buildHoconMap(map, "", (Node)node);
        return map;
    }

    private void buildHoconMap(Map<String, Object> map, String path, Node node) {
        if (node instanceof MapNode) {
            if (((MapNode)node).isEmpty()) {
                map.put(path, new LinkedHashMap());
            } else {
                for (Map.Entry entry : ((MapNode)node).getMappedNodes().entrySet()) {
                    this.buildHoconMap(map, path + ("".equals(path) ? "" : ".") + (String)entry.getKey(), (Node)entry.getValue());
                }
            }
        } else if (node instanceof ListNode) {
            map.put(path, this.getHoconList((ListNode)node));
        } else {
            map.put(path, node.getValue());
        }
    }

    protected List<Object> getHoconList(ListNode listNode) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Node node : listNode.getValue()) {
            if (node instanceof MapNode) {
                list.add(this.getHoconMap((MapNode)node));
                continue;
            }
            if (node instanceof ListNode) {
                list.add(this.getHoconList((ListNode)node));
                continue;
            }
            list.add(node.getValue());
        }
        return list;
    }
}

