/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.linux.keychain;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.integrations.keychain.KeychainAccessProvider;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusConnectionException;
import org.freedesktop.dbus.exceptions.DBusException;
import org.kde.KWallet;
import org.purejava.KDEWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=900)
@OperatingSystem(value=OperatingSystem.Value.LINUX)
public class KDEWalletKeychainAccess
implements KeychainAccessProvider {
    private static final Logger LOG = LoggerFactory.getLogger(KDEWalletKeychainAccess.class);
    private static final String FOLDER_NAME = "Cryptomator";
    private static final String APP_NAME = "Cryptomator";
    private final Optional<ConnectedWallet> wallet = ConnectedWallet.connect();

    public String displayName() {
        return "KDE Wallet";
    }

    public boolean isSupported() {
        return this.wallet.map(ConnectedWallet::isSupported).orElse(false);
    }

    public boolean isLocked() {
        return this.wallet.map(ConnectedWallet::isLocked).orElse(false);
    }

    public void storePassphrase(String key, String displayName, CharSequence passphrase) throws KeychainAccessException {
        Preconditions.checkState((boolean)this.wallet.isPresent(), (Object)"Keychain not supported.");
        this.wallet.get().storePassphrase(key, passphrase);
    }

    public char[] loadPassphrase(String key) throws KeychainAccessException {
        Preconditions.checkState((boolean)this.wallet.isPresent(), (Object)"Keychain not supported.");
        return this.wallet.get().loadPassphrase(key);
    }

    public void deletePassphrase(String key) throws KeychainAccessException {
        Preconditions.checkState((boolean)this.wallet.isPresent(), (Object)"Keychain not supported.");
        this.wallet.get().deletePassphrase(key);
    }

    public void changePassphrase(String key, String displayName, CharSequence passphrase) throws KeychainAccessException {
        Preconditions.checkState((boolean)this.wallet.isPresent(), (Object)"Keychain not supported.");
        this.wallet.get().changePassphrase(key, passphrase);
    }

    private static class ConnectedWallet {
        private final KDEWallet wallet;
        private int handle = -1;

        public ConnectedWallet(DBusConnection connection) {
            this.wallet = new KDEWallet(connection);
        }

        static Optional<ConnectedWallet> connect() {
            try {
                return Optional.of(new ConnectedWallet(ConnectedWallet.getNewConnection()));
            }
            catch (DBusException e) {
                LOG.warn("Connecting to D-Bus failed.", (Throwable)e);
                return Optional.empty();
            }
        }

        private static DBusConnection getNewConnection() throws DBusException {
            try {
                return DBusConnection.newConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SESSION);
            }
            catch (DBusConnectionException ce) {
                LOG.warn("SESSION DBus not found, falling back to SYSTEM DBus");
                return DBusConnection.newConnection((DBusConnection.DBusBusType)DBusConnection.DBusBusType.SYSTEM);
            }
        }

        public boolean isSupported() {
            try {
                return this.wallet.isEnabled();
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to check if KDE Wallet is available.", (Throwable)e);
                return false;
            }
        }

        public boolean isLocked() {
            try {
                return !this.wallet.isOpen("kdewallet");
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to check whether KDE Wallet is open, therefore considering it closed.", (Throwable)e);
                return true;
            }
        }

        public void storePassphrase(String key, CharSequence passphrase) throws KeychainAccessException {
            try {
                if (this.walletIsOpen() && (!this.wallet.hasEntry(this.handle, "Cryptomator", key, "Cryptomator") || this.wallet.entryType(this.handle, "Cryptomator", key, "Cryptomator") != 1) && this.wallet.writePassword(this.handle, "Cryptomator", key, passphrase.toString(), "Cryptomator") == 0) {
                    LOG.debug("Passphrase successfully stored.");
                } else {
                    LOG.debug("Passphrase was not stored.");
                }
            }
            catch (RuntimeException e) {
                throw new KeychainAccessException("Storing the passphrase failed.", (Throwable)e);
            }
        }

        public char[] loadPassphrase(String key) throws KeychainAccessException {
            String password = "";
            try {
                if (this.walletIsOpen()) {
                    password = this.wallet.readPassword(this.handle, "Cryptomator", key, "Cryptomator");
                    LOG.debug("loadPassphrase: wallet is open.");
                } else {
                    LOG.debug("loadPassphrase: wallet is closed.");
                }
                return password.equals("") ? null : password.toCharArray();
            }
            catch (RuntimeException e) {
                throw new KeychainAccessException("Loading the passphrase failed.", (Throwable)e);
            }
        }

        public void deletePassphrase(String key) throws KeychainAccessException {
            try {
                if (this.walletIsOpen() && this.wallet.hasEntry(this.handle, "Cryptomator", key, "Cryptomator") && this.wallet.entryType(this.handle, "Cryptomator", key, "Cryptomator") == 1 && this.wallet.removeEntry(this.handle, "Cryptomator", key, "Cryptomator") == 0) {
                    LOG.debug("Passphrase successfully deleted.");
                } else {
                    LOG.debug("Passphrase was not deleted.");
                }
            }
            catch (RuntimeException e) {
                throw new KeychainAccessException("Deleting the passphrase failed.", (Throwable)e);
            }
        }

        public void changePassphrase(String key, CharSequence passphrase) throws KeychainAccessException {
            try {
                if (this.walletIsOpen() && this.wallet.hasEntry(this.handle, "Cryptomator", key, "Cryptomator") && this.wallet.entryType(this.handle, "Cryptomator", key, "Cryptomator") == 1 && this.wallet.writePassword(this.handle, "Cryptomator", key, passphrase.toString(), "Cryptomator") == 0) {
                    LOG.debug("Passphrase successfully changed.");
                } else {
                    LOG.debug("Passphrase could not be changed.");
                }
            }
            catch (RuntimeException e) {
                throw new KeychainAccessException("Changing the passphrase failed.", (Throwable)e);
            }
        }

        private boolean walletIsOpen() throws KeychainAccessException {
            try {
                if (this.wallet.isOpen("kdewallet")) {
                    if (this.handle == -1) {
                        this.handle = this.wallet.open("kdewallet", 0L, "Cryptomator");
                    }
                    return true;
                }
                this.wallet.openAsync("kdewallet", 0L, "Cryptomator", false);
                this.wallet.getSignalHandler().await(KWallet.walletAsyncOpened.class, "/modules/kwalletd5", () -> null);
                this.handle = ((KWallet.walletAsyncOpened)this.wallet.getSignalHandler().getLastHandledSignal(KWallet.walletAsyncOpened.class, (String)"/modules/kwalletd5")).handle;
                LOG.debug("Wallet successfully initialized.");
                return this.handle != -1;
            }
            catch (RuntimeException e) {
                throw new KeychainAccessException("Asynchronous opening the wallet failed.", (Throwable)e);
            }
        }
    }
}

