/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.mount;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import org.cryptomator.frontend.fuse.FuseNioAdapter;
import org.cryptomator.frontend.fuse.mount.FuseMountException;
import org.cryptomator.frontend.fuse.mount.Mount;
import org.cryptomator.frontend.fuse.mount.Revealer;

abstract class AbstractMount
implements Mount {
    protected final FuseNioAdapter fuseAdapter;
    protected final Path mountPoint;

    public AbstractMount(FuseNioAdapter fuseAdapter, Path mountPoint) {
        Preconditions.checkArgument((boolean)fuseAdapter.isMounted());
        this.fuseAdapter = fuseAdapter;
        this.mountPoint = mountPoint;
    }

    @Override
    public Path getMountPoint() {
        Preconditions.checkState((boolean)this.fuseAdapter.isMounted(), (Object)"Not currently mounted.");
        return this.mountPoint;
    }

    @Override
    public void reveal(Revealer revealer) throws Exception {
        revealer.reveal(this.mountPoint);
    }

    @Override
    public void unmount() throws FuseMountException {
        if (this.fuseAdapter.isInUse()) {
            throw new FuseMountException("Unmount refused: There are open files or pending operations.");
        }
        this.unmountInternal();
    }

    @Override
    public void unmountForced() throws FuseMountException {
        this.unmountForcedInternal();
    }

    protected abstract void unmountInternal() throws FuseMountException;

    protected abstract void unmountForcedInternal() throws FuseMountException;

    @Override
    public void close() throws FuseMountException {
        if (this.fuseAdapter.isMounted()) {
            throw new IllegalStateException("Can not close file system adapter while still mounted.");
        }
        try {
            this.fuseAdapter.close();
        }
        catch (Exception e) {
            throw new FuseMountException(e);
        }
    }
}

