/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.locks;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Function;
import org.cryptomator.frontend.fuse.locks.DataLock;
import org.cryptomator.frontend.fuse.locks.DataRLockImpl;
import org.cryptomator.frontend.fuse.locks.DataWLockImpl;
import org.cryptomator.frontend.fuse.locks.PathLock;

abstract class PathLockImpl
implements PathLock {
    protected final List<String> pathComponents;
    protected final Optional<PathLock> parent;
    protected final ReadWriteLock lock;
    private final Function<List<String>, ReadWriteLock> dataLockSupplier;

    protected PathLockImpl(List<String> pathComponents, Optional<PathLock> parent, ReadWriteLock lock, Function<List<String>, ReadWriteLock> dataLockSupplier) {
        this.pathComponents = pathComponents;
        this.parent = parent;
        this.lock = lock;
        this.dataLockSupplier = dataLockSupplier;
    }

    @Override
    public void close() {
        this.parent.ifPresent(PathLock::close);
    }

    @Override
    public DataLock lockDataForReading() {
        ReadWriteLock dataLock = this.dataLockSupplier.apply(this.pathComponents);
        return DataRLockImpl.create(this.pathComponents, dataLock);
    }

    @Override
    public DataLock lockDataForWriting() {
        ReadWriteLock dataLock = this.dataLockSupplier.apply(this.pathComponents);
        return DataWLockImpl.create(this.pathComponents, dataLock);
    }
}

