/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import javax.inject.Inject;
import org.cryptomator.frontend.fuse.FileAttributesUtil;
import org.cryptomator.frontend.fuse.FileNameTranscoder;
import org.cryptomator.frontend.fuse.PerAdapter;
import org.cryptomator.frontend.fuse.ReadOnlyDirectoryHandler;
import ru.serce.jnrfuse.struct.FileStat;

@PerAdapter
public class ReadWriteDirectoryHandler
extends ReadOnlyDirectoryHandler {
    @Inject
    public ReadWriteDirectoryHandler(FileAttributesUtil attrUtil, FileNameTranscoder fileNameTranscoder) {
        super(attrUtil, fileNameTranscoder);
    }

    @Override
    public int getattr(Path node, BasicFileAttributes attrs, FileStat stat) {
        int result = super.getattr(node, attrs, stat);
        if (attrs instanceof PosixFileAttributes) {
            PosixFileAttributes posixAttrs = (PosixFileAttributes)attrs;
            long mode = this.attrUtil.posixPermissionsToOctalMode(posixAttrs.permissions());
            stat.st_mode.set((Number)(0x4000L | mode));
        } else {
            stat.st_mode.set((Number)16877);
        }
        return result;
    }
}

