/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.ecies;

import com.google.common.base.Throwables;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.GCMParameterSpec;
import org.cryptomator.cryptolib.common.CipherSupplier;
import org.cryptomator.cryptolib.common.DestroyableSecretKey;
import org.cryptomator.cryptolib.ecies.AuthenticatedEncryption;

class GcmWithSecretNonce
implements AuthenticatedEncryption {
    private static final int GCM_KEY_SIZE = 32;
    private static final int GCM_TAG_SIZE = 16;
    private static final int GCM_NONCE_SIZE = 12;

    GcmWithSecretNonce() {
    }

    @Override
    public int requiredSecretBytes() {
        return 44;
    }

    @Override
    public byte[] encrypt(byte[] secret, byte[] plaintext) {
        DestroyableSecretKey key = new DestroyableSecretKey(secret, 0, 32, "AES");
        try {
            byte[] nonce = Arrays.copyOfRange(secret, 32, 44);
            Cipher cipher = CipherSupplier.AES_GCM.forEncryption(key, new GCMParameterSpec(128, nonce));
            byte[] byArray = cipher.doFinal(plaintext);
            key.close();
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    key.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                throw new IllegalStateException("Unexpected exception during GCM decryption.", e);
            }
        }
    }

    @Override
    public byte[] decrypt(byte[] secret, byte[] ciphertext) throws AEADBadTagException {
        DestroyableSecretKey key = new DestroyableSecretKey(secret, 0, 32, "AES");
        try {
            byte[] nonce = Arrays.copyOfRange(secret, 32, 44);
            Cipher cipher = CipherSupplier.AES_GCM.forDecryption(key, new GCMParameterSpec(128, nonce));
            byte[] byArray = cipher.doFinal(ciphertext);
            key.close();
            return byArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    key.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (BadPaddingException | IllegalBlockSizeException e) {
                Throwables.throwIfInstanceOf((Throwable)e, AEADBadTagException.class);
                throw new IllegalStateException("Unexpected exception during GCM decryption.", e);
            }
        }
    }
}

