/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;
import org.cryptomator.cryptolib.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.cryptomator.cryptolib.org.bouncycastle.asn1.x500.X500Name;
import org.cryptomator.cryptolib.org.bouncycastle.cert.CertIOException;
import org.cryptomator.cryptolib.org.bouncycastle.cert.X509CertificateHolder;
import org.cryptomator.cryptolib.org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.cryptomator.cryptolib.org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.cryptomator.cryptolib.org.bouncycastle.operator.ContentSigner;
import org.cryptomator.cryptolib.org.bouncycastle.operator.OperatorCreationException;
import org.cryptomator.cryptolib.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class X509CertBuilder {
    private static final ASN1ObjectIdentifier ASN1_SUBJECT_KEY_ID = new ASN1ObjectIdentifier("2.5.29.14");
    private final KeyPair keyPair;
    private final ContentSigner signer;
    private X500Name issuer;
    private X500Name subject;
    private Date notBefore;
    private Date notAfter;

    private X509CertBuilder(KeyPair keyPair, ContentSigner signer) {
        this.keyPair = keyPair;
        this.signer = signer;
    }

    static X509CertBuilder init(KeyPair keyPair, String signatureAlg) {
        try {
            ContentSigner signer = new JcaContentSignerBuilder(signatureAlg).build(keyPair.getPrivate());
            return new X509CertBuilder(keyPair, signer);
        }
        catch (OperatorCreationException e) {
            throw new IllegalArgumentException("Invalid signature algorithm / key combination", e);
        }
    }

    public X509CertBuilder withIssuer(String issuer) {
        this.issuer = new X500Name(issuer);
        return this;
    }

    public X509CertBuilder withSubject(String subject) {
        this.subject = new X500Name(subject);
        return this;
    }

    public X509CertBuilder withNotBefore(Instant notBefore) {
        this.notBefore = Date.from(notBefore);
        return this;
    }

    public X509CertBuilder withNotAfter(Instant notAfter) {
        this.notAfter = Date.from(notAfter);
        return this;
    }

    private void validate() throws IllegalStateException {
        Preconditions.checkState((this.issuer != null ? 1 : 0) != 0, (Object)"issuer not set");
        Preconditions.checkState((this.subject != null ? 1 : 0) != 0, (Object)"subject not set");
        Preconditions.checkState((this.notBefore != null ? 1 : 0) != 0, (Object)"notBefore not set");
        Preconditions.checkState((this.notAfter != null ? 1 : 0) != 0, (Object)"notAfter not set");
        Preconditions.checkState((this.notBefore.compareTo(this.notAfter) < 0 ? 1 : 0) != 0, (Object)"notBefore must be before notAfter");
    }

    public X509Certificate build() throws CertificateException, IllegalStateException {
        X509Certificate x509Certificate;
        this.validate();
        ByteArrayInputStream in = new ByteArrayInputStream(this.buildCertHolder().getEncoded());
        try {
            x509Certificate = (X509Certificate)X509CertBuilder.getCertFactory().generateCertificate(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CertificateException(e);
            }
        }
        ((InputStream)in).close();
        return x509Certificate;
    }

    private X509CertificateHolder buildCertHolder() throws CertIOException {
        JcaX509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(this.issuer, X509CertBuilder.randomSerialNo(), this.notBefore, this.notAfter, this.subject, this.keyPair.getPublic());
        certificateBuilder.addExtension(ASN1_SUBJECT_KEY_ID, false, X509CertBuilder.getX509ExtensionUtils().createSubjectKeyIdentifier(this.keyPair.getPublic()));
        return certificateBuilder.build(this.signer);
    }

    private static BigInteger randomSerialNo() {
        return BigInteger.valueOf(UUID.randomUUID().getMostSignificantBits());
    }

    private static JcaX509ExtensionUtils getX509ExtensionUtils() {
        try {
            return new JcaX509ExtensionUtils();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Every implementation of the Java platform is required to support SHA-1.");
        }
    }

    private static CertificateFactory getCertFactory() {
        try {
            return CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Every implementation of the Java platform is required to support X.509.");
        }
    }
}

