/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.api;

import java.nio.file.Path;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.cryptofs.health.api.PoisonResult;
import org.cryptomator.cryptofs.health.api.TransferSpliterator;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.Masterkey;
import org.slf4j.LoggerFactory;

public interface HealthCheck {
    public static Collection<HealthCheck> allChecks() {
        return ServiceLoader.load(HealthCheck.class).stream().map(ServiceLoader.Provider::get).toList();
    }

    default public String name() {
        String canonicalName = this.getClass().getCanonicalName();
        return canonicalName.substring(canonicalName.lastIndexOf(46) + 1);
    }

    public void check(Path var1, VaultConfig var2, Masterkey var3, Cryptor var4, Consumer<DiagnosticResult> var5);

    default public Stream<DiagnosticResult> check(Path pathToVault, VaultConfig config, Masterkey masterkey, Cryptor cryptor, ExecutorService executor) {
        TransferSpliterator<PoisonResult> resultSpliterator = new TransferSpliterator<PoisonResult>(new PoisonResult());
        Future<?> task = executor.submit(() -> {
            try {
                this.check(pathToVault, config, masterkey, cryptor, resultSpliterator);
            }
            catch (TransferSpliterator.TransferClosedException e) {
                LoggerFactory.getLogger(HealthCheck.class).debug("{} cancelled.", (Object)this.name());
            }
            finally {
                resultSpliterator.close();
            }
        });
        return (Stream)StreamSupport.stream(resultSpliterator, false).onClose(() -> task.cancel(true));
    }
}

