/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.fh;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.cryptomator.cryptofs.fh.CurrentOpenFilePath;
import org.cryptomator.cryptofs.fh.OpenFileScoped;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OpenFileScoped
public class FileHeaderHolder {
    private static final Logger LOG = LoggerFactory.getLogger(FileHeaderHolder.class);
    private final Cryptor cryptor;
    private final AtomicReference<Path> path;
    private final AtomicReference<FileHeader> header = new AtomicReference();
    private final AtomicReference<ByteBuffer> encryptedHeader = new AtomicReference();
    private final AtomicBoolean isPersisted = new AtomicBoolean();

    @Inject
    public FileHeaderHolder(Cryptor cryptor, @CurrentOpenFilePath AtomicReference<Path> path) {
        this.cryptor = cryptor;
        this.path = path;
    }

    public FileHeader get() {
        FileHeader result = this.header.get();
        if (result == null) {
            throw new IllegalStateException("Header not set.");
        }
        return result;
    }

    public ByteBuffer getEncrypted() {
        ByteBuffer result = this.encryptedHeader.get();
        if (result == null) {
            throw new IllegalStateException("Header not set.");
        }
        return result;
    }

    FileHeader createNew() {
        LOG.trace("Generating file header for {}", (Object)this.path.get());
        FileHeader newHeader = this.cryptor.fileHeaderCryptor().create();
        this.encryptedHeader.set(this.cryptor.fileHeaderCryptor().encryptHeader(newHeader).asReadOnlyBuffer());
        this.header.set(newHeader);
        return newHeader;
    }

    FileHeader loadExisting(FileChannel ch) throws IOException {
        LOG.trace("Reading file header from {}", (Object)this.path.get());
        ByteBuffer existingHeaderBuf = ByteBuffer.allocate(this.cryptor.fileHeaderCryptor().headerSize());
        ch.read(existingHeaderBuf, 0L);
        existingHeaderBuf.flip();
        try {
            FileHeader existingHeader = this.cryptor.fileHeaderCryptor().decryptHeader(existingHeaderBuf);
            this.encryptedHeader.set(existingHeaderBuf.flip().asReadOnlyBuffer());
            this.header.set(existingHeader);
            this.isPersisted.set(true);
            return existingHeader;
        }
        catch (IllegalArgumentException | CryptoException e) {
            throw new IOException("Unable to decrypt header of file " + String.valueOf(this.path.get()), e);
        }
    }

    public AtomicBoolean headerIsPersisted() {
        return this.isPersisted;
    }
}

