/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.attr;

import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.UserPrincipal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.attr.AttributeProvider;
import org.cryptomator.cryptofs.attr.AttributeViewProvider;

@CryptoFileSystemScoped
public class AttributeByNameProvider {
    private static final SortedMap<String, AttrGetter<?>> GETTERS = ImmutableSortedMap.naturalOrder().put((Object)"basic:lastModifiedTime", new AttrGetter<BasicFileAttributes>("lastModifiedTime", BasicFileAttributes.class, BasicFileAttributes::lastModifiedTime)).put((Object)"basic:lastAccessTime", new AttrGetter<BasicFileAttributes>("lastAccessTime", BasicFileAttributes.class, BasicFileAttributes::lastAccessTime)).put((Object)"basic:creationTime", new AttrGetter<BasicFileAttributes>("creationTime", BasicFileAttributes.class, BasicFileAttributes::creationTime)).put((Object)"basic:isRegularFile", new AttrGetter<BasicFileAttributes>("isRegularFile", BasicFileAttributes.class, BasicFileAttributes::isRegularFile)).put((Object)"basic:isDirectory", new AttrGetter<BasicFileAttributes>("isDirectory", BasicFileAttributes.class, BasicFileAttributes::isDirectory)).put((Object)"basic:isSymbolicLink", new AttrGetter<BasicFileAttributes>("isSymbolicLink", BasicFileAttributes.class, BasicFileAttributes::isSymbolicLink)).put((Object)"basic:isOther", new AttrGetter<BasicFileAttributes>("isOther", BasicFileAttributes.class, BasicFileAttributes::isOther)).put((Object)"basic:size", new AttrGetter<BasicFileAttributes>("size", BasicFileAttributes.class, BasicFileAttributes::size)).put((Object)"basic:fileKey", new AttrGetter<BasicFileAttributes>("fileKey", BasicFileAttributes.class, BasicFileAttributes::fileKey)).put((Object)"dos:readOnly", new AttrGetter<DosFileAttributes>("readOnly", DosFileAttributes.class, DosFileAttributes::isReadOnly)).put((Object)"dos:hidden", new AttrGetter<DosFileAttributes>("hidden", DosFileAttributes.class, DosFileAttributes::isHidden)).put((Object)"dos:archive", new AttrGetter<DosFileAttributes>("archive", DosFileAttributes.class, DosFileAttributes::isArchive)).put((Object)"dos:system", new AttrGetter<DosFileAttributes>("system", DosFileAttributes.class, DosFileAttributes::isSystem)).put((Object)"posix:owner", new AttrGetter<PosixFileAttributes>("owner", PosixFileAttributes.class, PosixFileAttributes::owner)).put((Object)"posix:group", new AttrGetter<PosixFileAttributes>("group", PosixFileAttributes.class, PosixFileAttributes::group)).put((Object)"posix:permissions", new AttrGetter<PosixFileAttributes>("permissions", PosixFileAttributes.class, PosixFileAttributes::permissions)).build();
    private static final Map<String, AttrSetter<?, ?>> SETTERS = Map.of("basic:lastModifiedTime", new AttrSetter<BasicFileAttributeView, FileTime>(BasicFileAttributeView.class, FileTime.class, (view, lastModifiedTime) -> view.setTimes((FileTime)lastModifiedTime, null, null)), "basic:lastAccessTime", new AttrSetter<BasicFileAttributeView, FileTime>(BasicFileAttributeView.class, FileTime.class, (view, lastAccessTime) -> view.setTimes(null, (FileTime)lastAccessTime, null)), "basic:creationTime", new AttrSetter<BasicFileAttributeView, FileTime>(BasicFileAttributeView.class, FileTime.class, (view, creationTime) -> view.setTimes(null, null, (FileTime)creationTime)), "dos:readOnly", new AttrSetter<DosFileAttributeView, Boolean>(DosFileAttributeView.class, Boolean.class, DosFileAttributeView::setReadOnly), "dos:hidden", new AttrSetter<DosFileAttributeView, Boolean>(DosFileAttributeView.class, Boolean.class, DosFileAttributeView::setHidden), "dos:archive", new AttrSetter<DosFileAttributeView, Boolean>(DosFileAttributeView.class, Boolean.class, DosFileAttributeView::setArchive), "dos:system", new AttrSetter<DosFileAttributeView, Boolean>(DosFileAttributeView.class, Boolean.class, DosFileAttributeView::setSystem), "posix:owner", new AttrSetter<PosixFileAttributeView, UserPrincipal>(PosixFileAttributeView.class, UserPrincipal.class, FileOwnerAttributeView::setOwner), "posix:group", new AttrSetter<PosixFileAttributeView, GroupPrincipal>(PosixFileAttributeView.class, GroupPrincipal.class, PosixFileAttributeView::setGroup), "posix:permissions", new AttrSetter<PosixFileAttributeView, Set>(PosixFileAttributeView.class, Set.class, PosixFileAttributeView::setPermissions));
    private final AttributeProvider attributeProvider;
    private final AttributeViewProvider attributeViewProvider;

    @Inject
    AttributeByNameProvider(AttributeProvider attributeProvider, AttributeViewProvider attributeViewProvider) {
        this.attributeProvider = attributeProvider;
        this.attributeViewProvider = attributeViewProvider;
    }

    public void setAttribute(CryptoPath cleartextPath, String attributeName, Object value, LinkOption ... options) throws IOException {
        String normalizedAttributeName = this.normalizedAttributeName(attributeName);
        AttrSetter<?, ?> setter = SETTERS.get(normalizedAttributeName);
        if (setter == null) {
            throw new IllegalArgumentException("Unrecognized attribute name: " + attributeName);
        }
        setter.set(this.attributeViewProvider, cleartextPath, value, options);
    }

    public Map<String, Object> readAttributes(CryptoPath cleartextPath, String attributesString, LinkOption ... options) throws IOException {
        if (attributesString.isEmpty()) {
            throw new IllegalArgumentException("No attributes specified");
        }
        Predicate<String> getterNameFilter = this.getterNameFilter(attributesString);
        List<AttrGetter<?>> getters = GETTERS.entrySet().stream().filter(entry -> getterNameFilter.test((String)entry.getKey())).map(Map.Entry::getValue).toList();
        return this.readAttributes(cleartextPath, getters, options);
    }

    private Map<String, Object> readAttributes(CryptoPath cleartextPath, Collection<AttrGetter<?>> getters, LinkOption ... options) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BasicFileAttributes attributes = null;
        for (AttrGetter<?> getter : getters) {
            if (attributes == null) {
                attributes = (BasicFileAttributes)this.attributeProvider.readAttributes(cleartextPath, getter.type, options);
            }
            String key = getter.name;
            Object value = getter.get(attributes);
            result.put(key, value);
        }
        return result;
    }

    private String normalizedAttributeName(String attributeName) {
        if (attributeName.indexOf(58) == -1) {
            return "basic:" + attributeName;
        }
        return attributeName;
    }

    private Predicate<String> getterNameFilter(String attributesString) {
        String viewName = this.viewName(attributesString);
        Set<String> attributeNames = this.attributeNames(viewName, attributesString);
        if (attributeNames.contains("*")) {
            String prefix = viewName + ":";
            return value -> value.startsWith(prefix);
        }
        return attributeNames::contains;
    }

    private String viewName(String attributes) {
        int firstColon = attributes.indexOf(58);
        if (firstColon == -1) {
            return "basic";
        }
        return attributes.substring(0, firstColon);
    }

    private Set<String> attributeNames(String viewName, String attributeString) {
        int firstColon = attributeString.indexOf(58);
        String attributeNames = firstColon == -1 ? attributeString : attributeString.substring(firstColon + 1);
        return Arrays.stream(attributeNames.split(",")).map(name -> {
            if ("*".equals(name)) {
                return "*";
            }
            return viewName + ":" + name;
        }).collect(Collectors.toSet());
    }

    private static class AttrSetter<T extends FileAttributeView, V> {
        private final Class<T> type;
        private final Class<V> valueType;
        private final Setter<T, V> setter;

        public AttrSetter(Class<T> type, Class<V> valueType, Setter<T, V> setter) {
            this.type = type;
            this.valueType = valueType;
            this.setter = setter;
        }

        public void set(AttributeViewProvider provider, CryptoPath cleartextPath, Object value, LinkOption ... options) throws IOException {
            T attrs = provider.getAttributeView(cleartextPath, this.type, options);
            this.setter.set(attrs, this.valueType.cast(value));
        }

        @FunctionalInterface
        static interface Setter<T extends FileAttributeView, V> {
            public void set(T var1, V var2) throws IOException;
        }
    }

    private static class AttrGetter<T extends BasicFileAttributes> {
        private final String name;
        private final Class<T> type;
        private final Function<T, Object> getter;

        public AttrGetter(String name, Class<T> type, Function<T, Object> getter) {
            this.name = name;
            this.type = type;
            this.getter = getter;
        }

        public Object get(BasicFileAttributes attrs) {
            return this.getter.apply((BasicFileAttributes)this.type.cast(attrs));
        }
    }
}

