/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.google.common.base.Splitter;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemImpl;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.Symlinks;

@CryptoFileSystemScoped
class CryptoPathFactory {
    private final Symlinks symlinks;

    @Inject
    public CryptoPathFactory(Symlinks symlinks) {
        this.symlinks = symlinks;
    }

    public CryptoPath getPath(CryptoFileSystemImpl fileSystem, String first, String ... more) {
        boolean isAbsolute = first.startsWith("/");
        Stream<String> elements = Stream.concat(Stream.of(first), Arrays.stream(more)).flatMap(this::splitPath).map(this::normalize);
        return new CryptoPath(fileSystem, this.symlinks, elements.toList(), isAbsolute);
    }

    public CryptoPath emptyFor(CryptoFileSystemImpl fileSystem) {
        return new CryptoPath(fileSystem, this.symlinks, Collections.emptyList(), false);
    }

    public CryptoPath rootFor(CryptoFileSystemImpl fileSystem) {
        return new CryptoPath(fileSystem, this.symlinks, Collections.emptyList(), true);
    }

    private Stream<String> splitPath(String path) {
        Iterable tokens = Splitter.on((String)"/").omitEmptyStrings().split((CharSequence)path);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(tokens.iterator(), 1296), false);
    }

    private String normalize(String str) {
        return Normalizer.normalize(str, Normalizer.Form.NFC);
    }
}

