/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.cryptomator.cryptofs.CiphertextDirectory;
import org.cryptomator.cryptofs.CryptoPath;

public class CiphertextDirCache {
    private static final int MAX_CACHED_PATHS = 5000;
    private static final Duration MAX_CACHE_AGE = Duration.ofSeconds(20L);
    private final AsyncCache<CryptoPath, CiphertextDirectory> ciphertextDirectories = Caffeine.newBuilder().maximumSize(5000L).expireAfterWrite(MAX_CACHE_AGE).buildAsync();

    void removeAllKeysWithPrefix(CryptoPath basePrefix) {
        this.ciphertextDirectories.asMap().keySet().removeIf(p -> p.startsWith(basePrefix));
    }

    void recomputeAllKeysWithPrefix(CryptoPath oldPrefix, CryptoPath newPrefix) {
        ArrayList<CacheEntry> remappedEntries = new ArrayList<CacheEntry>();
        this.ciphertextDirectories.asMap().entrySet().removeIf(e -> {
            if (((CryptoPath)e.getKey()).startsWith(oldPrefix)) {
                CryptoPath remappedPath = newPrefix.resolve(oldPrefix.relativize((Path)e.getKey()));
                return remappedEntries.add(new CacheEntry(remappedPath, (CompletableFuture)e.getValue()));
            }
            return false;
        });
        remappedEntries.forEach(e -> this.ciphertextDirectories.put((Object)e.clearPath(), e.cipherDir()));
    }

    CiphertextDirectory get(CryptoPath cleartextPath, CipherDirLoader ifAbsent) throws IOException {
        CompletableFuture<CiphertextDirectory> futureMapping = new CompletableFuture<CiphertextDirectory>();
        CompletableFuture currentMapping = this.ciphertextDirectories.asMap().putIfAbsent(cleartextPath, futureMapping);
        if (currentMapping != null) {
            return (CiphertextDirectory)currentMapping.join();
        }
        futureMapping.complete(ifAbsent.load());
        return (CiphertextDirectory)futureMapping.join();
    }

    @FunctionalInterface
    static interface CipherDirLoader {
        public CiphertextDirectory load() throws IOException;
    }

    private record CacheEntry(CryptoPath clearPath, CompletableFuture<CiphertextDirectory> cipherDir) {
    }
}

