// Generated by Dagger (https://dagger.dev).
package org.cryptomator.cryptofs.migration;

import com.google.common.collect.ImmutableMap;
import dagger.internal.DaggerGenerated;
import dagger.internal.Preconditions;
import java.security.SecureRandom;
import java.util.Map;
import org.cryptomator.cryptofs.migration.api.Migrator;
import org.cryptomator.cryptofs.migration.v6.Version6Migrator;
import org.cryptomator.cryptofs.migration.v7.Version7Migrator;
import org.cryptomator.cryptofs.migration.v8.Version8Migrator;

@DaggerGenerated
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava"
})
final class DaggerMigrationComponent {
  private DaggerMigrationComponent() {
  }

  public static MigrationComponent.Builder builder() {
    return new Builder();
  }

  private static final class Builder implements MigrationComponent.Builder {
    private SecureRandom csprng;

    @Override
    public Builder csprng(SecureRandom csprng) {
      this.csprng = Preconditions.checkNotNull(csprng);
      return this;
    }

    @Override
    public MigrationComponent build() {
      Preconditions.checkBuilderRequirement(csprng, SecureRandom.class);
      return new MigrationComponentImpl(new MigrationModule(), csprng);
    }
  }

  private static final class MigrationComponentImpl implements MigrationComponent {
    private final MigrationModule migrationModule;

    private final SecureRandom csprng;

    private final MigrationComponentImpl migrationComponentImpl = this;

    private MigrationComponentImpl(MigrationModule migrationModuleParam, SecureRandom csprngParam) {
      this.migrationModule = migrationModuleParam;
      this.csprng = csprngParam;

    }

    private Version6Migrator version6Migrator() {
      return new Version6Migrator(csprng);
    }

    private Migrator provideVersion6Migrator() {
      return MigrationModule_ProvideVersion6MigratorFactory.provideVersion6Migrator(migrationModule, version6Migrator());
    }

    private Version7Migrator version7Migrator() {
      return new Version7Migrator(csprng);
    }

    private Migrator provideVersion7Migrator() {
      return MigrationModule_ProvideVersion7MigratorFactory.provideVersion7Migrator(migrationModule, version7Migrator());
    }

    private Version8Migrator version8Migrator() {
      return new Version8Migrator(csprng);
    }

    private Migrator provideVersion8Migrator() {
      return MigrationModule_ProvideVersion8MigratorFactory.provideVersion8Migrator(migrationModule, version8Migrator());
    }

    private Map<Migration, Migrator> mapOfMigrationAndMigrator() {
      return ImmutableMap.<Migration, Migrator>of(Migration.FIVE_TO_SIX, provideVersion6Migrator(), Migration.SIX_TO_SEVEN, provideVersion7Migrator(), Migration.SEVEN_TO_EIGHT, provideVersion8Migrator());
    }

    @Override
    public Migrators migrators() {
      return new Migrators(mapOfMigrationAndMigrator(), MigrationModule_ProvideFileSystemCapabilityCheckerFactory.provideFileSystemCapabilityChecker(migrationModule));
    }
  }
}
